/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.fused;

import bdv.img.WarpedSource;
import bdv.tools.transformation.TransformedSource;
import bdv.util.DefaultInterpolators;
import bdv.util.source.alpha.AlphaSourceHelper;
import bdv.util.source.alpha.IAlphaSource;
import bdv.util.source.fused.AlphaFused3DRandomAccessible;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.operators.SetZero;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.cache.GlobalLoaderCache;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class AlphaFusedResampledSource<T extends RealType<T> & NativeType<T>>
implements Source<T> {
    public static final String SUM = "SUM";
    public static final String AVERAGE = "AVERAGE";
    public static final String MAX = "MAX";
    protected static Logger logger = LoggerFactory.getLogger(AlphaFusedResampledSource.class);
    final Collection<Source<T>> origins;
    transient ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, RandomAccessibleInterval<T>>> cachedRAIs = new ConcurrentHashMap();
    Source<?> resamplingModel;
    protected final DefaultInterpolators<T> interpolators = new DefaultInterpolators();
    protected Map<Source<T>, Interpolation> originsInterpolation;
    protected Map<Source<T>, IAlphaSource> originsAlpha = new HashMap<Source<T>, IAlphaSource>();
    final boolean reuseMipMaps;
    final int defaultMipMapLevel;
    boolean cache;
    private final String name;
    final int cacheX;
    final int cacheY;
    final int cacheZ;
    final String blendingMode;
    Map<Source<T>, Map<Integer, Integer>> mipmapModelToOrigin = new HashMap<Source<T>, Map<Integer, Integer>>();
    Map<Source<T>, List<Double>> originVoxSize = new HashMap<Source<T>, List<Double>>();
    final Supplier<T> pixelCreator;

    public AlphaFusedResampledSource(Collection<Source<T>> origins, String blendingMode, Source<T> resamplingModel, String name, boolean reuseMipMaps, boolean cache, Map<Source<T>, Interpolation> originsInterpolation, int defaultMipMapLevel, int cacheX, int cacheY, int cacheZ) {
        RealType t = (RealType)((RealType)origins.stream().findAny().get().getType()).createVariable();
        this.pixelCreator = () -> ((RealType)t).createVariable();
        this.blendingMode = blendingMode;
        this.origins = origins;
        this.resamplingModel = resamplingModel;
        this.name = name;
        this.reuseMipMaps = reuseMipMaps;
        this.cache = cache;
        this.originsInterpolation = originsInterpolation;
        this.defaultMipMapLevel = defaultMipMapLevel;
        for (Source<T> origin : origins) {
            this.computeMipMapsCorrespondance(origin);
            this.getAlpha(origin);
        }
        this.cacheX = cacheX;
        this.cacheY = cacheY;
        this.cacheZ = cacheZ;
    }

    private void getAlpha(Source<T> origin) {
        this.originsAlpha.put(origin, (IAlphaSource)AlphaSourceHelper.getOrBuildAlphaSource(origin).getSpimSource());
    }

    private int bestMatch(Source<T> origin, double voxSize) {
        int level;
        if (this.originVoxSize.get(origin) == null) {
            this.computeOriginSize(origin);
        }
        for (level = 0; this.originVoxSize.get(origin).get(level) < voxSize && level < this.originVoxSize.get(origin).size() - 1; ++level) {
        }
        return level;
    }

    private void computeOriginSize(Source<T> origin) {
        this.originVoxSize.put(origin, new ArrayList());
        Source rootOrigin = origin;
        while (rootOrigin instanceof WarpedSource || rootOrigin instanceof TransformedSource) {
            if (rootOrigin instanceof WarpedSource) {
                rootOrigin = ((WarpedSource)rootOrigin).getWrappedSource();
                continue;
            }
            rootOrigin = ((TransformedSource)rootOrigin).getWrappedSource();
        }
        for (int l = 0; l < rootOrigin.getNumMipmapLevels(); ++l) {
            AffineTransform3D at3d = new AffineTransform3D();
            rootOrigin.getSourceTransform(0, l, at3d);
            double mid = SourceAndConverterHelper.getCharacteristicVoxelSize((Source)origin, (int)0, (int)l);
            this.originVoxSize.get(origin).add(mid);
        }
    }

    private void computeMipMapsCorrespondance(Source<T> origin) {
        AffineTransform3D at3D = new AffineTransform3D();
        this.mipmapModelToOrigin.put(origin, new HashMap());
        for (int l = 0; l < this.resamplingModel.getNumMipmapLevels(); ++l) {
            if (this.reuseMipMaps) {
                this.resamplingModel.getSourceTransform(0, l, at3D);
                double middleDim = SourceAndConverterHelper.getCharacteristicVoxelSize((AffineTransform3D)at3D);
                int match = this.bestMatch(origin, middleDim);
                this.mipmapModelToOrigin.get(origin).put(l, match);
            } else {
                this.mipmapModelToOrigin.get(origin).put(l, this.defaultMipMapLevel);
            }
            logger.info("Model mipmap level " + l + " correspond to origin mipmap level " + this.mipmapModelToOrigin.get(origin).get(l));
            logger.info("Model mipmap level " + l + " has a characteristic voxel size of " + SourceAndConverterHelper.getCharacteristicVoxelSize(this.resamplingModel, (int)0, (int)l));
            logger.info("Origin level " + this.mipmapModelToOrigin.get(origin).get(l) + " has a characteristic voxel size of " + SourceAndConverterHelper.getCharacteristicVoxelSize(origin, (int)0, (int)this.mipmapModelToOrigin.get(origin).get(l)));
        }
    }

    public boolean isPresent(int t) {
        if (!this.resamplingModel.isPresent(t)) {
            return false;
        }
        for (Source<T> source : this.origins) {
            if (!source.isPresent(t)) continue;
            return true;
        }
        return false;
    }

    public Collection<Source<T>> getOriginalSources() {
        return this.origins;
    }

    public Source<?> getModelResamplerSource() {
        return this.resamplingModel;
    }

    public boolean areMipmapsReused() {
        return this.reuseMipMaps;
    }

    public boolean isCached() {
        return this.cache;
    }

    public Map<Source<T>, Interpolation> originsInterpolation() {
        return this.originsInterpolation;
    }

    public RandomAccessibleInterval<T> getSource(int t, int level) {
        long sx = this.resamplingModel.getSource(t, level).dimension(0);
        long sy = this.resamplingModel.getSource(t, level).dimension(1);
        long sz = this.resamplingModel.getSource(t, level).dimension(2);
        if (this.cache) {
            if (!this.cachedRAIs.containsKey(t)) {
                this.cachedRAIs.put(t, new ConcurrentHashMap());
            }
            if (!this.cachedRAIs.get(t).containsKey(level)) {
                if (this.cache) {
                    AlphaFused3DRandomAccessible nonCached = this.buildSource(t, level);
                    int[] blockSize = new int[]{this.cacheX, this.cacheY, this.cacheZ};
                    ArrayList<IAlphaSource> iteratedAlphaSources = new ArrayList<IAlphaSource>();
                    for (Source<T> origin : this.origins) {
                        if (!origin.isPresent(t)) continue;
                        iteratedAlphaSources.add(this.originsAlpha.get(origin));
                    }
                    IAlphaSource[] arrayAlphaSources = iteratedAlphaSources.toArray(new IAlphaSource[0]);
                    int nSources = arrayAlphaSources.length;
                    AffineTransform3D affineTransform = new AffineTransform3D();
                    this.getSourceTransform(t, level, affineTransform);
                    CellGrid grid = new CellGrid(new long[]{sx, sy, sz}, blockSize);
                    RealType type = (RealType)this.pixelCreator.get();
                    Cache cache = new GlobalLoaderCache((Object)this, t, level).withLoader((CacheLoader)LoadedCellCacheLoader.get((CellGrid)grid, cell -> {
                        Cursor out;
                        boolean[] sourcesPresentInCell = new boolean[nSources];
                        int nSourcesPresent = 0;
                        RandomAccess uniqueSource = null;
                        for (int i = 0; i < nSources; ++i) {
                            IAlphaSource alpha = arrayAlphaSources[i];
                            sourcesPresentInCell[i] = !alpha.doBoundingBoxCulling() ? true : alpha.intersectBox(affineTransform.copy(), (Interval)cell, t);
                            if (!sourcesPresentInCell[i] || ++nSourcesPresent != 1) continue;
                            uniqueSource = nonCached.origins[i].randomAccess();
                        }
                        if (nSourcesPresent > 1) {
                            RandomAccess nonCachedAccess = nonCached.randomAccess(sourcesPresentInCell);
                            out = Views.flatIterable((RandomAccessibleInterval)cell).cursor();
                            while (out.hasNext()) {
                                RealType t_in = (RealType)out.next();
                                nonCachedAccess.setPosition((Localizable)out);
                                t_in.set((Type)nonCachedAccess.get());
                            }
                        } else if (nSourcesPresent == 1) {
                            RandomAccess nonCachedAccess = uniqueSource;
                            out = Views.flatIterable((RandomAccessibleInterval)cell).cursor();
                            while (out.hasNext()) {
                                RealType t_in = (RealType)out.next();
                                nonCachedAccess.setPosition((Localizable)out);
                                t_in.set((Type)nonCachedAccess.get());
                            }
                        } else {
                            cell.forEach(rec$ -> ((SetZero)rec$).setZero());
                        }
                    }, (NativeType)((NativeType)this.pixelCreator.get()), (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
                    Object img = GenericByteType.class.isInstance(type) ? new CachedCellImg(grid, (NativeType)type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.BYTE, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (GenericShortType.class.isInstance(type) ? new CachedCellImg(grid, (NativeType)type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.SHORT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (GenericIntType.class.isInstance(type) ? new CachedCellImg(grid, (NativeType)type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.INT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (GenericLongType.class.isInstance(type) ? new CachedCellImg(grid, (NativeType)type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.LONG, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (FloatType.class.isInstance(type) ? new CachedCellImg(grid, (NativeType)type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.FLOAT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (DoubleType.class.isInstance(type) ? new CachedCellImg(grid, (NativeType)type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.DOUBLE, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : (ARGBType.class.isInstance(type) ? new CachedCellImg(grid, (NativeType)type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.INT, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE))) : null))))));
                    this.cachedRAIs.get(t).put(level, (RandomAccessibleInterval<T>)img);
                } else {
                    this.cachedRAIs.get(t).put(level, (RandomAccessibleInterval<T>)Views.interval(this.buildSource(t, level), (long[])new long[]{0L, 0L, 0L}, (long[])new long[]{sx, sy, sz}));
                }
            }
            return this.cachedRAIs.get(t).get(level);
        }
        return Views.interval(this.buildSource(t, level), (long[])new long[]{0L, 0L, 0L}, (long[])new long[]{sx, sy, sz});
    }

    public AlphaFused3DRandomAccessible<T> buildSource(int t, int level) {
        AffineTransform3D at_ori = new AffineTransform3D();
        this.resamplingModel.getSourceTransform(t, level, at_ori);
        at_ori = at_ori.inverse();
        ArrayList<RandomAccessible> presentSources = new ArrayList<RandomAccessible>();
        ArrayList<RandomAccessible> presentSourcesAlpha = new ArrayList<RandomAccessible>();
        for (Source<T> origin : this.origins) {
            if (!origin.isPresent(t)) continue;
            RealRandomAccessible ipimg = origin.getInterpolatedSource(t, this.mipmapModelToOrigin.get(origin).get(level).intValue(), this.originsInterpolation.get(origin));
            RealRandomAccessible ipimg_alpha = this.originsAlpha.get(origin).getInterpolatedSource(t, this.mipmapModelToOrigin.get(origin).get(level), Interpolation.NEARESTNEIGHBOR);
            AffineTransform3D at = new AffineTransform3D();
            at.set(at_ori);
            AffineTransform3D atOrigin = new AffineTransform3D();
            origin.getSourceTransform(t, this.mipmapModelToOrigin.get(origin).get(level).intValue(), atOrigin);
            at.concatenate(atOrigin);
            RandomAccessible ra = RealViews.simplify((RealRandomAccessible)RealViews.affine((RealRandomAccessible)ipimg, (AffineGet)at.copy()));
            at.set(at_ori);
            AffineTransform3D atOriginAlpha = new AffineTransform3D();
            this.originsAlpha.get(origin).getSourceTransform(t, this.mipmapModelToOrigin.get(origin).get(level), atOriginAlpha);
            at.concatenate(atOriginAlpha);
            RandomAccessible ra_alpha = RealViews.simplify((RealRandomAccessible)RealViews.affine((RealRandomAccessible)ipimg_alpha, (AffineGet)at));
            presentSources.add(ra);
            presentSourcesAlpha.add(ra_alpha);
        }
        return new AlphaFused3DRandomAccessible<RealType>(this.blendingMode, presentSources.toArray(new RandomAccessible[0]), presentSourcesAlpha.toArray(new RandomAccessible[0]), this::getType);
    }

    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        T zero = this.getType();
        zero.setZero();
        ExtendedRandomAccessibleInterval eView = Views.extendZero(this.getSource(t, level));
        RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)this.interpolators.get(method));
        return realRandomAccessible;
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.resamplingModel.getSourceTransform(t, level, transform);
    }

    public T getType() {
        return (T)((RealType)this.pixelCreator.get());
    }

    public String getName() {
        return this.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.resamplingModel.getVoxelDimensions();
    }

    public int getNumMipmapLevels() {
        return this.resamplingModel.getNumMipmapLevels();
    }

    public int getDefaultMipMapLevel() {
        return this.defaultMipMapLevel;
    }

    public long getCacheX() {
        return this.cacheX;
    }

    public long getCacheY() {
        return this.cacheY;
    }

    public long getCacheZ() {
        return this.cacheZ;
    }
}

