/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.fused;

import bdv.util.source.fused.AverageAlphaFused3DRandomAccess;
import bdv.util.source.fused.MaxAlphaFused3DRandomAccess;
import bdv.util.source.fused.SubSetFusedRandomAccess;
import bdv.util.source.fused.SumAlphaFused3DRandomAccess;
import java.util.function.Supplier;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class AlphaFused3DRandomAccessible<T extends RealType<T>>
implements RandomAccessible<T> {
    final RandomAccessible<T>[] origins;
    final RandomAccessible<FloatType>[] origins_alpha;
    final SubSetFusedRandomAccess<T> ra;
    final Supplier<T> pixelSupplier;
    final String blendingMode;

    public AlphaFused3DRandomAccessible(String blendingMode, RandomAccessible<T>[] origins, RandomAccessible<FloatType>[] origins_alpha, Supplier<T> pixelSupplier) {
        this.blendingMode = blendingMode;
        this.origins = origins;
        this.origins_alpha = origins_alpha;
        this.pixelSupplier = pixelSupplier;
        int l = origins.length;
        assert (origins.length == origins_alpha.length);
        RandomAccess[] origins_ra = new RandomAccess[origins.length];
        RandomAccess[] origins_alpha_ra = new RandomAccess[origins.length];
        for (int i = 0; i < l; ++i) {
            origins_ra[i] = origins[i].randomAccess();
            origins_alpha_ra[i] = origins_alpha[i].randomAccess();
        }
        switch (blendingMode) {
            case "AVERAGE": {
                this.ra = new AverageAlphaFused3DRandomAccess<T>(origins_ra, origins_alpha_ra, pixelSupplier);
                break;
            }
            case "MAX": {
                this.ra = new MaxAlphaFused3DRandomAccess<T>(origins_ra, origins_alpha_ra, pixelSupplier);
                break;
            }
            case "SUM": {
                this.ra = new SumAlphaFused3DRandomAccess<T>(origins_ra, origins_alpha_ra, pixelSupplier);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported blending method: " + blendingMode);
            }
        }
    }

    public RandomAccess<T> randomAccess() {
        return this.ra.copy();
    }

    public RandomAccess<T> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public RandomAccess<T> randomAccess(boolean[] sourcesPresentInCell) {
        return this.ra.copy(sourcesPresentInCell);
    }

    public int numDimensions() {
        return 3;
    }
}

