/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.field;

import bdv.util.source.field.ITransformFieldSource;
import bdv.viewer.Interpolation;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.position.FunctionRealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;

public class TransformFieldSource
implements ITransformFieldSource {
    final RealTransform transform;
    final int targetDimensions;
    final int sourceDimensions;
    final String name;

    public TransformFieldSource(RealTransform transform, String name) throws UnsupportedOperationException {
        this.transform = transform;
        this.sourceDimensions = transform.numSourceDimensions();
        this.targetDimensions = transform.numTargetDimensions();
        this.name = name;
    }

    public boolean isPresent(int t) {
        return true;
    }

    public RandomAccessibleInterval<RealPoint> getSource(int t, int level) {
        throw new UnsupportedOperationException("The raster source of a transform field source is not defined");
    }

    public RealRandomAccessible<RealPoint> getInterpolatedSource(int t, int level, Interpolation method) {
        RealTransform transformCopy = this.transform.copy();
        return new FunctionRealRandomAccessible(this.sourceDimensions, (position, value) -> transformCopy.apply(position, (RealPositionable)value), this::getType);
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.identity();
    }

    public RealPoint getType() {
        return new RealPoint(this.targetDimensions);
    }

    public String getName() {
        return this.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return new FinalVoxelDimensions("pixel", new double[]{1.0, 1.0, 1.0});
    }

    public int getNumMipmapLevels() {
        return 1;
    }

    @Override
    public int numSourceDimensions() {
        return this.transform.numSourceDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.transform.numTargetDimensions();
    }

    @Override
    public RealTransform getTransform() {
        return this.transform;
    }
}

