/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.field;

import bdv.util.source.field.ITransformFieldSource;
import bdv.util.source.field.NativeRealPoint3D;
import bdv.util.source.field.RealPoint3DInterpolatorFactory;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.util.concurrent.ConcurrentHashMap;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.algorithm.util.Grids;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.position.FunctionRealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.NativeType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class ResampledTransformFieldSource
implements ITransformFieldSource<NativeRealPoint3D> {
    final RealTransform origin;
    final Source<?> resamplingModel;
    final String name;
    final RealPoint3DInterpolatorFactory interpolator = new RealPoint3DInterpolatorFactory();
    final ThreadLocal<RealTransform> localTransform = new ThreadLocal();
    final transient ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, RandomAccessibleInterval<NativeRealPoint3D>>> cachedRAIs = new ConcurrentHashMap();

    public ResampledTransformFieldSource(RealTransform origin, Source resamplingModel, String name) throws UnsupportedOperationException {
        if (origin.numTargetDimensions() != 3 || origin.numSourceDimensions() != 3) {
            throw new UnsupportedOperationException("Only 3d to 3d transforms are supported");
        }
        this.origin = origin;
        this.resamplingModel = resamplingModel;
        this.name = name;
    }

    @Override
    public int numSourceDimensions() {
        return this.origin.numSourceDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.origin.numTargetDimensions();
    }

    @Override
    public RealTransform getTransform() {
        return this.origin;
    }

    public boolean isPresent(int t) {
        return this.resamplingModel.isPresent(t);
    }

    public RandomAccessibleInterval<NativeRealPoint3D> buildSource(int t, int level) {
        AffineTransform3D at = new AffineTransform3D();
        this.resamplingModel.getSourceTransform(t, level, at);
        long sx = this.resamplingModel.getSource(t, level).dimension(0) - 1L;
        long sy = this.resamplingModel.getSource(t, level).dimension(1) - 1L;
        long sz = this.resamplingModel.getSource(t, level).dimension(2) - 1L;
        FunctionRealRandomAccessible ipimg = new FunctionRealRandomAccessible(3, (location, value) -> {
            if (this.localTransform.get() == null) {
                this.localTransform.set(this.origin.copy());
            }
            this.localTransform.get().apply(location, (RealPositionable)value);
        }, this::getType);
        at = at.inverse();
        AffineRandomAccessible ra = RealViews.affine((RealRandomAccessible)ipimg, (AffineGet)at);
        IntervalView view = Views.interval((RandomAccessible)ra, (long[])new long[]{0L, 0L, 0L}, (long[])new long[]{sx, sy, sz});
        return view;
    }

    public RandomAccessibleInterval<NativeRealPoint3D> getSource(int t, int level) {
        if (!this.cachedRAIs.containsKey(t)) {
            this.cachedRAIs.put(t, new ConcurrentHashMap());
        }
        if (!this.cachedRAIs.get(t).containsKey(level)) {
            RandomAccessibleInterval<NativeRealPoint3D> nonCached = this.buildSource(t, level);
            int[] blockSize = new int[]{128, 128, 32};
            if (nonCached.dimension(0) < 128L) {
                blockSize[0] = (int)nonCached.dimension(0);
            }
            if (nonCached.dimension(1) < 128L) {
                blockSize[1] = (int)nonCached.dimension(1);
            }
            if (nonCached.dimension(2) < 32L) {
                blockSize[2] = (int)nonCached.dimension(2);
            }
            this.cachedRAIs.get(t).put(level, this.compute(nonCached, blockSize, this, t, level));
        }
        return this.cachedRAIs.get(t).get(level);
    }

    public RealRandomAccessible<NativeRealPoint3D> getInterpolatedSource(int t, int level, Interpolation method) {
        ExtendedRandomAccessibleInterval eView = Views.extendBorder(this.getSource(t, level));
        RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)this.interpolator);
        return realRandomAccessible;
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.resamplingModel.getSourceTransform(t, level, transform);
    }

    public NativeRealPoint3D getType() {
        return new NativeRealPoint3D();
    }

    public String getName() {
        return this.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.resamplingModel.getVoxelDimensions();
    }

    public int getNumMipmapLevels() {
        return this.resamplingModel.getNumMipmapLevels();
    }

    public RandomAccessibleInterval<NativeRealPoint3D> compute(RandomAccessibleInterval<NativeRealPoint3D> source, int[] blockSize, Object objectSource, int timepoint, int level) {
        ArrayImg deformationField = new ArrayImgFactory((NativeType)new NativeRealPoint3D()).create(source);
        Grids.collectAllContainedIntervals((long[])source.dimensionsAsLongArray(), (int[])blockSize).parallelStream().forEach(arg_0 -> ResampledTransformFieldSource.lambda$compute$1((RandomAccessibleInterval)deformationField, source, arg_0));
        return deformationField;
    }

    private static /* synthetic */ void lambda$compute$1(RandomAccessibleInterval deformationField, RandomAccessibleInterval source, Interval blockinterval) {
        Cursor targetCursor = Views.interval((RandomAccessible)deformationField, (Interval)blockinterval).localizingCursor();
        RandomAccess sourceRandomAccess = source.randomAccess();
        while (targetCursor.hasNext()) {
            targetCursor.fwd();
            sourceRandomAccess.setPosition((Localizable)targetCursor);
            ((NativeRealPoint3D)targetCursor.get()).set((NativeRealPoint3D)sourceRandomAccess.get());
        }
    }
}

