/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.field;

import bdv.util.source.field.NativeRealPoint3D;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccess;
import net.imglib2.position.transform.Floor;

public class RealPoint3DLinearInterpolator
extends Floor<RandomAccess<NativeRealPoint3D>>
implements RealRandomAccess<NativeRealPoint3D> {
    protected final NativeRealPoint3D accumulator = new NativeRealPoint3D();
    protected final NativeRealPoint3D tmp = new NativeRealPoint3D();

    protected RealPoint3DLinearInterpolator(RealPoint3DLinearInterpolator interpolator) {
        super((Localizable)((RandomAccess)interpolator.target).copyRandomAccess());
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = interpolator.position[d];
            this.discrete[d] = interpolator.discrete[d];
        }
    }

    protected RealPoint3DLinearInterpolator(RandomAccessible<NativeRealPoint3D> randomAccessible, NativeRealPoint3D type) {
        super((Localizable)randomAccessible.randomAccess());
    }

    protected RealPoint3DLinearInterpolator(RandomAccessible<NativeRealPoint3D> randomAccessible) {
        this(randomAccessible, (NativeRealPoint3D)randomAccessible.randomAccess().get());
    }

    public NativeRealPoint3D get() {
        double w0 = this.position[0] - (double)((RandomAccess)this.target).getLongPosition(0);
        double w0Inv = 1.0 - w0;
        double w1 = this.position[1] - (double)((RandomAccess)this.target).getLongPosition(1);
        double w1Inv = 1.0 - w1;
        double w2 = this.position[2] - (double)((RandomAccess)this.target).getLongPosition(2);
        double w2Inv = 1.0 - w2;
        float weights0 = (float)(w0Inv * w1Inv * w2Inv);
        float weights1 = (float)(w0 * w1Inv * w2Inv);
        float weights2 = (float)(w0Inv * w1 * w2Inv);
        float weights3 = (float)(w0 * w1 * w2Inv);
        float weights4 = (float)(w0Inv * w1Inv * w2);
        float weights5 = (float)(w0 * w1Inv * w2);
        float weights6 = (float)(w0Inv * w1 * w2);
        float weights7 = (float)(w0 * w1 * w2);
        this.accumulator.set((NativeRealPoint3D)((RandomAccess)this.target).get());
        this.accumulator.mul(weights0);
        ((RandomAccess)this.target).fwd(0);
        this.tmp.set((NativeRealPoint3D)((RandomAccess)this.target).get());
        this.tmp.mul(weights1);
        this.accumulator.move(this.tmp);
        ((RandomAccess)this.target).fwd(1);
        this.tmp.set((NativeRealPoint3D)((RandomAccess)this.target).get());
        this.tmp.mul(weights3);
        this.accumulator.move(this.tmp);
        ((RandomAccess)this.target).bck(0);
        this.tmp.set((NativeRealPoint3D)((RandomAccess)this.target).get());
        this.tmp.mul(weights2);
        this.accumulator.move(this.tmp);
        ((RandomAccess)this.target).fwd(2);
        this.tmp.set((NativeRealPoint3D)((RandomAccess)this.target).get());
        this.tmp.mul(weights6);
        this.accumulator.move(this.tmp);
        ((RandomAccess)this.target).fwd(0);
        this.tmp.set((NativeRealPoint3D)((RandomAccess)this.target).get());
        this.tmp.mul(weights7);
        this.accumulator.move(this.tmp);
        ((RandomAccess)this.target).bck(1);
        this.tmp.set((NativeRealPoint3D)((RandomAccess)this.target).get());
        this.tmp.mul(weights5);
        this.accumulator.move(this.tmp);
        ((RandomAccess)this.target).bck(0);
        this.tmp.set((NativeRealPoint3D)((RandomAccess)this.target).get());
        this.tmp.mul(weights4);
        this.accumulator.move(this.tmp);
        ((RandomAccess)this.target).bck(2);
        return this.accumulator;
    }

    public RealPoint3DLinearInterpolator copy() {
        return new RealPoint3DLinearInterpolator(this);
    }

    public RealPoint3DLinearInterpolator copyRealRandomAccess() {
        return this.copy();
    }
}

