/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.field;

import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;

public class NativeRealPoint3D
implements RealPositionable,
RealLocalizable,
NativeType<NativeRealPoint3D> {
    private static final NativeTypeFactory<NativeRealPoint3D, FloatAccess> typeFactory = NativeTypeFactory.FLOAT(NativeRealPoint3D::new);
    protected final NativeImg<?, ? extends FloatAccess> img;
    protected FloatAccess dataAccess;
    private final Index i;

    public NativeRealPoint3D() {
        this.i = new Index();
        this.img = null;
        this.dataAccess = new FloatArray(3);
    }

    public NativeRealPoint3D(NativeImg<?, ? extends FloatAccess> a) {
        this.i = new Index();
        this.img = a;
    }

    public NativeRealPoint3D(NativeRealPoint3D nativeRealPoint) {
        this.set(nativeRealPoint);
        this.i = new Index();
        this.img = null;
        this.dataAccess = new FloatArray(4);
    }

    public double getDoublePosition(int d) {
        return this.dataAccess.getValue((this.i.get() << 2) + d);
    }

    public float getFloatPosition(int d) {
        return this.dataAccess.getValue((this.i.get() << 2) + d);
    }

    public Fraction getEntitiesPerPixel() {
        return new Fraction(4L, 1L);
    }

    public NativeRealPoint3D duplicateTypeOnSameNativeImg() {
        return new NativeRealPoint3D(this.img);
    }

    public NativeTypeFactory<NativeRealPoint3D, ?> getNativeTypeFactory() {
        return typeFactory;
    }

    public void updateContainer(Object c) {
        this.dataAccess = (FloatAccess)this.img.update(c);
    }

    public Index index() {
        return this.i;
    }

    public NativeRealPoint3D createVariable() {
        return new NativeRealPoint3D();
    }

    public NativeRealPoint3D copy() {
        return new NativeRealPoint3D(this);
    }

    public void set(NativeRealPoint3D c) {
        int offsetTarget = this.i.get() << 2;
        int offsetSource = c.i.get() << 2;
        FloatAccess sourceAccess = c.dataAccess;
        this.dataAccess.setValue(offsetTarget + 0, sourceAccess.getValue(offsetSource + 0));
        this.dataAccess.setValue(offsetTarget + 1, sourceAccess.getValue(offsetSource + 1));
        this.dataAccess.setValue(offsetTarget + 2, sourceAccess.getValue(offsetSource + 2));
    }

    public boolean valueEquals(NativeRealPoint3D nativeRealPoint) {
        for (int d = 0; d < 3; ++d) {
            if (this.getDoublePosition(d) == nativeRealPoint.getDoublePosition(d)) continue;
            return false;
        }
        return true;
    }

    public void setPosition(NativeRealPoint3D nativeRealPoint) {
        this.set(nativeRealPoint);
    }

    public void mul(float alpha) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, alpha * this.dataAccess.getValue(offset + 0));
        this.dataAccess.setValue(offset + 1, alpha * this.dataAccess.getValue(offset + 1));
        this.dataAccess.setValue(offset + 2, alpha * this.dataAccess.getValue(offset + 2));
    }

    public void move(float distance, int d) {
        int offset = (this.i.get() << 2) + d;
        this.dataAccess.setValue(offset, distance + this.dataAccess.getValue(offset));
    }

    public void move(double distance, int d) {
        int offset = (this.i.get() << 2) + d;
        this.dataAccess.setValue(offset, (float)distance + this.dataAccess.getValue(offset));
    }

    public void move(NativeRealPoint3D point) {
        int offsetTarget = this.i.get() << 2;
        int offsetSource = point.i.get() << 2;
        FloatAccess sourceAccess = point.dataAccess;
        this.dataAccess.setValue(offsetTarget + 0, this.dataAccess.getValue(offsetTarget + 0) + sourceAccess.getValue(offsetSource + 0));
        this.dataAccess.setValue(offsetTarget + 1, this.dataAccess.getValue(offsetTarget + 1) + sourceAccess.getValue(offsetSource + 1));
        this.dataAccess.setValue(offsetTarget + 2, this.dataAccess.getValue(offsetTarget + 2) + sourceAccess.getValue(offsetSource + 2));
    }

    public void move(RealLocalizable distance) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, this.dataAccess.getValue(offset + 0) + distance.getFloatPosition(0));
        this.dataAccess.setValue(offset + 1, this.dataAccess.getValue(offset + 1) + distance.getFloatPosition(1));
        this.dataAccess.setValue(offset + 2, this.dataAccess.getValue(offset + 2) + distance.getFloatPosition(2));
    }

    public void move(float[] distance) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, this.dataAccess.getValue(offset + 0) + distance[0]);
        this.dataAccess.setValue(offset + 1, this.dataAccess.getValue(offset + 1) + distance[1]);
        this.dataAccess.setValue(offset + 2, this.dataAccess.getValue(offset + 2) + distance[2]);
    }

    public void move(double[] distance) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, this.dataAccess.getValue(offset + 0) + (float)distance[0]);
        this.dataAccess.setValue(offset + 1, this.dataAccess.getValue(offset + 1) + (float)distance[1]);
        this.dataAccess.setValue(offset + 2, this.dataAccess.getValue(offset + 2) + (float)distance[2]);
    }

    public void setPosition(RealLocalizable position) {
        this.setPosition(this.positionAsDoubleArray());
    }

    public void localize(double[] position) {
        int offset = this.i.get() << 2;
        position[0] = this.dataAccess.getValue(offset + 0);
        position[1] = this.dataAccess.getValue(offset + 1);
        position[2] = this.dataAccess.getValue(offset + 2);
    }

    public double[] positionAsDoubleArray() {
        int offset = this.i.get() << 2;
        return new double[]{this.dataAccess.getValue(offset + 0), this.dataAccess.getValue(offset + 1), this.dataAccess.getValue(offset + 2)};
    }

    public void setPosition(float[] position) {
        int offsetTarget = this.i.get() << 2;
        this.dataAccess.setValue(offsetTarget + 0, position[0]);
        this.dataAccess.setValue(offsetTarget + 1, position[1]);
        this.dataAccess.setValue(offsetTarget + 2, position[2]);
    }

    public void setPosition(double[] position) {
        int offsetTarget = this.i.get() << 2;
        this.dataAccess.setValue(offsetTarget + 0, (float)position[0]);
        this.dataAccess.setValue(offsetTarget + 1, (float)position[1]);
        this.dataAccess.setValue(offsetTarget + 2, (float)position[2]);
    }

    public void setPosition(float position, int d) {
        this.dataAccess.setValue((this.i.get() << 2) + d, position);
    }

    public void setPosition(double position, int d) {
        this.dataAccess.setValue((this.i.get() << 2) + d, (float)position);
    }

    public void fwd(int d) {
        int offset = (this.i.get() << 2) + d;
        this.dataAccess.setValue(offset, this.dataAccess.getValue(offset) + 1.0f);
    }

    public void bck(int d) {
        int offset = (this.i.get() << 2) + d;
        this.dataAccess.setValue(offset, this.dataAccess.getValue(offset) - 1.0f);
    }

    public void move(int distance, int d) {
        int offset = (this.i.get() << 2) + d;
        this.dataAccess.setValue(offset, this.dataAccess.getValue(offset) + (float)distance);
    }

    public void move(long distance, int d) {
        int offset = (this.i.get() << 2) + d;
        this.dataAccess.setValue(offset, this.dataAccess.getValue(offset) + (float)distance);
    }

    public void move(Localizable distance) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, this.dataAccess.getValue(offset + 0) + distance.getFloatPosition(0));
        this.dataAccess.setValue(offset + 1, this.dataAccess.getValue(offset + 1) + distance.getFloatPosition(1));
        this.dataAccess.setValue(offset + 2, this.dataAccess.getValue(offset + 2) + distance.getFloatPosition(2));
    }

    public void move(int[] distance) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, this.dataAccess.getValue(offset + 0) + (float)distance[0]);
        this.dataAccess.setValue(offset + 1, this.dataAccess.getValue(offset + 1) + (float)distance[1]);
        this.dataAccess.setValue(offset + 2, this.dataAccess.getValue(offset + 2) + (float)distance[2]);
    }

    public void move(long[] distance) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, this.dataAccess.getValue(offset + 0) + (float)distance[0]);
        this.dataAccess.setValue(offset + 1, this.dataAccess.getValue(offset + 1) + (float)distance[1]);
        this.dataAccess.setValue(offset + 2, this.dataAccess.getValue(offset + 2) + (float)distance[2]);
    }

    public void setPosition(Localizable position) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, position.getFloatPosition(0));
        this.dataAccess.setValue(offset + 1, position.getFloatPosition(1));
        this.dataAccess.setValue(offset + 2, position.getFloatPosition(2));
    }

    public void setPosition(int[] position) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, (float)position[0]);
        this.dataAccess.setValue(offset + 1, (float)position[1]);
        this.dataAccess.setValue(offset + 2, (float)position[2]);
    }

    public void setPosition(long[] position) {
        int offset = this.i.get() << 2;
        this.dataAccess.setValue(offset + 0, (float)position[0]);
        this.dataAccess.setValue(offset + 1, (float)position[1]);
        this.dataAccess.setValue(offset + 2, (float)position[2]);
    }

    public void setPosition(int position, int d) {
        this.dataAccess.setValue((this.i.get() << 2) + d, (float)position);
    }

    public void setPosition(long position, int d) {
        this.dataAccess.setValue((this.i.get() << 2) + d, (float)position);
    }

    public int numDimensions() {
        return 3;
    }
}

