/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.field;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;

public class NativeRealPoint
extends AbstractEuclideanSpace
implements RealPositionable,
RealLocalizable,
NativeType<NativeRealPoint> {
    final NativeTypeFactory<NativeRealPoint, FloatAccess> typeFactory;
    protected final NativeImg<?, ? extends FloatAccess> img;
    protected FloatAccess dataAccess;
    private final Index i;

    public NativeRealPoint(int n) {
        super(n);
        this.i = new Index();
        this.img = null;
        this.dataAccess = new FloatArray(n);
        this.typeFactory = NativeTypeFactory.FLOAT(a -> new NativeRealPoint(n, (NativeImg<?, ? extends FloatAccess>)a));
    }

    public NativeRealPoint(int n, NativeImg<?, ? extends FloatAccess> a) {
        super(n);
        this.i = new Index();
        this.img = a;
        this.typeFactory = NativeTypeFactory.FLOAT(access -> new NativeRealPoint(n, (NativeImg<?, ? extends FloatAccess>)access));
    }

    public NativeRealPoint(NativeRealPoint nativeRealPoint) {
        super(nativeRealPoint.n);
        this.set(nativeRealPoint);
        this.i = new Index();
        this.img = null;
        this.dataAccess = new FloatArray(this.n);
        this.typeFactory = NativeTypeFactory.FLOAT(a -> new NativeRealPoint(this.n, (NativeImg<?, ? extends FloatAccess>)a));
    }

    public double getDoublePosition(int d) {
        return this.dataAccess.getValue(this.i.get() * this.n + d);
    }

    public float getFloatPosition(int d) {
        return this.dataAccess.getValue(this.i.get() * this.n + d);
    }

    public Fraction getEntitiesPerPixel() {
        return new Fraction((long)this.n, 1L);
    }

    public NativeRealPoint duplicateTypeOnSameNativeImg() {
        return new NativeRealPoint(this.n, this.img);
    }

    public NativeTypeFactory<NativeRealPoint, ?> getNativeTypeFactory() {
        return this.typeFactory;
    }

    public void updateContainer(Object c) {
        this.dataAccess = (FloatAccess)this.img.update(c);
    }

    public Index index() {
        return this.i;
    }

    public NativeRealPoint createVariable() {
        return new NativeRealPoint(this.n);
    }

    public NativeRealPoint copy() {
        return new NativeRealPoint(this);
    }

    public void set(NativeRealPoint c) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, c.getFloatPosition(d));
        }
    }

    public boolean valueEquals(NativeRealPoint nativeRealPoint) {
        for (int d = 0; d < this.n; ++d) {
            if (this.getDoublePosition(d) == nativeRealPoint.getDoublePosition(d)) continue;
            return false;
        }
        return true;
    }

    public void setPosition(NativeRealPoint nativeRealPoint) {
        this.set(nativeRealPoint);
    }

    public void mul(float alpha) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, alpha * this.getFloatPosition(d));
        }
    }

    public void move(float distance, int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, distance + this.getFloatPosition(d));
    }

    public void move(double distance, int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, (float)distance + this.getFloatPosition(d));
    }

    public void move(RealLocalizable distance) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, distance.getFloatPosition(d) + this.getFloatPosition(d));
        }
    }

    public void move(float[] distance) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, distance[d] + this.getFloatPosition(d));
        }
    }

    public void move(double[] distance) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, (float)distance[d] + this.getFloatPosition(d));
        }
    }

    public void setPosition(RealLocalizable position) {
        this.setPosition(this.positionAsDoubleArray());
    }

    public void setPosition(float[] position) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, position[d]);
        }
    }

    public void setPosition(double[] position) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, (float)position[d]);
        }
    }

    public void setPosition(float position, int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, position);
    }

    public void setPosition(double position, int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, (float)position);
    }

    public void move(NativeRealPoint point) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, point.getFloatPosition(d) + this.getFloatPosition(d));
        }
    }

    public void fwd(int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, this.getFloatPosition(d) + 1.0f);
    }

    public void bck(int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, this.getFloatPosition(d) - 1.0f);
    }

    public void move(int distance, int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, (float)distance + this.getFloatPosition(d));
    }

    public void move(long distance, int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, (float)distance + this.getFloatPosition(d));
    }

    public void move(Localizable distance) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, (float)distance.getLongPosition(d) + this.getFloatPosition(d));
        }
    }

    public void move(int[] distance) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, (float)distance[d] + this.getFloatPosition(d));
        }
    }

    public void move(long[] distance) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, (float)distance[d] + this.getFloatPosition(d));
        }
    }

    public void setPosition(Localizable position) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, (float)position.getLongPosition(d));
        }
    }

    public void setPosition(int[] position) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, (float)position[d]);
        }
    }

    public void setPosition(long[] position) {
        int offset = this.i.get() * this.n;
        for (int d = 0; d < this.n; ++d) {
            this.dataAccess.setValue(offset + d, (float)position[d]);
        }
    }

    public void setPosition(int position, int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, (float)position);
    }

    public void setPosition(long position, int d) {
        this.dataAccess.setValue(this.i.get() * this.n + d, (float)position);
    }
}

