/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.alpha;

import bdv.img.WarpedSource;
import bdv.util.source.alpha.AlphaSource;
import bdv.util.source.alpha.AlphaSourceHelper;
import bdv.util.source.alpha.IAlphaSource;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.position.FunctionRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformRealRandomAccessible;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;

public class AlphaSourceWarped
extends AlphaSource {
    final WarpedSource<?> origin_warped;
    IAlphaSource origin_alpha;

    public AlphaSourceWarped(Source<?> origin) {
        super(origin);
        assert (origin instanceof WarpedSource);
        this.origin_warped = (WarpedSource)origin;
    }

    public AlphaSourceWarped(Source<?> origin, float alpha) {
        super(origin, alpha);
        this.origin_warped = (WarpedSource)origin;
    }

    public IAlphaSource getOriginAlpha() {
        if (this.origin_alpha == null) {
            this.origin_alpha = (IAlphaSource)AlphaSourceHelper.getOrBuildAlphaSource(((WarpedSource)this.origin).getWrappedSource()).getSpimSource();
        }
        return this.origin_alpha;
    }

    @Override
    public RandomAccessibleInterval<FloatType> getSource(int t, int level) {
        float finalAlpha = this.alpha;
        FunctionRandomAccessible randomAccessible = new FunctionRandomAccessible(3, () -> (loc, out) -> out.setReal(finalAlpha), FloatType::new);
        return Views.interval((RandomAccessible)randomAccessible, (Interval)new FinalInterval(new long[]{0L, 0L, 0L}, new long[]{1L, 1L, 1L}));
    }

    @Override
    public RealRandomAccessible<FloatType> getInterpolatedSource(int t, int level, Interpolation method) {
        RealRandomAccessible sourceRealAccessible = this.getOriginAlpha().getInterpolatedSource(t, level, method);
        if (this.origin_warped.isTransformed()) {
            AffineTransform3D transform = new AffineTransform3D();
            this.getOriginAlpha().getSourceTransform(t, level, transform);
            RealRandomAccessible srcRa = this.getOriginAlpha().getInterpolatedSource(t, level, method);
            if (this.origin_warped.getTransform() == null) {
                return srcRa;
            }
            RealTransformSequence seq = new RealTransformSequence();
            seq.add((RealTransform)transform);
            seq.add(this.origin_warped.getTransform().copy());
            seq.add((RealTransform)transform.inverse());
            return new RealTransformRealRandomAccessible(srcRa, (RealTransform)seq);
        }
        return sourceRealAccessible;
    }

    @Override
    public boolean intersectBox(AffineTransform3D affineTransform, Interval cell, int timepoint) {
        return true;
    }
}

