/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.alpha;

import bdv.util.source.alpha.AlphaSource;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.position.FunctionRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class AlphaSourceRAI
extends AlphaSource {
    public AlphaSourceRAI(Source<?> origin) {
        super(origin);
    }

    public AlphaSourceRAI(Source<?> origin, float alpha) {
        super(origin, alpha);
    }

    @Override
    public RandomAccessibleInterval<FloatType> getSource(int t, int level) {
        float finalAlpha = this.alpha;
        FunctionRandomAccessible randomAccessible = new FunctionRandomAccessible(3, () -> (loc, out) -> out.setReal(finalAlpha), FloatType::new);
        return Views.interval((RandomAccessible)randomAccessible, (Interval)this.origin.getSource(t, level));
    }

    @Override
    public RealRandomAccessible<FloatType> getInterpolatedSource(int t, int level, Interpolation method) {
        ExtendedRandomAccessibleInterval eView = Views.extendZero(this.getSource(t, level));
        RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)this.interpolators.get(Interpolation.NEARESTNEIGHBOR));
        return realRandomAccessible;
    }

    @Override
    public boolean intersectBox(AffineTransform3D affineTransform, Interval cell, int timepoint) {
        Box3D box_cell = new Box3D(affineTransform, cell);
        AffineTransform3D affineTransform3D = new AffineTransform3D();
        this.getSourceTransform(timepoint, 0, affineTransform3D);
        Box3D box_this = new Box3D(affineTransform3D, (Interval)this.getSource(timepoint, 0));
        return box_this.intersects(box_cell);
    }

    public static class Box3D {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        double minZ = Double.MAX_VALUE;
        double maxZ = -1.7976931348623157E308;

        public Box3D(AffineTransform3D affineTransform, Interval cell) {
            RealPoint p000 = new RealPoint(new float[]{cell.min(0) - 1L, cell.min(1) - 1L, cell.min(2) - 1L});
            RealPoint p001 = new RealPoint(new float[]{cell.min(0) - 1L, cell.min(1) - 1L, cell.max(2) + 1L});
            RealPoint p010 = new RealPoint(new float[]{cell.min(0) - 1L, cell.max(1) + 1L, cell.min(2) - 1L});
            RealPoint p011 = new RealPoint(new float[]{cell.min(0) - 1L, cell.max(1) + 1L, cell.max(2) + 1L});
            RealPoint p100 = new RealPoint(new float[]{cell.max(0) + 1L, cell.min(1) - 1L, cell.min(2) - 1L});
            RealPoint p101 = new RealPoint(new float[]{cell.max(0) + 1L, cell.min(1) - 1L, cell.max(2) + 1L});
            RealPoint p110 = new RealPoint(new float[]{cell.max(0) + 1L, cell.max(1) + 1L, cell.min(2) - 1L});
            RealPoint p111 = new RealPoint(new float[]{cell.max(0) + 1L, cell.max(1) + 1L, cell.max(2) + 1L});
            affineTransform.apply((RealLocalizable)p000, (RealPositionable)p000);
            affineTransform.apply((RealLocalizable)p001, (RealPositionable)p001);
            affineTransform.apply((RealLocalizable)p010, (RealPositionable)p010);
            affineTransform.apply((RealLocalizable)p011, (RealPositionable)p011);
            affineTransform.apply((RealLocalizable)p100, (RealPositionable)p100);
            affineTransform.apply((RealLocalizable)p101, (RealPositionable)p101);
            affineTransform.apply((RealLocalizable)p110, (RealPositionable)p110);
            affineTransform.apply((RealLocalizable)p111, (RealPositionable)p111);
            this.updatePoint(p000);
            this.updatePoint(p001);
            this.updatePoint(p010);
            this.updatePoint(p011);
            this.updatePoint(p100);
            this.updatePoint(p101);
            this.updatePoint(p110);
            this.updatePoint(p111);
        }

        private void updatePoint(RealPoint pt) {
            double px = pt.getDoublePosition(0);
            double py = pt.getDoublePosition(1);
            double pz = pt.getDoublePosition(2);
            if (px < this.minX) {
                this.minX = px;
            }
            if (px > this.maxX) {
                this.maxX = px;
            }
            if (py < this.minY) {
                this.minY = py;
            }
            if (py > this.maxY) {
                this.maxY = py;
            }
            if (pz < this.minZ) {
                this.minZ = pz;
            }
            if (pz > this.maxZ) {
                this.maxZ = pz;
            }
        }

        public boolean intersects(Box3D other) {
            if (other.maxX < this.minX) {
                return false;
            }
            if (other.minX > this.maxX) {
                return false;
            }
            if (other.maxY < this.minY) {
                return false;
            }
            if (other.minY > this.maxY) {
                return false;
            }
            if (other.maxZ < this.minZ) {
                return false;
            }
            return !(other.minZ > this.maxZ);
        }

        public String toString() {
            return "(" + this.minX + ":" + this.maxX + ")(" + this.minY + ":" + this.maxY + ")(" + this.minZ + ":" + this.maxZ + ")";
        }
    }
}

