/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.alpha;

import bdv.img.WarpedSource;
import bdv.tools.transformation.TransformedSource;
import bdv.util.source.alpha.AlphaConverter;
import bdv.util.source.alpha.AlphaSourceRAI;
import bdv.util.source.alpha.AlphaSourceTransformed;
import bdv.util.source.alpha.AlphaSourceWarped;
import bdv.util.source.alpha.IAlphaSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import com.amazonaws.services.kms.model.UnsupportedOperationException;
import java.util.List;
import java.util.Optional;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.real.FloatType;
import sc.fiji.bdvpg.services.ISourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class AlphaSourceHelper {
    public static final String ALPHA_SOURCE_KEY = "ALPHA_SOURCE";

    public static synchronized SourceAndConverter<FloatType> getOrBuildAlphaSource(Source source) {
        IAlphaSource alpha;
        if (source instanceof IAlphaSource) {
            throw new UnsupportedOperationException("Error : you can't make an alpha source out of an alpha source " + source.getName());
        }
        ISourceAndConverterService sacService = SourceAndConverterServices.getSourceAndConverterService();
        List sacList = sacService.getSourceAndConvertersFromSource(source);
        Optional<SourceAndConverter> source_already_associated_with_alpha = sacList.stream().filter(src -> AlphaSourceHelper.getExistingAlphaSource(src) != null).findFirst();
        if (source_already_associated_with_alpha.isPresent()) {
            return AlphaSourceHelper.getExistingAlphaSource(source_already_associated_with_alpha.get());
        }
        if (source instanceof WarpedSource) {
            alpha = new AlphaSourceWarped(source, 1.0f);
        } else if (source instanceof TransformedSource) {
            IAlphaSource iniAlpha = (IAlphaSource)AlphaSourceHelper.getOrBuildAlphaSource(((TransformedSource)source).getWrappedSource()).getSpimSource();
            alpha = new AlphaSourceTransformed(iniAlpha, (TransformedSource)source);
        } else {
            alpha = new AlphaSourceRAI(source, 1.0f);
        }
        SourceAndConverter alpha_sac = new SourceAndConverter((Source)alpha, (Converter)new AlphaConverter());
        sacList.forEach(compatibleSac -> SourceAndConverterServices.getSourceAndConverterService().setMetadata(compatibleSac, ALPHA_SOURCE_KEY, (Object)alpha_sac));
        return alpha_sac;
    }

    public static synchronized void setAlphaSource(SourceAndConverter source, IAlphaSource alphaSource) {
        SourceAndConverterServices.getSourceAndConverterService().setMetadata(source, ALPHA_SOURCE_KEY, (Object)new SourceAndConverter((Source)alphaSource, (Converter)new AlphaConverter()));
    }

    public static synchronized void setAlphaSource(SourceAndConverter source, SourceAndConverter alphaSource) {
        SourceAndConverterServices.getSourceAndConverterService().setMetadata(source, ALPHA_SOURCE_KEY, (Object)alphaSource);
    }

    public static synchronized SourceAndConverter<FloatType> getOrBuildAlphaSource(SourceAndConverter sac) {
        return AlphaSourceHelper.getOrBuildAlphaSource(sac.getSpimSource());
    }

    static SourceAndConverter<FloatType> getExistingAlphaSource(SourceAndConverter sac) {
        ISourceAndConverterService sacService = SourceAndConverterServices.getSourceAndConverterService();
        if (sacService.containsMetadata(sac, ALPHA_SOURCE_KEY)) {
            return (SourceAndConverter)sacService.getMetadata(sac, ALPHA_SOURCE_KEY);
        }
        return null;
    }
}

