/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.source.alpha;

import bdv.util.DefaultInterpolators;
import bdv.util.source.alpha.IAlphaSource;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.real.FloatType;

public abstract class AlphaSource
implements IAlphaSource {
    protected final DefaultInterpolators<FloatType> interpolators = new DefaultInterpolators();
    final Source<?> origin;
    final float alpha;

    public AlphaSource(Source<?> origin) {
        this(origin, 1.0f);
    }

    public AlphaSource(Source<?> origin, float alpha) {
        this.origin = origin;
        this.alpha = alpha;
    }

    public boolean isPresent(int t) {
        return this.origin.isPresent(t);
    }

    public abstract RandomAccessibleInterval<FloatType> getSource(int var1, int var2);

    public abstract RealRandomAccessible<FloatType> getInterpolatedSource(int var1, int var2, Interpolation var3);

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.origin.getSourceTransform(t, level, transform);
    }

    public FloatType getType() {
        return new FloatType();
    }

    public String getName() {
        return this.origin.getName() + "_alpha";
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.origin.getVoxelDimensions();
    }

    public int getNumMipmapLevels() {
        return this.origin.getNumMipmapLevels();
    }

    public boolean doBoundingBoxCulling() {
        return this.origin.doBoundingBoxCulling();
    }
}

