/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.slicer;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.outofbounds.OutOfBounds;

public class SlicerOutOfBounds<T>
extends AbstractLocalizable
implements OutOfBounds<T> {
    protected final RandomAccess<T> outOfBoundsRandomAccess;
    protected final long[] dimension;
    protected final long[] min;
    protected final long[] beforeMin;
    protected final long[] max;
    protected final long[] pastMax;
    protected final boolean[] dimIsOutOfBounds;
    protected boolean isOutOfBounds = false;
    final int shiftedAxis;
    final int displayerAxis;

    public SlicerOutOfBounds(SlicerOutOfBounds<T> outOfBounds) {
        super(outOfBounds.numDimensions());
        this.shiftedAxis = outOfBounds.shiftedAxis;
        this.displayerAxis = outOfBounds.displayerAxis;
        this.dimension = new long[this.n];
        this.min = new long[this.n];
        this.beforeMin = new long[this.n];
        this.max = new long[this.n];
        this.pastMax = new long[this.n];
        this.dimIsOutOfBounds = new boolean[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.dimension[d] = outOfBounds.dimension[d];
            this.min[d] = outOfBounds.min[d];
            this.beforeMin[d] = outOfBounds.beforeMin[d];
            this.max[d] = outOfBounds.max[d];
            this.pastMax[d] = outOfBounds.pastMax[d];
            this.position[d] = outOfBounds.position[d];
            this.dimIsOutOfBounds[d] = outOfBounds.dimIsOutOfBounds[d];
        }
        this.outOfBoundsRandomAccess = outOfBounds.outOfBoundsRandomAccess.copyRandomAccess();
    }

    public <F extends Interval & RandomAccessible<T>> SlicerOutOfBounds(F f, int shiftedAxis, int displayerAxis) {
        super(f.numDimensions());
        this.shiftedAxis = shiftedAxis;
        this.displayerAxis = displayerAxis;
        this.dimension = new long[this.n];
        f.dimensions(this.dimension);
        this.min = new long[this.n];
        f.min(this.min);
        this.max = new long[this.n];
        f.max(this.max);
        this.beforeMin = new long[this.n];
        this.pastMax = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.beforeMin[d] = this.min[d] - 1L;
            this.pastMax[d] = this.max[d] + 1L;
        }
        this.dimIsOutOfBounds = new boolean[this.n];
        this.outOfBoundsRandomAccess = ((RandomAccessible<T>)f).randomAccess();
    }

    protected final void checkOutOfBounds() {
        for (int d = 0; d < this.n; ++d) {
            if (!this.dimIsOutOfBounds[d]) continue;
            this.isOutOfBounds = true;
            return;
        }
        this.isOutOfBounds = false;
    }

    public boolean isOutOfBounds() {
        return this.isOutOfBounds;
    }

    public T get() {
        return (T)this.outOfBoundsRandomAccess.get();
    }

    public final SlicerOutOfBounds<T> copy() {
        return new SlicerOutOfBounds<T>(this);
    }

    public final SlicerOutOfBounds<T> copyRandomAccess() {
        return this.copy();
    }

    public final void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1L;
        long p = this.position[n];
        if (p == this.min[d]) {
            this.dimIsOutOfBounds[d] = false;
            this.checkOutOfBounds();
        } else if (p == this.pastMax[d]) {
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[d] = true;
        }
        long q = this.outOfBoundsRandomAccess.getLongPosition(d);
        if (q == this.max[d]) {
            this.outOfBoundsRandomAccess.setPosition(this.min[d], d);
        } else {
            this.outOfBoundsRandomAccess.fwd(d);
        }
    }

    public final void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1L;
        long p = this.position[n];
        if (p == this.beforeMin[d]) {
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[d] = true;
        } else if (p == this.max[d]) {
            this.dimIsOutOfBounds[d] = false;
            this.checkOutOfBounds();
        }
        long q = this.outOfBoundsRandomAccess.getLongPosition(d);
        if (q == this.min[d]) {
            this.outOfBoundsRandomAccess.setPosition(this.max[d], d);
        } else {
            this.outOfBoundsRandomAccess.bck(d);
        }
    }

    public final void setPosition(long position, int d) {
        this.position[d] = position;
        long minD = this.min[d];
        long maxD = this.max[d];
        if (position < minD) {
            if (d == 1) {
                int shiftZ = (int)((position - maxD) / this.dimension[d]);
                this.outOfBoundsRandomAccess.setPosition(this.outOfBoundsRandomAccess.getLongPosition(2) - (long)shiftZ, 2);
            }
            this.outOfBoundsRandomAccess.setPosition(maxD - (maxD - position) % this.dimension[d], d);
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[d] = true;
        } else if (position > maxD) {
            if (d == 1) {
                int shiftZ = (int)((position - maxD) / this.dimension[d]);
                this.outOfBoundsRandomAccess.setPosition(this.outOfBoundsRandomAccess.getLongPosition(2) - (long)shiftZ, 2);
            }
            this.outOfBoundsRandomAccess.setPosition(minD + (position - minD) % this.dimension[d], d);
            this.isOutOfBounds = true;
            this.dimIsOutOfBounds[d] = true;
        } else {
            if (d == this.shiftedAxis) {
                long posDisplayAxis = this.getLongPosition(this.displayerAxis);
                int shiftZ = (int)((posDisplayAxis - this.max[this.displayerAxis]) / this.dimension[this.displayerAxis]);
                this.outOfBoundsRandomAccess.setPosition(position + (long)shiftZ, d);
            } else {
                this.outOfBoundsRandomAccess.setPosition(position, d);
            }
            if (this.isOutOfBounds) {
                this.dimIsOutOfBounds[d] = false;
                this.checkOutOfBounds();
            }
        }
    }

    public void move(long distance, int d) {
        this.setPosition(this.getLongPosition(d) + distance, d);
    }

    public void move(int distance, int d) {
        this.move((long)distance, d);
    }

    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.move(localizable.getLongPosition(d), d);
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            this.move(distance[d], d);
        }
    }

    public void setPosition(int position, int d) {
        this.setPosition((long)position, d);
    }

    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.setPosition(localizable.getLongPosition(d), d);
        }
    }

    public void setPosition(int[] position) {
        for (int d = 0; d < position.length; ++d) {
            this.setPosition(position[d], d);
        }
    }

    public void setPosition(long[] position) {
        for (int d = 0; d < position.length; ++d) {
            this.setPosition(position[d], d);
        }
    }
}

