/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.projector.alpha;

import bdv.util.projector.alpha.ILayerAlphaProjectorFactory;
import bdv.util.projector.alpha.Layer;
import bdv.util.projector.alpha.LayerMetadata;
import bdv.util.projector.alpha.SourcesMetadata;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.render.AccumulateProjector;
import bdv.viewer.render.VolatileProjector;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ARGBType;

public class LayerAlphaIProjectorFactory
implements ILayerAlphaProjectorFactory {
    SourcesMetadata sourcesMeta;
    LayerMetadata layerMeta;

    public LayerAlphaIProjectorFactory() {
    }

    public LayerAlphaIProjectorFactory(SourcesMetadata sourcesMeta, LayerMetadata layerMeta) {
        this.setSourcesMeta(sourcesMeta);
        this.setLayerMeta(layerMeta);
    }

    @Override
    public void setSourcesMeta(SourcesMetadata sourcesMeta) {
        this.sourcesMeta = sourcesMeta;
    }

    @Override
    public void setLayerMeta(LayerMetadata layerMeta) {
        this.layerMeta = layerMeta;
    }

    public VolatileProjector createProjector(List<VolatileProjector> sourceProjectors, List<SourceAndConverter<?>> sources, List<? extends RandomAccessible<? extends ARGBType>> sourceScreenImages, RandomAccessibleInterval<ARGBType> targetScreenImage, int numThreads, ExecutorService executorService) {
        return new AccumulateProjectorARGBGeneric(this.sourcesMeta, this.layerMeta, sourceProjectors, sources, sourceScreenImages, targetScreenImage, numThreads, executorService);
    }

    private static double[] HSVFromRGB(double r, double g, double b) {
        double value = Math.max(r, Math.max(g, b));
        double chroma = value - Math.min(r, Math.min(g, b));
        double hue = 0.0;
        if (chroma > 0.0) {
            if (value == r) {
                hue = 42.0 * (0.0 + g - b) / chroma;
            }
            if (value == g) {
                hue = 42.0 * (2.0 + (b - r) / chroma);
            }
            if (value == b) {
                hue = 42.0 * (4.0 + (r - g) / chroma);
            }
        }
        hue = (hue + 256.0) % 256.0;
        double saturation = 0.0;
        if (value > 0.0) {
            saturation = chroma / value * 256.0;
        }
        return new double[]{hue, saturation, value};
    }

    private static double[] RGBFromHSV(double h, double s, double v) {
        double red = v - v * s / 256.0 * Math.max(0.0, Math.min((5.0 + h / 256.0 * 6.0) % 6.0, Math.min(4.0 - (5.0 + h / 256.0 * 6.0) % 6.0, 1.0)));
        double green = v - v * s / 256.0 * Math.max(0.0, Math.min((3.0 + h / 256.0 * 6.0) % 6.0, Math.min(4.0 - (3.0 + h / 256.0 * 6.0) % 6.0, 1.0)));
        double blue = v - v * s / 256.0 * Math.max(0.0, Math.min((1.0 + h / 256.0 * 6.0) % 6.0, Math.min(4.0 - (1.0 + h / 256.0 * 6.0) % 6.0, 1.0)));
        return new double[]{red, green, blue};
    }

    public static class AccumulateProjectorARGBGeneric
    extends AccumulateProjector<ARGBType, ARGBType> {
        final boolean[] source_is_alpha;
        final boolean[] source_has_alpha;
        final int[] source_linked_alpha_source_index;
        final int[] sources_sorted_indices;
        final boolean[] source_layer_skip;
        final float[] source_layer_alpha;
        final int[] source_layer_mode;
        final boolean[] source_layer_next;

        public AccumulateProjectorARGBGeneric(SourcesMetadata sourcesMeta, LayerMetadata layerMeta, List<VolatileProjector> sourceProjectors, List<SourceAndConverter<?>> sources, List<? extends RandomAccessible<? extends ARGBType>> sourceScreenImages, RandomAccessibleInterval<ARGBType> target, int numThreads, ExecutorService executorService) {
            super(sourceProjectors, sourceScreenImages, target);
            this.source_linked_alpha_source_index = new int[sources.size()];
            this.source_is_alpha = new boolean[sources.size()];
            this.source_has_alpha = new boolean[sources.size()];
            for (int index_source = 0; index_source < sources.size(); ++index_source) {
                SourceAndConverter<?> source = sources.get(index_source);
                if (sourcesMeta.isAlphaSource(source)) {
                    this.source_is_alpha[index_source] = true;
                    continue;
                }
                if (sourcesMeta.hasAlphaSource(source)) {
                    int index_alpha_source = sources.indexOf(sourcesMeta.getAlphaSource(source));
                    if (index_alpha_source != -1) {
                        this.source_has_alpha[index_source] = true;
                        this.source_linked_alpha_source_index[index_source] = index_alpha_source;
                        continue;
                    }
                    this.source_has_alpha[index_source] = false;
                    continue;
                }
                this.source_has_alpha[index_source] = false;
            }
            Layer[] layer_array = new Layer[sources.size()];
            for (int index_source = 0; index_source < sources.size(); ++index_source) {
                layer_array[index_source] = layerMeta.getLayer(sources.get(index_source));
            }
            this.sources_sorted_indices = IntStream.range(0, sources.size()).boxed().sorted(Comparator.comparing(index -> layerMeta.getLayer((SourceAndConverter)sources.get((int)index)), Comparable::compareTo)).mapToInt(i -> i).toArray();
            this.source_layer_skip = new boolean[sources.size()];
            this.source_layer_alpha = new float[sources.size()];
            this.source_layer_mode = new int[sources.size()];
            this.source_layer_next = new boolean[sources.size()];
            for (int i2 = 0; i2 < sources.size(); ++i2) {
                int source_index = this.sources_sorted_indices[i2];
                Layer current_layer = layer_array[source_index];
                this.source_layer_skip[source_index] = current_layer.skip();
                this.source_layer_alpha[source_index] = current_layer.getAlpha();
                this.source_layer_mode[source_index] = current_layer.getBlendingMode();
                this.source_layer_next[source_index] = i2 == sources.size() - 1 ? true : current_layer.compareTo(layer_array[this.sources_sorted_indices[i2 + 1]]) != 0;
            }
        }

        protected void accumulate(Cursor<? extends ARGBType>[] accesses, ARGBType target) {
            int aSum = 255;
            int rSum = 255;
            int gSum = 255;
            int bSum = 255;
            int aLayer = 0;
            int rLayer = 0;
            int gLayer = 0;
            int bLayer = 0;
            int nSources = 0;
            float totalAlpha = 0.0f;
            for (int i = 0; i < accesses.length; ++i) {
                int current_source_index = this.sources_sorted_indices[i];
                boolean skip_current_layer = this.source_layer_skip[current_source_index];
                if (!skip_current_layer && !this.source_is_alpha[current_source_index]) {
                    if (this.source_has_alpha[current_source_index]) {
                        Cursor<? extends ARGBType> access = accesses[current_source_index];
                        Cursor<? extends ARGBType> access_alpha = accesses[this.source_linked_alpha_source_index[current_source_index]];
                        float alpha = Float.intBitsToFloat(((ARGBType)access_alpha.get()).get());
                        int value = ((ARGBType)access.get()).get();
                        int a = (int)((float)ARGBType.alpha((int)value) * alpha);
                        int r = (int)((float)ARGBType.red((int)value) * alpha);
                        int g = (int)((float)ARGBType.green((int)value) * alpha);
                        int b = (int)((float)ARGBType.blue((int)value) * alpha);
                        if (a != 0) {
                            aLayer += a;
                            rLayer += r;
                            gLayer += g;
                            bLayer += b;
                            if (alpha > 0.0f) {
                                ++nSources;
                            }
                            totalAlpha += alpha;
                        }
                    } else {
                        int value = ((ARGBType)accesses[current_source_index].get()).get();
                        int a = ARGBType.alpha((int)value);
                        int r = ARGBType.red((int)value);
                        int g = ARGBType.green((int)value);
                        int b = ARGBType.blue((int)value);
                        if (a != 0) {
                            aLayer += a;
                            rLayer += r;
                            gLayer += g;
                            bLayer += b;
                            ++nSources;
                            totalAlpha += 1.0f;
                        }
                    }
                }
                if (!this.source_layer_next[current_source_index]) continue;
                if (nSources > 0 && !skip_current_layer) {
                    float alpha = this.source_layer_alpha[current_source_index] * totalAlpha / (float)nSources;
                    aSum = (int)((1.0f - alpha) * (float)aSum + alpha * (float)aLayer);
                    rSum = (int)((1.0f - alpha) * (float)rSum + alpha * (float)rLayer);
                    gSum = (int)((1.0f - alpha) * (float)gSum + alpha * (float)gLayer);
                    bSum = (int)((1.0f - alpha) * (float)bSum + alpha * (float)bLayer);
                }
                aLayer = 0;
                rLayer = 0;
                gLayer = 0;
                bLayer = 0;
                nSources = 0;
                totalAlpha = 0.0f;
            }
            if (aSum > 255) {
                aSum = 255;
            }
            if (rSum > 255) {
                rSum = 255;
            }
            if (gSum > 255) {
                gSum = 255;
            }
            if (bSum > 255) {
                bSum = 255;
            }
            double[] HSV = LayerAlphaIProjectorFactory.HSVFromRGB(255 - rSum, 255 - gSum, 255 - bSum);
            HSV[0] = (HSV[0] + 128.0) % 256.0;
            double[] RGB = LayerAlphaIProjectorFactory.RGBFromHSV(HSV[0], HSV[1], HSV[2]);
            rSum = (byte)Math.round(RGB[0]);
            gSum = (byte)Math.round(RGB[1]);
            bSum = (byte)Math.round(RGB[2]);
            target.set(ARGBType.rgba((int)rSum, (int)gSum, (int)bSum, (int)aSum));
        }
    }
}

