/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.ZSlicedSource;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.sourceandconverter.transform.SourceMosaicZSlicer;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.scijava.adapter.source.ISourceAdapter;
import sc.fiji.bdvpg.services.SourceAndConverterAdapter;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

@Plugin(type=ISourceAdapter.class)
public class ZSlicedSourceAdapter
implements ISourceAdapter<ZSlicedSource> {
    private static Logger logger = LoggerFactory.getLogger(ZSlicedSourceAdapter.class);
    SourceAndConverterAdapter sacSerializer;

    public void setSacSerializer(SourceAndConverterAdapter sacSerializer) {
        this.sacSerializer = sacSerializer;
    }

    public Class<ZSlicedSource> getSourceClass() {
        return ZSlicedSource.class;
    }

    public JsonElement serialize(SourceAndConverter sac, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        ZSlicedSource source = (ZSlicedSource)sac.getSpimSource();
        obj.addProperty("type", ZSlicedSource.class.getSimpleName());
        obj.add("interpolate", jsonSerializationContext.serialize((Object)source.originInterpolation()));
        obj.addProperty("cache", Boolean.valueOf(source.isCached()));
        obj.addProperty("mipmaps_reused", Boolean.valueOf(source.areMipmapsReused()));
        Integer idOrigin = (Integer)this.sacSerializer.getSourceToId().get(source.getOriginalSource());
        Integer idModel = (Integer)this.sacSerializer.getSourceToId().get(source.getModelResamplerSource());
        if (idOrigin == null) {
            logger.error("The resampled source " + source.getOriginalSource().getName() + " couldn't be serialized : origin source not identified.");
            return null;
        }
        if (idModel == null) {
            logger.error("The resampled source " + source.getOriginalSource().getName() + " couldn't be serialized : model source not identified.");
            return null;
        }
        obj.addProperty("origin_source_id", (Number)idOrigin);
        obj.addProperty("model_source_id", (Number)idModel);
        return obj;
    }

    public SourceAndConverter deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        SourceAndConverter modelSac;
        JsonElement element;
        SourceAndConverter originSac;
        JsonObject obj = jsonElement.getAsJsonObject();
        int origin_source_id = obj.getAsJsonPrimitive("origin_source_id").getAsInt();
        int model_source_id = obj.getAsJsonPrimitive("model_source_id").getAsInt();
        Interpolation interpolation = (Interpolation)jsonDeserializationContext.deserialize(obj.get("interpolate"), Interpolation.class);
        boolean cache = obj.getAsJsonPrimitive("cache").getAsBoolean();
        boolean reuseMipMaps = obj.getAsJsonPrimitive("mipmaps_reused").getAsBoolean();
        if (this.sacSerializer.getIdToSac().containsKey(origin_source_id)) {
            originSac = (SourceAndConverter)this.sacSerializer.getIdToSac().get(origin_source_id);
        } else {
            element = (JsonElement)this.sacSerializer.idToJsonElement.get(origin_source_id);
            originSac = (SourceAndConverter)this.sacSerializer.getGson().fromJson(element, SourceAndConverter.class);
        }
        if (this.sacSerializer.getIdToSac().containsKey(model_source_id)) {
            modelSac = (SourceAndConverter)this.sacSerializer.getIdToSac().get(model_source_id);
        } else {
            element = (JsonElement)this.sacSerializer.idToJsonElement.get(model_source_id);
            modelSac = (SourceAndConverter)this.sacSerializer.getGson().fromJson(element, SourceAndConverter.class);
        }
        if (originSac == null) {
            logger.error("Couldn't deserialize origin source in ZSliced Source");
            return null;
        }
        if (modelSac == null) {
            logger.error("Couldn't deserialize model source in ZSliced Source");
            return null;
        }
        SourceAndConverter sac = new SourceMosaicZSlicer(originSac, modelSac, reuseMipMaps, cache, interpolation.equals((Object)Interpolation.NLINEAR), () -> 1L).get();
        SourceAndConverterServices.getSourceAndConverterService().register(sac);
        return sac;
    }
}

