/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.ResampledSource;
import bdv.util.slicer.SlicerViews;
import bdv.viewer.Source;
import java.util.function.Supplier;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;

public class ZSlicedSource<T extends NumericType<T> & NativeType<T>>
extends ResampledSource<T> {
    Supplier<Long> subSampler = () -> 1L;

    public ZSlicedSource(Source source, Source resamplingModel, String name, boolean reuseMipMaps, boolean cache, boolean originInterpolation, Supplier<Long> subSampler) {
        super(source, resamplingModel, name, reuseMipMaps, cache, originInterpolation, 0);
        this.subSampler = subSampler;
    }

    public ZSlicedSource(Source source, Source resamplingModel, String name, boolean reuseMipMaps, boolean cache, boolean originInterpolation) {
        super(source, resamplingModel, name, reuseMipMaps, cache, originInterpolation, 0);
    }

    public RandomAccessibleInterval<T> buildSource(int t, int level) {
        RandomAccessibleInterval nonResliced = super.buildSource(t, level);
        nonResliced = Views.subsample((RandomAccessibleInterval)nonResliced, (long[])new long[]{1L, 1L, this.subSampler.get()});
        return Views.interval(SlicerViews.extendSlicer(nonResliced, 2, 0), (Interval)new FinalInterval(new long[]{nonResliced.dimension(0) * nonResliced.dimension(2), nonResliced.dimension(1), nonResliced.dimension(2)}));
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.resamplingModel.getSourceTransform(t, level, transform);
        transform.set(0.0, 0, 3);
        transform.set(0.0, 1, 3);
        transform.set(0.0, 2, 3);
        double xScale = ZSlicedSource.getNormTransform(0, transform);
        double yScale = ZSlicedSource.getNormTransform(1, transform);
        double zScale = ZSlicedSource.getNormTransform(2, transform);
        transform.identity();
        transform.scale(xScale, yScale, zScale);
    }

    public static double getNormTransform(int axis, AffineTransform3D t) {
        double f0 = t.get(0, axis);
        double f1 = t.get(1, axis);
        double f2 = t.get(2, axis);
        return Math.sqrt(f0 * f0 + f1 * f1 + f2 * f2);
    }
}

