/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.source.field.ITransformFieldSource;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealViews;

public class SourcedRealTransform
implements RealTransform {
    final ITransformFieldSource source;
    final RealRandomAccessible<RealLocalizable> realRandomAccess;
    final AffineTransform3D transform3D = new AffineTransform3D();

    public SourcedRealTransform(ITransformFieldSource source) {
        this.source = source;
        source.getSourceTransform(0, 0, this.transform3D);
        this.realRandomAccess = RealViews.affine((RealRandomAccessible)source.getInterpolatedSource(0, 0, null), (AffineGet)this.transform3D);
    }

    public int numSourceDimensions() {
        return this.source.numSourceDimensions();
    }

    public int numTargetDimensions() {
        return this.source.numTargetDimensions();
    }

    public void apply(double[] source, double[] target) {
        double[] result = ((RealLocalizable)this.realRandomAccess.getAt(source)).positionAsDoubleArray();
        System.arraycopy(result, 0, target, 0, target.length);
    }

    public void apply(RealLocalizable realLocalizable, RealPositionable realPositionable) {
        realPositionable.setPosition(((RealLocalizable)this.realRandomAccess.getAt(realLocalizable)).positionAsDoubleArray());
    }

    public RealTransform copy() {
        return new SourcedRealTransform(this.source);
    }

    public RealTransform getTransform() {
        return this.source.getTransform();
    }
}

