/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.BoundedRealTransform;
import bdv.util.SourcedRealTransform;
import bdv.util.source.field.ResampledTransformFieldSource;
import bdv.viewer.Source;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ThinPlateSplineTransformAdapter;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.Wrapped2DTransformAs3D;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealTransformHelper {
    private static Logger logger = LoggerFactory.getLogger(RealTransformHelper.class);

    public static String BigWarpFileFromRealTransform(RealTransform rt) {
        try {
            File file = File.createTempFile("bigwarp-", "csv");
            file.deleteOnExit();
            if (rt instanceof Wrapped2DTransformAs3D) {
                rt = ((Wrapped2DTransformAs3D)rt).transform;
            }
            if (rt instanceof InvertibleWrapped2DTransformAs3D) {
                rt = ((InvertibleWrapped2DTransformAs3D)rt).transform;
            }
            if (rt instanceof WrappedIterativeInvertibleRealTransform) {
                rt = ((WrappedIterativeInvertibleRealTransform)rt).getTransform();
            }
            if (rt instanceof BoundedRealTransform) {
                if ((rt = ((BoundedRealTransform)rt).getTransform()) instanceof Wrapped2DTransformAs3D) {
                    rt = ((Wrapped2DTransformAs3D)rt).transform;
                }
                if (rt instanceof InvertibleWrapped2DTransformAs3D) {
                    rt = ((InvertibleWrapped2DTransformAs3D)rt).transform;
                }
                if (rt instanceof WrappedIterativeInvertibleRealTransform) {
                    rt = ((WrappedIterativeInvertibleRealTransform)rt).getTransform();
                }
            }
            if (!(rt instanceof ThinplateSplineTransform)) {
                logger.error("Cannot edit the transform : it's not of class thinplatesplinetransform");
                return null;
            }
            ThinplateSplineTransform tst = (ThinplateSplineTransform)rt;
            ThinPlateR2LogRSplineKernelTransform kernel = ThinPlateSplineTransformAdapter.getKernel((ThinplateSplineTransform)tst);
            double[][] srcPts = ThinPlateSplineTransformAdapter.getSrcPts((ThinPlateR2LogRSplineKernelTransform)kernel);
            double[][] tgtPts = ThinPlateSplineTransformAdapter.getTgtPts((ThinPlateR2LogRSplineKernelTransform)kernel);
            int nbLandmarks = kernel.getNumLandmarks();
            int nbDimensions = kernel.getNumDims();
            String toFile = "";
            for (int i = 0; i < nbLandmarks; ++i) {
                int d;
                toFile = toFile + "\"Pt-" + i + "\",\"true\"";
                for (d = 0; d < nbDimensions; ++d) {
                    toFile = toFile + ",\"" + tgtPts[d][i] + "\"";
                }
                for (d = 0; d < nbDimensions; ++d) {
                    toFile = toFile + ",\"" + srcPts[d][i] + "\"";
                }
                toFile = toFile + "\n";
            }
            FileWriter writer = new FileWriter(file);
            writer.write(toFile);
            writer.flush();
            writer.close();
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RealTransform resampleTransform(RealTransform origin, Source<?> model) {
        ResampledTransformFieldSource transformFieldSource = new ResampledTransformFieldSource(origin, model, "undef");
        return new SourcedRealTransform(transformFieldSource);
    }
}

