/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import net.imglib2.FinalRealInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealViews;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class RealCropper {
    public static <T extends RealType<T>> RandomAccessibleInterval<T> getCroppedSampledRRAI(RealRandomAccessible<T> rra, AffineTransform3D at3D, RealInterval ri, double xPixelSize, double yPixelSize, double zPixelSize) {
        at3D.scale(1.0 / xPixelSize, 1.0 / yPixelSize, 1.0 / zPixelSize);
        AffineRandomAccessible ra = RealViews.affine(rra, (AffineGet)at3D);
        IntervalView view = Views.interval((RandomAccessible)ra, (long[])new long[]{(long)(ri.realMin(0) / xPixelSize), (long)(ri.realMin(1) / yPixelSize), (long)(ri.realMin(2) / zPixelSize)}, (long[])new long[]{(long)(ri.realMax(0) / xPixelSize), (long)(ri.realMax(1) / yPixelSize), (long)(ri.realMax(2) / zPixelSize)});
        return view;
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> getCroppedSampledRRAI(RealRandomAccessible<T> rra, double px, double py, double pz, double real_w, double real_h, double real_depth, double pxSize) {
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.identity();
        at3D.translate(new double[]{px, py, pz});
        FinalRealInterval fi = new FinalRealInterval(new double[]{0.0, 0.0, 0.0}, new double[]{real_w, real_h, real_depth});
        return RealCropper.getCroppedSampledRRAI(rra, at3D, (RealInterval)fi, pxSize, pxSize, pxSize);
    }
}

