/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.OpenersImageLoader;
import ch.epfl.biop.bdv.img.legacy.qupath.entity.QuPathEntryEntity;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import java.io.File;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterInspector;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class QuPathBdvHelper {
    public static File getDataEntryFolder(SourceAndConverter<?> source) throws IllegalArgumentException {
        boolean result;
        File quPathProject = QuPathBdvHelper.getProjectFile(source);
        int entryId = QuPathBdvHelper.getEntryId(source);
        if (!new File(quPathProject.getParent()).exists()) {
            throw new IllegalArgumentException("QuPath parent folder " + quPathProject.getParent() + " does not exist.");
        }
        File f = new File(quPathProject.getParent(), "data" + File.separator + entryId);
        if (!f.exists() && !(result = f.mkdirs())) {
            throw new IllegalArgumentException("Impossible to create QuPath entry folder " + f.getAbsolutePath());
        }
        return f;
    }

    public static File getProjectFile(SourceAndConverter<?> source_in) throws IllegalArgumentException {
        SourceAndConverter rootSource = SourceAndConverterInspector.getRootSourceAndConverter(source_in);
        if (!QuPathBdvHelper.isBoundToLegacyQuPathBDVDataset(rootSource)) {
            AbstractSpimData asd = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter)rootSource, (String)"SPIMDATA")).asd;
            int viewSetupId = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter)rootSource, (String)"SPIMDATA")).setupId;
            if (!asd.getSequenceDescription().getImgLoader().getClass().equals(OpenersImageLoader.class)) {
                throw new IllegalArgumentException("The source " + source_in.getSpimSource().getName() + " is not associated to a QuPath Dataset");
            }
            OpenersImageLoader imgLoader = (OpenersImageLoader)asd.getSequenceDescription().getImgLoader();
            int openerId = ((OpenersImageLoader.OpenerAndChannelIndex)imgLoader.getViewSetupToOpenerAndChannelIndex().get(viewSetupId)).getOpenerIndex();
            OpenerSettings settings = (OpenerSettings)imgLoader.getOpenerSettings().get(openerId);
            if (settings.getType().equals((Object)OpenerSettings.OpenerType.QUPATH)) {
                return new File(settings.getLocation());
            }
            throw new IllegalArgumentException("The source " + source_in.getSpimSource().getName() + " is not associated to a QuPath project");
        }
        QuPathEntryEntity entity = QuPathBdvHelper.getQuPathEntityFromSource(rootSource);
        return QuPathBdvHelper.getProjectFile(entity);
    }

    public static boolean isSourceLinkedToQuPath(SourceAndConverter<?> source) {
        try {
            File f = QuPathBdvHelper.getProjectFile(source);
            return f.exists();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static int getEntryId(SourceAndConverter<?> source) throws IllegalArgumentException {
        SourceAndConverter rootSource = SourceAndConverterInspector.getRootSourceAndConverter(source);
        if (!QuPathBdvHelper.isBoundToLegacyQuPathBDVDataset(rootSource)) {
            AbstractSpimData asd = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter)rootSource, (String)"SPIMDATA")).asd;
            int viewSetupId = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter)rootSource, (String)"SPIMDATA")).setupId;
            if (!asd.getSequenceDescription().getImgLoader().getClass().equals(OpenersImageLoader.class)) {
                throw new IllegalArgumentException("The source " + source.getSpimSource().getName() + " is not associated to a QuPath Dataset");
            }
            OpenersImageLoader imgLoader = (OpenersImageLoader)asd.getSequenceDescription().getImgLoader();
            int openerId = ((OpenersImageLoader.OpenerAndChannelIndex)imgLoader.getViewSetupToOpenerAndChannelIndex().get(viewSetupId)).getOpenerIndex();
            OpenerSettings settings = (OpenerSettings)imgLoader.getOpenerSettings().get(openerId);
            if (settings.getType().equals((Object)OpenerSettings.OpenerType.QUPATH)) {
                return settings.getEntryId();
            }
            throw new IllegalArgumentException("The source " + source.getSpimSource().getName() + " is not associated to a QuPath project");
        }
        return QuPathBdvHelper.getQuPathEntityFromSource(rootSource).getId();
    }

    private static boolean isBoundToLegacyQuPathBDVDataset(SourceAndConverter<?> testSource) throws IllegalArgumentException {
        if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(testSource, "SPIMDATA") == null) {
            throw new IllegalArgumentException("No BDV dataset is associated with the source " + testSource.getSpimSource().getName());
        }
        AbstractSpimData asd = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(testSource, (String)"SPIMDATA")).asd;
        int viewSetupId = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata(testSource, (String)"SPIMDATA")).setupId;
        BasicViewSetup bvs = (BasicViewSetup)asd.getSequenceDescription().getViewSetups().get(viewSetupId);
        return bvs.getAttribute(QuPathEntryEntity.class) != null;
    }

    @Deprecated
    private static QuPathEntryEntity getQuPathEntityFromSource(SourceAndConverter<?> source_in) {
        SourceAndConverter rootSource = SourceAndConverterInspector.getRootSourceAndConverter(source_in);
        if (SourceAndConverterServices.getSourceAndConverterService().getMetadata(rootSource, "SPIMDATA") == null) {
            return null;
        }
        AbstractSpimData asd = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter)rootSource, (String)"SPIMDATA")).asd;
        int viewSetupId = ((SourceAndConverterService.SpimDataInfo)SourceAndConverterServices.getSourceAndConverterService().getMetadata((SourceAndConverter)rootSource, (String)"SPIMDATA")).setupId;
        BasicViewSetup bvs = (BasicViewSetup)asd.getSequenceDescription().getViewSetups().get(viewSetupId);
        return (QuPathEntryEntity)bvs.getAttribute(QuPathEntryEntity.class);
    }

    @Deprecated
    private static File getProjectFile(QuPathEntryEntity entity) throws IllegalArgumentException {
        File quPathProject = new File(entity.getQuPathProjectionLocation());
        if (!quPathProject.exists()) {
            throw new IllegalArgumentException("QuPath project file " + quPathProject.getAbsolutePath() + " does not exist.");
        }
        return quPathProject;
    }
}

