/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.DefaultInterpolators;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.position.FunctionRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyMultiresolutionSource
implements Source<UnsignedShortType>,
Serializable {
    private static Logger logger = LoggerFactory.getLogger(EmptyMultiresolutionSource.class);
    EmptyMultiresolutionSourceParams params;
    protected final transient DefaultInterpolators<UnsignedShortType> interpolators = new DefaultInterpolators();
    final transient List<RandomAccessibleInterval> raiList;
    final transient List<AffineTransform3D> transformList;

    public EmptyMultiresolutionSource(long nx, long ny, long nz, long numberOfTimePoints, AffineTransform3D at3D, String name, int scalex, int scaley, int scalez, int numberOfResolutions) {
        this.params = new EmptyMultiresolutionSourceParams();
        this.params.nx = nx;
        this.params.ny = ny;
        this.params.nz = nz;
        this.params.numberOfTimepoints = numberOfTimePoints;
        this.params.scalex = scalex;
        this.params.scaley = scaley;
        this.params.scalez = scalez;
        BiConsumer<Localizable, UnsignedShortType> fun = (l, t) -> t.set(10);
        FunctionRandomAccessible ra = new FunctionRandomAccessible(3, fun, UnsignedShortType::new);
        if (numberOfResolutions <= 0) {
            logger.warn("Number of resolution issue, this value cannot be below 1, value (" + numberOfResolutions + ") overriden to 1");
            numberOfResolutions = 1;
        }
        this.params.numberOfResolutions = numberOfResolutions;
        this.raiList = new ArrayList<RandomAccessibleInterval>(numberOfResolutions);
        double currentNX = nx;
        double currentNY = ny;
        double currentNZ = nz;
        this.transformList = new ArrayList<AffineTransform3D>();
        for (int i = 0; i < numberOfResolutions; ++i) {
            AffineTransform3D m = new AffineTransform3D();
            m.set(at3D);
            double[] mat = m.getRowPackedCopy();
            double sX = (double)nx / (double)((long)currentNX);
            double sY = (double)ny / (double)((long)currentNY);
            double sZ = (double)nz / (double)((long)currentNZ);
            mat[0] = mat[0] * sX;
            mat[4] = mat[4] * sX;
            mat[8] = mat[8] * sX;
            mat[1] = mat[1] * sY;
            mat[5] = mat[5] * sY;
            mat[9] = mat[9] * sY;
            mat[2] = mat[2] * sZ;
            mat[6] = mat[6] * sZ;
            mat[10] = mat[10] * sZ;
            m.set(mat);
            this.transformList.add(m);
            this.raiList.add((RandomAccessibleInterval)Views.interval((RandomAccessible)ra, (Interval)new FinalInterval(new long[]{(long)currentNX, (long)currentNY, (long)currentNZ})));
            currentNX /= (double)scalex;
            currentNY /= (double)scaley;
            currentNZ /= (double)scalez;
            if (currentNX < 1.0) {
                currentNX = 1.0;
            }
            if (currentNY < 1.0) {
                currentNY = 1.0;
            }
            if (!(currentNZ < 1.0)) continue;
            currentNZ = 1.0;
        }
        this.params.at3D = at3D;
        this.params.name = name;
    }

    public boolean isPresent(int t) {
        return true;
    }

    public RandomAccessibleInterval<UnsignedShortType> getSource(int t, int level) {
        return this.raiList.get(level);
    }

    public RealRandomAccessible<UnsignedShortType> getInterpolatedSource(int t, int level, Interpolation method) {
        ExtendedRandomAccessibleInterval eView = Views.extendZero(this.getSource(t, level));
        RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)eView, (InterpolatorFactory)this.interpolators.get(method));
        return realRandomAccessible;
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.transformList.get(level));
    }

    public UnsignedShortType getType() {
        return new UnsignedShortType();
    }

    public String getName() {
        return this.params.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return new VoxelDimensions(){

            public String unit() {
                return "undefined";
            }

            public void dimensions(double[] dimensions) {
                dimensions[0] = 1.0;
                dimensions[1] = 1.0;
                dimensions[2] = 1.0;
            }

            public double dimension(int d) {
                return 1.0;
            }

            public int numDimensions() {
                return 3;
            }
        };
    }

    public int getNumMipmapLevels() {
        return this.params.numberOfResolutions;
    }

    public static class EmptyMultiresolutionSourceParams
    implements Cloneable,
    Serializable {
        public long nx;
        public long ny;
        public long nz;
        public long numberOfTimepoints;
        public AffineTransform3D at3D;
        public String name;
        public int scalex;
        public int scaley;
        public int scalez;
        public int numberOfResolutions;

        public EmptyMultiresolutionSourceParams() {
            this.nx = 1L;
            this.ny = 1L;
            this.nz = 1L;
            this.at3D = new AffineTransform3D();
            this.name = "";
            this.scalex = 1;
            this.scaley = 1;
            this.scalez = 1;
            this.numberOfResolutions = 1;
            this.numberOfTimepoints = 1L;
        }

        public EmptyMultiresolutionSourceParams(EmptyMultiresolutionSourceParams p) {
            this.nx = p.nx;
            this.ny = p.ny;
            this.nz = p.nz;
            this.at3D = new AffineTransform3D();
            this.at3D.set(p.at3D);
            this.name = p.name;
            this.scalex = p.scalex;
            this.scaley = p.scaley;
            this.scalez = p.scalez;
            this.numberOfResolutions = p.numberOfResolutions;
            this.numberOfTimepoints = p.numberOfTimepoints;
        }
    }
}

