/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.Scale3D;
import net.imglib2.realtransform.SphericalToCartesianTransform3D;
import net.imglib2.realtransform.Translation3D;
import net.imglib2.util.LinAlgHelpers;

public class Elliptical3DTransform
implements InvertibleRealTransform {
    public SphericalToCartesianTransform3D s2c = SphericalToCartesianTransform3D.getInstance();
    public Scale3D s3d = new Scale3D(1.0, 1.0, 1.0);
    public AffineTransform3D rot3D = new AffineTransform3D();
    public Translation3D tr3D = new Translation3D();
    public RealTransformSequence rts = new RealTransformSequence();
    public RealTransformSequence rtsi = new RealTransformSequence();
    public static final String RADIUS_X = "radiusX";
    public static final String RADIUS_Y = "radiusY";
    public static final String RADIUS_Z = "radiusZ";
    public static final String ROTATION_X = "rotationX";
    public static final String ROTATION_Y = "rotationY";
    public static final String ROTATION_Z = "rotationZ";
    public static final String CENTER_X = "centerX";
    public static final String CENTER_Y = "centerY";
    public static final String CENTER_Z = "centerZ";
    String name = "Elliptical3DTransform_" + this.hashCode();
    public ArrayList<Runnable> updateNotifiers;
    double r1 = 1.0;
    double r2 = 1.0;
    double r3 = 1.0;
    double rx = 0.0;
    double ry = 0.0;
    double rz = 0.0;
    double tx = 0.0;
    double ty = 0.0;
    double tz = 0.0;
    private final InverseRealTransform inverse;

    public Elliptical3DTransform() {
        this.rts.add((RealTransform)this.s2c);
        this.rts.add((RealTransform)this.s3d);
        this.rts.add((RealTransform)this.rot3D);
        this.rts.add((RealTransform)this.tr3D);
        this.rtsi.add((RealTransform)this.tr3D.inverse());
        this.rtsi.add((RealTransform)this.rot3D.inverse());
        this.rtsi.add((RealTransform)this.s3d.inverse());
        this.rtsi.add((RealTransform)this.s2c.inverse());
        this.updateNotifiers = new ArrayList();
        this.updateTransformsFromParameters();
        this.inverse = new InverseRealTransform((InvertibleRealTransform)this);
    }

    public static ArrayList<String> getParamsName() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(RADIUS_X);
        names.add(RADIUS_Y);
        names.add(RADIUS_Z);
        names.add(ROTATION_X);
        names.add(ROTATION_Y);
        names.add(ROTATION_Z);
        names.add(CENTER_X);
        names.add(CENTER_Y);
        names.add(CENTER_Y);
        return names;
    }

    public Map<String, Double> getParameters() {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        map.put(RADIUS_X, this.r1);
        map.put(RADIUS_Y, this.r2);
        map.put(RADIUS_Z, this.r3);
        map.put(ROTATION_X, this.rx);
        map.put(ROTATION_Y, this.ry);
        map.put(ROTATION_Z, this.rz);
        map.put(CENTER_X, this.tx);
        map.put(CENTER_Y, this.ty);
        map.put(CENTER_Z, this.tz);
        return map;
    }

    public void setParameters(Map<String, Double> parameters) {
        parameters.entrySet().forEach(entry -> this.setParameters(entry.getKey(), entry.getValue()));
    }

    public void setParameters(Object ... kv) {
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        for (int i = 0; i < kv.length; i += 2) {
            map.put((String)kv[i], (Double)kv[i + 1]);
        }
        map.keySet().forEach(k -> {
            switch (k) {
                case "radiusX": {
                    this.r1 = (Double)map.get(k);
                    break;
                }
                case "radiusY": {
                    this.r2 = (Double)map.get(k);
                    break;
                }
                case "radiusZ": {
                    this.r3 = (Double)map.get(k);
                    break;
                }
                case "rotationX": {
                    this.rx = (Double)map.get(k);
                    break;
                }
                case "rotationY": {
                    this.ry = (Double)map.get(k);
                    break;
                }
                case "rotationZ": {
                    this.rz = (Double)map.get(k);
                    break;
                }
                case "centerX": {
                    this.tx = (Double)map.get(k);
                    break;
                }
                case "centerY": {
                    this.ty = (Double)map.get(k);
                    break;
                }
                case "centerZ": {
                    this.tz = (Double)map.get(k);
                }
            }
        });
        this.updateTransformsFromParameters();
    }

    void updateTransformsFromParameters() {
        this.s3d.set(this.r1, this.r2, this.r3);
        this.tr3D.set(this.tx, this.ty, this.tz);
        double rxRad = this.rx;
        double ryRad = this.ry;
        double rzRad = this.rz;
        double[] qx = new double[]{Math.cos(rxRad / 2.0), Math.sin(rxRad / 2.0), 0.0, 0.0};
        double[] qy = new double[]{Math.cos(ryRad / 2.0), 0.0, Math.sin(ryRad / 2.0), 0.0};
        double[] qz = new double[]{Math.cos(rzRad / 2.0), 0.0, 0.0, Math.sin(rzRad / 2.0)};
        double[] qXY = new double[4];
        LinAlgHelpers.quaternionMultiply((double[])qy, (double[])qx, (double[])qXY);
        double[] qRes = new double[4];
        LinAlgHelpers.quaternionMultiply((double[])qz, (double[])qXY, (double[])qRes);
        double[][] m = new double[3][3];
        AffineTransform3D rotMatrix = new AffineTransform3D();
        LinAlgHelpers.quaternionToR((double[])qRes, (double[][])m);
        this.rot3D.set(m[0][0], m[0][1], m[0][2], 0.0, m[1][0], m[1][1], m[1][2], 0.0, m[2][0], m[2][1], m[2][2], 0.0);
        this.updateNotifiers.forEach(c -> c.run());
    }

    public void applyInverse(double[] source, double[] target) {
        this.rtsi.apply(source, target);
    }

    public void applyInverse(RealPositionable source, RealLocalizable target) {
        this.rtsi.apply(target, source);
    }

    public InvertibleRealTransform inverse() {
        return this.inverse;
    }

    public int numSourceDimensions() {
        return 3;
    }

    public int numTargetDimensions() {
        return 3;
    }

    public void apply(double[] source, double[] target) {
        this.rts.apply(source, target);
    }

    public void apply(RealLocalizable source, RealPositionable target) {
        this.rts.apply(source, target);
    }

    public Elliptical3DTransform copy() {
        Elliptical3DTransform copy = new Elliptical3DTransform();
        copy.rts = this.rts.copy();
        copy.rtsi = this.rtsi.copy();
        copy.setName(this.getName());
        return copy;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

