/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.BoundedRealTransform;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.persist.IClassRuntimeAdapter;

@Plugin(type=IClassRuntimeAdapter.class)
public class BoundedRealTransformAdapter
implements IClassRuntimeAdapter<RealTransform, BoundedRealTransform> {
    private static Logger logger = LoggerFactory.getLogger(BoundedRealTransformAdapter.class);

    public Class<? extends RealTransform> getBaseClass() {
        return RealTransform.class;
    }

    public Class<? extends BoundedRealTransform> getRunTimeClass() {
        return BoundedRealTransform.class;
    }

    public boolean useCustomAdapter() {
        return true;
    }

    public BoundedRealTransform deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject obj = jsonElement.getAsJsonObject();
        RealTransform rt = (RealTransform)jsonDeserializationContext.deserialize(obj.get("realTransform"), RealTransform.class);
        if (!(rt instanceof InvertibleRealTransform)) {
            logger.error("Error during deserialization of BoundedRealTransform : The serialized transform is not invertible");
            return null;
        }
        double[] min = (double[])jsonDeserializationContext.deserialize(obj.get("interval_min"), double[].class);
        double[] max = (double[])jsonDeserializationContext.deserialize(obj.get("interval_max"), double[].class);
        FinalRealInterval fri = new FinalRealInterval(min, max);
        return new BoundedRealTransform((InvertibleRealTransform)rt, (RealInterval)fri);
    }

    public JsonElement serialize(BoundedRealTransform brt, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject obj = new JsonObject();
        FinalRealInterval fri = new FinalRealInterval(brt.getInterval());
        obj.add("realTransform", jsonSerializationContext.serialize((Object)brt.getTransform(), RealTransform.class));
        obj.add("interval_min", jsonSerializationContext.serialize((Object)fri.minAsDoubleArray()));
        obj.add("interval_max", jsonSerializationContext.serialize((Object)fri.maxAsDoubleArray()));
        return obj;
    }
}

