/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;

public class BoundedRealTransform
implements InvertibleRealTransform {
    final InvertibleRealTransform origin;
    final RealInterval interval;
    final int nDimSource;
    final int nDimTarget;

    public BoundedRealTransform(InvertibleRealTransform origin, RealInterval interval) {
        this.origin = origin;
        this.interval = interval;
        this.nDimSource = origin.numSourceDimensions();
        this.nDimTarget = origin.numTargetDimensions();
    }

    public int numSourceDimensions() {
        return this.nDimSource;
    }

    public int numTargetDimensions() {
        return this.nDimTarget;
    }

    public void apply(double[] source, double[] target) {
        int d;
        boolean inBounds = true;
        for (d = 0; d < this.nDimSource; ++d) {
            if (source[d] < this.interval.realMin(d)) {
                inBounds = false;
                break;
            }
            if (!(source[d] > this.interval.realMax(d))) continue;
            inBounds = false;
            break;
        }
        if (inBounds) {
            this.origin.apply(source, target);
        } else {
            for (d = 0; d < this.nDimSource; ++d) {
                target[d] = source[d];
            }
        }
    }

    public void apply(RealLocalizable realLocalizable, RealPositionable realPositionable) {
        boolean inBounds = true;
        for (int d = 0; d < this.nDimSource; ++d) {
            if ((double)realLocalizable.getFloatPosition(d) < this.interval.realMin(d)) {
                inBounds = false;
                break;
            }
            if (!((double)realLocalizable.getFloatPosition(d) > this.interval.realMax(d))) continue;
            inBounds = false;
            break;
        }
        if (inBounds) {
            this.origin.apply(realLocalizable, realPositionable);
        } else {
            realPositionable.setPosition(realLocalizable);
        }
    }

    public void applyInverse(double[] source, double[] target) {
        this.origin.applyInverse(source, target);
    }

    public void applyInverse(RealPositionable realPositionable, RealLocalizable realLocalizable) {
        this.origin.applyInverse(realPositionable, realLocalizable);
    }

    public InvertibleRealTransform inverse() {
        return this.origin.inverse();
    }

    public InvertibleRealTransform copy() {
        return new BoundedRealTransform(this.origin.copy(), this.interval);
    }

    public RealInterval getInterval() {
        return this.interval;
    }

    public RealTransform getTransform() {
        return this.origin;
    }
}

