/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.RoiEnlarger;
import ij.process.ImageStatistics;
import java.util.ArrayList;

public class QualityFilter {
    public static ArrayList<Roi> run(Roi[] rois, ImagePlus imp, double threshold, double pixels) {
        ArrayList<Roi> filtered = new ArrayList<Roi>(rois.length);
        double[] ratios = new double[rois.length];
        int i = 0;
        while (i < rois.length) {
            imp.setRoi(rois[i]);
            ImageStatistics stats_in = imp.getStatistics();
            Roi large_roi = RoiEnlarger.enlarge((Roi)rois[i], (double)pixels);
            imp.setRoi(large_roi);
            ImageStatistics stats_out = imp.getStatistics();
            double denom = (stats_out.area * stats_out.mean - stats_in.area * stats_in.mean) / (stats_out.area - stats_in.area);
            ratios[i] = Math.abs(stats_in.mean / denom);
            if (ratios[i] > threshold) {
                filtered.add(rois[i]);
            }
            ++i;
        }
        imp.deleteRoi();
        return filtered;
    }
}

