/*
 * Decompiled with CFR 0.152.
 */
import ch.epfl.biop.QualityFilter;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;
import java.awt.AWTEvent;
import java.awt.Color;
import java.util.ArrayList;

public class Quality_Filter
implements PlugIn {
    private RoiManager rm;
    double threshold;
    double enlarge_by;
    Roi[] rois;
    ImagePlus imp;

    public void run(String arg) {
        this.imp = IJ.getImage();
        this.rm = RoiManager.getInstance();
        if (this.rm == null || this.rm.getCount() == 0) {
            IJ.showMessage((String)"Need ROIs in RoiManager...");
            return;
        }
        this.threshold = Prefs.get((String)"quality.filter.thr", (double)4.0);
        this.enlarge_by = Prefs.get((String)"quality.filter.pix", (double)10.0);
        this.rois = this.rm.getRoisAsArray();
        GenericDialog gd = arg.matches(".*interactive.*") ? this.showInteractiveDialog() : this.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        ArrayList<Roi> filtered = QualityFilter.run(this.rois, this.imp, this.threshold, this.enlarge_by);
        if (this.imp.getOverlay() != null) {
            this.imp.getOverlay().clear();
        }
        for (Roi r : filtered) {
            r.setName("ROI " + r.getName() + " Filtered");
            this.rm.addRoi(r);
        }
    }

    private GenericDialog showDialog() {
        GenericDialog gd = new GenericDialog("Quality Filtering");
        gd.addNumericField("Threshold", this.threshold, 3);
        gd.addNumericField("Area Around", this.enlarge_by, 3);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return gd;
        }
        this.threshold = gd.getNextNumber();
        this.enlarge_by = gd.getNextNumber();
        Prefs.set((String)"quality.filter.thr", (double)this.threshold);
        Prefs.set((String)"quality.filter.pix", (double)this.enlarge_by);
        return gd;
    }

    private GenericDialog showInteractiveDialog() {
        GenericDialog gd = new GenericDialog("Quality Filtering");
        gd.addNumericField("Threshold", this.threshold, 3);
        gd.addNumericField("Area Around", this.enlarge_by, 3);
        gd.addDialogListener(new DialogListener(){

            public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
                if (gd.wasOKed() || gd.wasCanceled()) {
                    return true;
                }
                double thr = gd.getNextNumber();
                double px = gd.getNextNumber();
                Overlay ov = Quality_Filter.this.imp.getOverlay();
                if (ov == null) {
                    ov = new Overlay();
                } else {
                    ov.clear();
                }
                ArrayList<Roi> filtered = QualityFilter.run(Quality_Filter.this.rois, Quality_Filter.this.imp, thr, px);
                for (Roi r : filtered) {
                    r.setFillColor(new Color(255, 0, 255, 128));
                    ov.addElement(r);
                }
                Quality_Filter.this.imp.setOverlay(ov);
                return true;
            }
        });
        gd.showDialog();
        if (gd.wasCanceled()) {
            return gd;
        }
        this.threshold = gd.getNextNumber();
        this.enlarge_by = gd.getNextNumber();
        Prefs.set((String)"quality.filter.thr", (double)this.threshold);
        Prefs.set((String)"quality.filter.pix", (double)this.enlarge_by);
        return gd;
    }

    public static void main(String[] args) {
        Class<Quality_Filter> clazz = Quality_Filter.class;
        String url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString();
        String pluginsDir = url.substring(5, url.length() - clazz.getName().length() - 6);
        System.setProperty("plugins.dir", pluginsDir);
        new ImageJ();
        ImagePlus imp = IJ.openImage((String)"E:\\AuPbSn40.tif");
        IJ.setAutoThreshold((ImagePlus)imp, (String)"Otsu");
        IJ.run((ImagePlus)imp, (String)"Analyze Particles...", (String)"display exclude clear add");
        imp.show();
        IJ.resetThreshold((ImagePlus)imp);
        IJ.run((String)"Quality Filter");
    }
}

