/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.select;

import bdv.tools.boundingbox.RenderBoxHelper;
import bdv.tools.boundingbox.TransformedBox;
import bdv.util.BdvOverlay;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import ch.epfl.biop.bdv.select.SourceSelectorBehaviour;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.util.Behaviours;

public class SourceSelectorOverlay
extends BdvOverlay {
    final ViewerPanel viewer;
    boolean isCurrentlySelecting = false;
    int xCurrentSelectStart;
    int yCurrentSelectStart;
    int xCurrentSelectEnd;
    int yCurrentSelectEnd;
    private int canvasWidth;
    private int canvasHeight;
    private final Object lockSourceBoxOverlay = new Object();
    private List<SourceBoxOverlay> sourcesBoxOverlay = new ArrayList<SourceBoxOverlay>();
    final Map<String, OverlayStyle> styles = new HashMap<String, OverlayStyle>();
    final SourceSelectorBehaviour ssb;
    boolean displaySourcesNames = true;

    public void showSourcesNames() {
        this.displaySourcesNames = true;
    }

    public void hideSourcesNames() {
        this.displaySourcesNames = false;
    }

    public SourceSelectorOverlay(ViewerPanel viewer, SourceSelectorBehaviour ssb) {
        this.ssb = ssb;
        this.viewer = viewer;
        this.updateBoxes();
        this.styles.put("DEFAULT", new DefaultOverlayStyle());
        this.styles.put("SELECTED", new SelectedOverlayStyle());
    }

    protected void addSelectionBehaviours(Behaviours behaviours) {
        behaviours.behaviour(new RectangleSelectSourcesBehaviour("SET"), "select-set-sources", "button1");
        behaviours.behaviour(new RectangleSelectSourcesBehaviour("ADD"), "select-add-sources", "shift button1");
        behaviours.behaviour(new RectangleSelectSourcesBehaviour("REMOVE"), "select-remove-sources", "ctrl button1");
        behaviours.behaviour((x, y) -> this.ssb.selectedSourceAdd(this.viewer.state().getVisibleSources()), "select-all-visible-sources", "ctrl A");
    }

    public Map<String, OverlayStyle> getStyles() {
        return this.styles;
    }

    synchronized void startCurrentSelection(int x, int y) {
        this.xCurrentSelectStart = x;
        this.yCurrentSelectStart = y;
    }

    synchronized void updateCurrentSelection(int xCurrent, int yCurrent) {
        this.xCurrentSelectEnd = xCurrent;
        this.yCurrentSelectEnd = yCurrent;
        this.isCurrentlySelecting = true;
    }

    synchronized void endCurrentSelection(int x, int y, String mode) {
        this.xCurrentSelectEnd = x;
        this.yCurrentSelectEnd = y;
        this.isCurrentlySelecting = false;
        this.getLastSelectedSources();
        this.ssb.processSelectionModificationEvent(this.getLastSelectedSources(), mode, "SelectorOverlay");
    }

    Rectangle getCurrentSelectionRectangle() {
        int h;
        int y0;
        int w;
        int x0;
        if (this.xCurrentSelectStart > this.xCurrentSelectEnd) {
            x0 = this.xCurrentSelectEnd;
            w = this.xCurrentSelectStart - this.xCurrentSelectEnd;
        } else {
            x0 = this.xCurrentSelectStart;
            w = this.xCurrentSelectEnd - this.xCurrentSelectStart;
        }
        if (this.yCurrentSelectStart > this.yCurrentSelectEnd) {
            y0 = this.yCurrentSelectEnd;
            h = this.yCurrentSelectStart - this.yCurrentSelectEnd;
        } else {
            y0 = this.yCurrentSelectStart;
            h = this.yCurrentSelectEnd - this.yCurrentSelectStart;
        }
        if (w == 0) {
            w = 1;
        }
        if (h == 0) {
            h = 1;
        }
        return new Rectangle(x0, y0, w, h);
    }

    synchronized Set<SourceAndConverter<?>> getLastSelectedSources() {
        HashSet lastSelected = new HashSet();
        RenderBoxHelper rbh = new RenderBoxHelper();
        for (SourceBoxOverlay sbo : this.sourcesBoxOverlay) {
            AffineTransform3D viewerTransform = new AffineTransform3D();
            this.viewer.state().getViewerTransform(viewerTransform);
            AffineTransform3D transform = new AffineTransform3D();
            sbo.getTransform(transform);
            transform.preConcatenate(viewerTransform);
            double ox = (double)this.canvasWidth / 2.0;
            double oy = (double)this.canvasHeight / 2.0;
            rbh.setOrigin(ox, oy);
            rbh.setScale(1.0);
            GeneralPath front = new GeneralPath();
            GeneralPath back = new GeneralPath();
            GeneralPath intersection = new GeneralPath();
            if (sbo.getInterval() == null) continue;
            rbh.renderBox(sbo.getInterval(), transform, front, back, intersection);
            Rectangle r = this.getCurrentSelectionRectangle();
            if (!intersection.intersects(r) && !intersection.contains(r)) continue;
            lastSelected.add(sbo.sac);
        }
        return lastSelected;
    }

    public synchronized void draw(Graphics2D g) {
        HashMap occupied = new HashMap();
        for (SourceBoxOverlay source : this.sourcesBoxOverlay) {
            source.drawBoxOverlay(g, this.displaySourcesNames, occupied);
        }
        if (this.isCurrentlySelecting) {
            g.setStroke(this.styles.get("SELECTED").getNormalStroke());
            g.setPaint(this.styles.get("SELECTED").getBackColor());
            g.draw(this.getCurrentSelectionRectangle());
        }
    }

    public void setCanvasSize(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoxes() {
        ArrayList<SourceBoxOverlay> newSourcesBoxOverlay = new ArrayList<SourceBoxOverlay>();
        for (SourceAndConverter sac : this.viewer.state().getVisibleSources()) {
            if (sac.getSpimSource().getSource(this.viewer.state().getCurrentTimepoint(), 0) == null) continue;
            newSourcesBoxOverlay.add(new SourceBoxOverlay(sac));
        }
        Object object = this.lockSourceBoxOverlay;
        synchronized (object) {
            this.sourcesBoxOverlay = newSourcesBoxOverlay;
        }
    }

    class RectangleSelectSourcesBehaviour
    implements DragBehaviour {
        final String mode;

        public RectangleSelectSourcesBehaviour(String mode) {
            this.mode = mode;
        }

        @Override
        public void init(int x, int y) {
            SourceSelectorOverlay.this.startCurrentSelection(x, y);
            SourceSelectorOverlay.this.viewer.setCursor(new Cursor(1));
            switch (this.mode) {
                case "SET": {
                    SourceSelectorOverlay.this.viewer.showMessage("Set Selection");
                    break;
                }
                case "ADD": {
                    SourceSelectorOverlay.this.viewer.showMessage("Add Selection");
                    break;
                }
                case "REMOVE": {
                    SourceSelectorOverlay.this.viewer.showMessage("Remove Selection");
                }
            }
        }

        @Override
        public void drag(int x, int y) {
            SourceSelectorOverlay.this.updateCurrentSelection(x, y);
            SourceSelectorOverlay.this.viewer.getDisplay().repaint();
        }

        @Override
        public void end(int x, int y) {
            SourceSelectorOverlay.this.endCurrentSelection(x, y, this.mode);
            SourceSelectorOverlay.this.viewer.setCursor(new Cursor(0));
        }
    }

    public static class SelectedOverlayStyle
    implements OverlayStyle {
        final Color backColor = new Color(16236312);
        final Color frontColor = new Color(13104920);
        final Color intersectionFillColor = new Color(817261056, true);
        final Stroke normalStroke = new BasicStroke();
        final Stroke intersectionStroke = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
        final Color intersectionColor = Color.WHITE.darker();

        @Override
        public Color getBackColor() {
            return this.backColor;
        }

        @Override
        public Color getFrontColor() {
            return this.frontColor;
        }

        @Override
        public Color getIntersectionColor() {
            return this.intersectionColor;
        }

        @Override
        public Color getIntersectionFillColor() {
            return this.intersectionFillColor;
        }

        @Override
        public Stroke getNormalStroke() {
            return this.normalStroke;
        }

        @Override
        public Stroke getIntersectionStroke() {
            return this.intersectionStroke;
        }
    }

    public static class DefaultOverlayStyle
    implements OverlayStyle {
        final Color backColor = new Color(0x994499);
        final Color frontColor = new Color(6112950);
        final Color intersectionFillColor = new Color(848905369, true);
        final Stroke normalStroke = new BasicStroke();
        final Stroke intersectionStroke = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
        final Color intersectionColor = Color.WHITE.darker();

        @Override
        public Color getBackColor() {
            return this.backColor;
        }

        @Override
        public Color getFrontColor() {
            return this.frontColor;
        }

        @Override
        public Color getIntersectionColor() {
            return this.intersectionColor;
        }

        @Override
        public Color getIntersectionFillColor() {
            return this.intersectionFillColor;
        }

        @Override
        public Stroke getNormalStroke() {
            return this.normalStroke;
        }

        @Override
        public Stroke getIntersectionStroke() {
            return this.intersectionStroke;
        }
    }

    public static interface OverlayStyle {
        public Color getBackColor();

        public Color getFrontColor();

        public Color getIntersectionColor();

        public Color getIntersectionFillColor();

        public Stroke getNormalStroke();

        public Stroke getIntersectionStroke();
    }

    class SourceBoxOverlay
    implements TransformedBox {
        final SourceAndConverter<?> sac;
        final RenderBoxHelper rbh;

        public SourceBoxOverlay(SourceAndConverter<?> sac) {
            this.sac = sac;
            this.rbh = new RenderBoxHelper();
        }

        private Map<Integer, Set<Integer>> displayAt(Graphics2D graphics, double xp, double yp, String name, Map<Integer, Set<Integer>> occupied) {
            double binSizeX = 100.0;
            double binSizeY = 20.0;
            int binX = (int)(xp / binSizeX);
            int binY = (int)(yp / binSizeY);
            boolean shiftX = false;
            int shiftY = 0;
            if (!occupied.containsKey(binX)) {
                occupied.put(binX, new HashSet());
            }
            Set<Integer> occupiedY = occupied.get(binX);
            while (occupiedY.contains(binY)) {
                ++binY;
                shiftY += (int)binSizeY;
            }
            occupiedY.add(binY);
            graphics.drawString(this.sac.getSpimSource().getName(), (int)(xp + (double)shiftX), (int)(yp + (double)shiftY));
            return occupied;
        }

        private Map<Integer, Set<Integer>> drawBoxOverlay(Graphics2D graphics, boolean displaySourcesNames, Map<Integer, Set<Integer>> occupied) {
            OverlayStyle os = SourceSelectorOverlay.this.ssb.selectedSources.contains(this.sac) ? SourceSelectorOverlay.this.styles.get("SELECTED") : SourceSelectorOverlay.this.styles.get("DEFAULT");
            GeneralPath front = new GeneralPath();
            GeneralPath back = new GeneralPath();
            GeneralPath intersection = new GeneralPath();
            RealInterval interval = this.getInterval();
            if (interval != null) {
                double ox = (double)SourceSelectorOverlay.this.canvasWidth / 2.0;
                double oy = (double)SourceSelectorOverlay.this.canvasHeight / 2.0;
                AffineTransform3D viewerTransform = new AffineTransform3D();
                SourceSelectorOverlay.this.viewer.state().getViewerTransform(viewerTransform);
                AffineTransform3D transform = new AffineTransform3D();
                this.getTransform(transform);
                transform.preConcatenate(viewerTransform);
                this.rbh.setOrigin(ox, oy);
                this.rbh.setScale(1.0);
                this.rbh.renderBox(interval, transform, front, back, intersection);
                Rectangle screen = new Rectangle(0, 0, SourceSelectorOverlay.this.canvasWidth, SourceSelectorOverlay.this.canvasHeight);
                Rectangle rectBounds = intersection.getBounds();
                if (rectBounds.x + rectBounds.width > 0 && rectBounds.x < SourceSelectorOverlay.this.canvasWidth && rectBounds.y + rectBounds.height > 0 && rectBounds.y < SourceSelectorOverlay.this.canvasHeight) {
                    graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics.setPaint(os.getIntersectionFillColor());
                    graphics.fill(intersection);
                    graphics.setPaint(os.getIntersectionColor());
                    graphics.setStroke(os.getIntersectionStroke());
                    graphics.draw(intersection);
                    if (displaySourcesNames) {
                        Area a = new Area(intersection);
                        a.intersect(new Area(screen));
                        double cx = a.getBounds2D().getCenterX();
                        double cy = a.getBounds2D().getCenterY();
                        graphics.setColor(os.getFrontColor());
                        occupied = this.displayAt(graphics, cx, cy, this.sac.getSpimSource().getName(), occupied);
                    }
                }
            }
            return occupied;
        }

        public RealInterval getInterval() {
            long[] dims = new long[3];
            int currentTimePoint = SourceSelectorOverlay.this.viewer.state().getCurrentTimepoint();
            if (this.sac.getSpimSource().isPresent(currentTimePoint)) {
                this.sac.getSpimSource().getSource(currentTimePoint, 0).dimensions(dims);
                return new FinalRealInterval(new double[]{-0.5, -0.5, -0.5}, new double[]{(double)dims[0] - 0.5, (double)dims[1] - 0.5, (double)dims[2] - 0.5});
            }
            return null;
        }

        public void getTransform(AffineTransform3D transform) {
            this.sac.getSpimSource().getSourceTransform(SourceSelectorOverlay.this.viewer.state().getCurrentTimepoint(), 0, transform);
        }
    }
}

