/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.select;

import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvOverlay;
import bdv.util.BdvOverlaySource;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import ch.epfl.biop.bdv.select.SelectedSourcesListener;
import ch.epfl.biop.bdv.select.SourceSelectorOverlay;
import ch.epfl.biop.bdv.select.ToggleListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.swing.InputMap;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class SourceSelectorBehaviour
implements ViewerStateChangeListener {
    public static final String SOURCES_SELECTOR_MAP = "sources-selector";
    public static final String SOURCES_SELECTOR_TOGGLE_MAP = "source-selector-toggle";
    public static final String SET = "SET";
    public static final String ADD = "ADD";
    public static final String REMOVE = "REMOVE";
    final SourceSelectorOverlay selectorOverlay;
    BdvOverlaySource<?> bos;
    final BdvHandle bdvh;
    final TriggerBehaviourBindings triggerbindings;
    final ViewerPanel viewer;
    final Behaviours behaviours;
    boolean isInstalled;
    final List<ToggleListener> toggleListeners = new ArrayList<ToggleListener>();
    final List<SelectedSourcesListener> selectedSourceListeners = new ArrayList<SelectedSourcesListener>();
    protected final Set<SourceAndConverter<?>> selectedSources = ConcurrentHashMap.newKeySet();
    final Set<SourceGroup> sourceGroups = new HashSet<SourceGroup>();

    public SourceSelectorBehaviour(BdvHandle bdvh, String triggerToggleSelector) {
        this.bdvh = bdvh;
        this.triggerbindings = bdvh.getTriggerbindings();
        this.viewer = bdvh.getViewerPanel();
        this.selectorOverlay = new SourceSelectorOverlay(this.viewer, this);
        ClickBehaviour toggleSelector = (x, y) -> {
            if (this.isInstalled) {
                this.uninstall();
            } else {
                this.install();
            }
        };
        Behaviours behavioursToggle = new Behaviours(new InputTriggerConfig(), "bdv");
        behavioursToggle.behaviour(toggleSelector, SOURCES_SELECTOR_TOGGLE_MAP, triggerToggleSelector);
        behavioursToggle.install(bdvh.getTriggerbindings(), SOURCES_SELECTOR_TOGGLE_MAP);
        this.behaviours = new Behaviours(new InputTriggerConfig(), "bdv");
        this.viewer.state().changeListeners().add(this);
    }

    public SourceSelectorOverlay getSourceSelectorOverlay() {
        return this.selectorOverlay;
    }

    public BdvHandle getBdvHandle() {
        return this.bdvh;
    }

    public synchronized void enable() {
        if (!this.isInstalled) {
            this.install();
        }
    }

    public synchronized void disable() {
        if (this.isInstalled) {
            this.uninstall();
        }
    }

    public synchronized boolean isEnabled() {
        return this.isInstalled;
    }

    public void remove() {
        this.disable();
        this.triggerbindings.removeInputTriggerMap(SOURCES_SELECTOR_TOGGLE_MAP);
        this.triggerbindings.removeBehaviourMap(SOURCES_SELECTOR_TOGGLE_MAP);
    }

    synchronized void install() {
        this.isInstalled = true;
        this.selectorOverlay.addSelectionBehaviours(this.behaviours);
        this.triggerbindings.addBehaviourMap(SOURCES_SELECTOR_MAP, this.behaviours.getBehaviourMap());
        this.triggerbindings.addInputTriggerMap(SOURCES_SELECTOR_MAP, this.behaviours.getInputTriggerMap(), "transform", "bdv");
        int nTimePoints = this.bdvh.getViewerPanel().state().getNumTimepoints();
        int currentTimePoint = this.bdvh.getViewerPanel().state().getCurrentTimepoint();
        this.bos = BdvFunctions.showOverlay((BdvOverlay)this.selectorOverlay, (String)"Selector_Overlay", (BdvOptions)BdvOptions.options().addTo((Bdv)this.bdvh));
        this.bdvh.getViewerPanel().state().getGroups().forEach(group -> {
            this.bdvh.getViewerPanel().state().addSourcesToGroup(Collections.singleton(SourceSelectorBehaviour.getSourceAndConverterFrom(this.bos)), group);
            this.sourceGroups.add((SourceGroup)group);
        });
        this.bdvh.getViewerPanel().state().setNumTimepoints(nTimePoints);
        this.bdvh.getViewerPanel().state().setCurrentTimepoint(currentTimePoint);
        this.bdvh.getKeybindings().addInputMap("blocking-source-selector", new InputMap(), "bdv", "navigation");
        this.toggleListeners.forEach(ToggleListener::isEnabled);
    }

    static SourceAndConverter<Void> getSourceAndConverterFrom(BdvOverlaySource<?> overlay) {
        try {
            Field sourceField = BdvOverlaySource.class.getDeclaredField("source");
            sourceField.setAccessible(true);
            return (SourceAndConverter)sourceField.get(overlay);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addBehaviour(Behaviour behaviour, String behaviourName, String[] triggers) {
        this.behaviours.behaviour(behaviour, behaviourName, triggers);
    }

    synchronized void uninstall() {
        this.isInstalled = false;
        this.sourceGroups.forEach(group -> this.bdvh.getViewerPanel().state().removeSourceFromGroup(SourceSelectorBehaviour.getSourceAndConverterFrom(this.bos), group));
        this.sourceGroups.clear();
        SynchronizedViewerState state = this.bdvh.getViewerPanel().state();
        ViewerState snap = state.snapshot();
        this.bos.removeFromBdv();
        state.setNumTimepoints(snap.getNumTimepoints());
        state.setCurrentTimepoint(snap.getCurrentTimepoint());
        for (SourceGroup group2 : state.getGroups()) {
            state.addSourcesToGroup((Collection)snap.getSourcesInGroup(group2), group2);
            state.setGroupActive(group2, snap.isGroupActive(group2));
        }
        state.setCurrentGroup(snap.getCurrentGroup());
        this.triggerbindings.removeBehaviourMap(SOURCES_SELECTOR_MAP);
        this.triggerbindings.removeInputTriggerMap(SOURCES_SELECTOR_MAP);
        this.bdvh.getKeybindings().removeInputMap("blocking-source-selector");
        this.toggleListeners.forEach(ToggleListener::isDisabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SourceAndConverter<?>> getSelectedSources() {
        Set<SourceAndConverter<?>> set = this.selectedSources;
        synchronized (set) {
            return new HashSet(this.selectedSources);
        }
    }

    private Set<SourceAndConverter<?>> removeOverlaySources(Set<SourceAndConverter<?>> in) {
        return in.stream().filter(sac -> sac.getSpimSource().getSource(this.viewer.state().getCurrentTimepoint(), 0) != null).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSelectionModificationEvent(Set<SourceAndConverter<?>> currentSources, String mode, String eventSource) {
        Set<SourceAndConverter<?>> set = this.selectedSources;
        synchronized (set) {
            int initialSize = this.selectedSources.size();
            switch (mode) {
                case "SET": {
                    if (currentSources.stream().anyMatch(sac -> !this.viewer.state().isSourceVisible(sac))) {
                        System.err.println("Error : attempt to select a source which is not visible - selection ignored");
                        return;
                    }
                    this.selectedSources.clear();
                    this.selectedSources.addAll(this.removeOverlaySources(currentSources));
                    break;
                }
                case "ADD": {
                    if (currentSources.stream().anyMatch(sac -> !this.viewer.state().isSourceVisible(sac))) {
                        System.err.println("Error : attempt to select a source which is not visible - selection ignored");
                        return;
                    }
                    this.selectedSources.addAll(this.removeOverlaySources(currentSources));
                    break;
                }
                case "REMOVE": {
                    this.selectedSources.removeAll(currentSources);
                    break;
                }
                default: {
                    System.err.println("Unhandled " + mode + " selected source modification event");
                }
            }
            if (!currentSources.isEmpty()) {
                this.selectedSourceListeners.forEach(listener -> {
                    listener.selectedSourcesUpdated(this.getSelectedSources(), eventSource);
                    listener.lastSelectionEvent(this.removeOverlaySources(currentSources), mode, eventSource);
                });
            }
            if (currentSources.isEmpty() && initialSize != 0 && mode.equals(SET)) {
                this.selectedSourceListeners.forEach(listener -> {
                    listener.selectedSourcesUpdated(this.getSelectedSources(), eventSource);
                    listener.lastSelectionEvent(currentSources, mode, eventSource);
                });
            }
            this.viewer.requestRepaint();
        }
    }

    public void selectedSourcesClear(String eventSource) {
        this.processSelectionModificationEvent(new HashSet(), SET, eventSource);
    }

    public void selectedSourceAdd(Collection<SourceAndConverter<?>> sources, String eventSource) {
        HashSet sourcesSet = new HashSet(sources);
        this.processSelectionModificationEvent(sourcesSet, ADD, eventSource);
    }

    public void selectedSourceRemove(Collection<SourceAndConverter<?>> sources, String eventSource) {
        HashSet sourcesSet = new HashSet(sources);
        this.processSelectionModificationEvent(sourcesSet, REMOVE, eventSource);
    }

    public void selectedSourcesClear() {
        this.selectedSourcesClear("API");
    }

    public void selectedSourceRemove(Collection<SourceAndConverter<?>> sources) {
        this.selectedSourceRemove(sources, "API");
    }

    public void selectedSourceAdd(Collection<SourceAndConverter<?>> sources) {
        this.selectedSourceAdd(sources, "API");
    }

    public void selectedSourceRemove(SourceAndConverter<?> source) {
        HashSet sourcesSet = new HashSet();
        sourcesSet.add(source);
        this.selectedSourceRemove(sourcesSet, "API");
    }

    public void selectedSourceAdd(SourceAndConverter<?> source) {
        HashSet sourcesSet = new HashSet();
        sourcesSet.add(source);
        this.selectedSourceAdd(sourcesSet, "API");
    }

    public void viewerStateChanged(ViewerStateChange change) {
        if (change.equals((Object)ViewerStateChange.NUM_SOURCES_CHANGED) || change.equals((Object)ViewerStateChange.VISIBILITY_CHANGED)) {
            this.selectorOverlay.updateBoxes();
            HashSet leftOvers = new HashSet(this.selectedSources);
            leftOvers.removeAll(this.viewer.state().getVisibleSources());
            if (!leftOvers.isEmpty()) {
                this.processSelectionModificationEvent(leftOvers, REMOVE, change.toString());
            }
        }
        if (change.equals((Object)ViewerStateChange.CURRENT_TIMEPOINT_CHANGED)) {
            this.selectorOverlay.updateBoxes();
        }
    }

    public void addToggleListener(ToggleListener toggleListener) {
        this.toggleListeners.add(toggleListener);
    }

    public void removeToggleListener(ToggleListener toggleListener) {
        this.toggleListeners.remove(toggleListener);
    }

    public void addSelectedSourcesListener(SelectedSourcesListener selectedSourcesListener) {
        this.selectedSourceListeners.add(selectedSourcesListener);
    }

    public void removeSelectedSourcesListener(SelectedSourcesListener selectedSourcesListener) {
        this.selectedSourceListeners.remove(selectedSourcesListener);
    }
}

