/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.select;

import bdv.tools.boundingbox.RenderBoxHelper;
import bdv.tools.boundingbox.TransformedBox;
import bdv.util.BdvOverlay;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;

public class SourceNameOverlay
extends BdvOverlay {
    final ViewerPanel viewer;
    private int canvasWidth;
    private int canvasHeight;
    private List<SourceBoxOverlay> sourcesBoxOverlay = new ArrayList<SourceBoxOverlay>();
    final Map<String, OverlayStyle> styles = new HashMap<String, OverlayStyle>();
    boolean displaySourcesNames = true;

    public SourceNameOverlay(ViewerPanel viewer) {
        this.viewer = viewer;
        this.updateBoxes();
        this.styles.put("DEFAULT", new DefaultOverlayStyle());
    }

    public Map<String, OverlayStyle> getStyles() {
        return this.styles;
    }

    public synchronized void draw(Graphics2D g) {
        HashMap occupied = new HashMap();
        for (SourceBoxOverlay source : this.sourcesBoxOverlay) {
            source.drawSourceNameOverlay(g, occupied);
        }
    }

    public void setCanvasSize(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBoxes() {
        ArrayList<SourceBoxOverlay> newSourcesBoxOverlay = new ArrayList<SourceBoxOverlay>();
        for (SourceAndConverter sac : this.viewer.state().getVisibleSources()) {
            if (sac.getSpimSource().getSource(this.viewer.state().getCurrentTimepoint(), 0) == null) continue;
            newSourcesBoxOverlay.add(new SourceBoxOverlay(sac));
        }
        List<SourceBoxOverlay> list = this.sourcesBoxOverlay;
        synchronized (list) {
            this.sourcesBoxOverlay = newSourcesBoxOverlay;
        }
    }

    private static Map<Integer, Set<Integer>> displayNameAt(SourceAndConverter<?> sac, Graphics2D graphics, double xp, double yp, String name, Map<Integer, Set<Integer>> occupied) {
        double binSizeX = 100.0;
        double binSizeY = 20.0;
        int binX = (int)(xp / binSizeX);
        int binY = (int)(yp / binSizeY);
        boolean shiftX = false;
        int shiftY = 0;
        if (!occupied.containsKey(binX)) {
            occupied.put(binX, new HashSet());
        }
        Set<Integer> occupiedY = occupied.get(binX);
        while (occupiedY.contains(binY)) {
            ++binY;
            shiftY += (int)binSizeY;
        }
        occupiedY.add(binY);
        graphics.drawString(sac.getSpimSource().getName(), (int)(xp + (double)shiftX), (int)(yp + (double)shiftY));
        return occupied;
    }

    public static class DefaultOverlayStyle
    implements OverlayStyle {
        final Color backColor = new Color(0x994499);
        final Color frontColor = new Color(6112950);
        final Color intersectionFillColor = new Color(848905369, true);
        final Stroke normalStroke = new BasicStroke();
        final Stroke intersectionStroke = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
        final Color intersectionColor = Color.WHITE.darker();

        @Override
        public Color getBackColor() {
            return this.backColor;
        }

        @Override
        public Color getFrontColor() {
            return this.frontColor;
        }

        @Override
        public Color getIntersectionColor() {
            return this.intersectionColor;
        }

        @Override
        public Color getIntersectionFillColor() {
            return this.intersectionFillColor;
        }

        @Override
        public Stroke getNormalStroke() {
            return this.normalStroke;
        }

        @Override
        public Stroke getIntersectionStroke() {
            return this.intersectionStroke;
        }
    }

    public static interface OverlayStyle {
        public Color getBackColor();

        public Color getFrontColor();

        public Color getIntersectionColor();

        public Color getIntersectionFillColor();

        public Stroke getNormalStroke();

        public Stroke getIntersectionStroke();
    }

    class SourceBoxOverlay
    implements TransformedBox {
        final SourceAndConverter<?> sac;
        final RenderBoxHelper rbh;

        public SourceBoxOverlay(SourceAndConverter<?> sac) {
            this.sac = sac;
            this.rbh = new RenderBoxHelper();
        }

        private Map<Integer, Set<Integer>> drawSourceNameOverlay(Graphics2D graphics, Map<Integer, Set<Integer>> occupied) {
            OverlayStyle os = SourceNameOverlay.this.styles.get("DEFAULT");
            GeneralPath front = new GeneralPath();
            GeneralPath back = new GeneralPath();
            GeneralPath intersection = new GeneralPath();
            RealInterval interval = this.getInterval();
            if (interval != null) {
                double ox = (double)SourceNameOverlay.this.canvasWidth / 2.0;
                double oy = (double)SourceNameOverlay.this.canvasHeight / 2.0;
                AffineTransform3D viewerTransform = new AffineTransform3D();
                SourceNameOverlay.this.viewer.state().getViewerTransform(viewerTransform);
                AffineTransform3D transform = new AffineTransform3D();
                this.getTransform(transform);
                transform.preConcatenate(viewerTransform);
                this.rbh.setOrigin(ox, oy);
                this.rbh.setScale(1.0);
                this.rbh.renderBox(interval, transform, front, back, intersection);
                Rectangle screen = new Rectangle(0, 0, SourceNameOverlay.this.canvasWidth, SourceNameOverlay.this.canvasHeight);
                Rectangle rectBounds = intersection.getBounds();
                if (rectBounds.x + rectBounds.width > 0 && rectBounds.x < SourceNameOverlay.this.canvasWidth && rectBounds.y + rectBounds.height > 0 && rectBounds.y < SourceNameOverlay.this.canvasHeight) {
                    Area a = new Area(intersection);
                    a.intersect(new Area(screen));
                    double cx = a.getBounds2D().getCenterX();
                    double cy = a.getBounds2D().getCenterY();
                    graphics.setColor(os.getFrontColor());
                    occupied = SourceNameOverlay.displayNameAt(this.sac, graphics, cx, cy, this.sac.getSpimSource().getName(), occupied);
                }
            }
            return occupied;
        }

        public RealInterval getInterval() {
            long[] dims = new long[3];
            int currentTimePoint = SourceNameOverlay.this.viewer.state().getCurrentTimepoint();
            if (this.sac.getSpimSource().isPresent(currentTimePoint)) {
                this.sac.getSpimSource().getSource(currentTimePoint, 0).dimensions(dims);
                return new FinalRealInterval(new double[]{-0.5, -0.5, -0.5}, new double[]{(double)dims[0] - 0.5, (double)dims[1] - 0.5, (double)dims[2] - 0.5});
            }
            return null;
        }

        public void getTransform(AffineTransform3D transform) {
            this.sac.getSpimSource().getSourceTransform(SourceNameOverlay.this.viewer.state().getCurrentTimepoint(), 0, transform);
        }
    }
}

