/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.beanshell;

import bsh.Primitive;
import bsh.engine.BshScriptEngineFactory;
import java.util.List;
import java.util.stream.Collectors;
import javax.script.ScriptEngineFactory;
import org.scijava.plugin.Plugin;
import org.scijava.script.AdaptedScriptLanguage;
import org.scijava.script.ScriptLanguage;

@Plugin(type=ScriptLanguage.class, name="BeanShell")
public class BeanshellScriptLanguage
extends AdaptedScriptLanguage {
    public BeanshellScriptLanguage() {
        super((ScriptEngineFactory)new BshScriptEngineFactory());
    }

    @Override
    public Object decode(Object object) {
        Primitive p;
        if (object instanceof Primitive && ((p = (Primitive)object) == Primitive.VOID || p == Primitive.NULL)) {
            return null;
        }
        return object;
    }

    @Override
    public List<String> getExtensions() {
        return super.getExtensions().stream().filter(extension -> !"java".equals(extension)).collect(Collectors.toList());
    }

    @Override
    public List<String> getMimeTypes() {
        return super.getMimeTypes().stream().filter(mimeType -> !"application/x-java-source".equals(mimeType)).collect(Collectors.toList());
    }

    @Override
    public List<String> getNames() {
        return super.getNames().stream().filter(name -> !"java".equalsIgnoreCase((String)name)).collect(Collectors.toList());
    }
}

