/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ome.conditions.InternalException;
import ome.util.SqlAction;
import ome.util.TableIdGenerator;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.classic.Session;
import org.hibernate.event.EventSource;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.impl.SessionFactoryImpl;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public class SessionFactory
implements MethodInterceptor {
    private static final Set<String> FORBIDDEN;
    private final org.hibernate.SessionFactory factory;

    public SessionFactory(org.hibernate.SessionFactory factory, SqlAction isolatedSqlAction) {
        this.factory = factory;
        for (Object k : this.factory.getAllClassMetadata().keySet()) {
            IdentifierGenerator ig = ((SessionFactoryImpl)factory).getIdentifierGenerator((String)k);
            if (!(ig instanceof TableIdGenerator)) continue;
            ((TableIdGenerator)ig).setSqlAction(isolatedSqlAction);
        }
    }

    public org.hibernate.Session getSession() {
        org.hibernate.Session unwrapped = SessionFactoryUtils.getSession((org.hibernate.SessionFactory)this.factory, (boolean)false);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setInterfaces(new Class[]{org.hibernate.Session.class, Session.class, EventSource.class});
        proxyFactory.setTarget((Object)unwrapped);
        proxyFactory.addAdvice(0, (Advice)this);
        return (org.hibernate.Session)proxyFactory.getProxy();
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        String name = mi.getMethod().getName();
        if (FORBIDDEN.contains(name)) {
            throw new InternalException(String.format("Usage of session.%s is forbidden. See ticket #73", name));
        }
        return mi.proceed();
    }

    static {
        Method[] methods;
        FORBIDDEN = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("createSQLQuery", "getSession", "doWork", "connection", "disconnect", "reconnect")));
        int found = 0;
        for (Method m : methods = org.hibernate.Session.class.getMethods()) {
            if (!FORBIDDEN.contains(m.getName())) continue;
            ++found;
        }
        if (found < FORBIDDEN.size()) {
            throw new RuntimeException("Method name not found! " + FORBIDDEN);
        }
    }
}

