/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.io.Serializable;
import java.util.Map;
import ome.conditions.ApiUsageException;
import ome.model.IObject;
import ome.tools.hibernate.HibernateUtils;
import org.hibernate.HibernateException;
import org.hibernate.event.EventSource;
import org.hibernate.event.RefreshEvent;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.util.IdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingRefreshEventListener
implements RefreshEventListener {
    private static final long serialVersionUID = 4292680015211981832L;
    private static Logger log = LoggerFactory.getLogger(ReloadingRefreshEventListener.class);

    public void onRefresh(RefreshEvent event) throws HibernateException {
        this.onRefresh(event, IdentityMap.instantiate((int)10));
    }

    public void onRefresh(RefreshEvent event, Map refreshedAlready) throws HibernateException {
        IObject orig = (IObject)event.getObject();
        if (orig.getId() == null) {
            throw new ApiUsageException("Transient entities cannot be refreshed.");
        }
        if (HibernateUtils.isUnloaded(orig)) {
            EventSource source = event.getSession();
            this.log("Reloading unloaded entity:", orig.getClass(), ":", orig.getId());
            Object obj = source.load(orig.getClass(), (Serializable)orig.getId());
            refreshedAlready.put(orig, obj);
            return;
        }
    }

    private void log(Object ... objects) {
        if (log.isDebugEnabled() && objects != null && objects.length > 0) {
            StringBuilder sb = new StringBuilder(objects.length * 16);
            for (Object obj : objects) {
                sb.append(obj.toString());
            }
            log.debug(sb.toString());
        }
    }
}

