/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import ome.annotations.AnnotationUtils;
import ome.annotations.ApiConstraintChecker;
import ome.annotations.Hidden;
import ome.conditions.ApiUsageException;
import ome.conditions.ConcurrencyException;
import ome.conditions.DatabaseBusyException;
import ome.conditions.InternalException;
import ome.conditions.OptimisticLockException;
import ome.conditions.RootException;
import ome.conditions.TryAgain;
import ome.conditions.ValidationException;
import ome.security.basic.CurrentDetails;
import ome.services.messages.RegisterServiceCleanupMessage;
import ome.services.util.Executor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.PropertyValueException;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.HibernateSystemException;
import org.springframework.transaction.CannotCreateTransactionException;

public class ServiceHandler
implements MethodInterceptor,
ApplicationListener {
    private static final int MAX_STRING_LEN = 100;
    private static Logger log = LoggerFactory.getLogger(ServiceHandler.class);
    private final CurrentDetails cd;
    private final long methodTimeError;
    private final long methodTimeWarn;

    public void onApplicationEvent(ApplicationEvent arg0) {
        if (arg0 instanceof RegisterServiceCleanupMessage) {
            RegisterServiceCleanupMessage cleanup = (RegisterServiceCleanupMessage)arg0;
            this.cd.addCleanup(cleanup);
        }
    }

    public ServiceHandler(CurrentDetails cd) {
        this(cd, 5000L, 15000L);
    }

    public ServiceHandler(CurrentDetails cd, long methodTimeWarn, long methodTimeError) {
        this.cd = cd;
        this.methodTimeWarn = methodTimeWarn;
        this.methodTimeError = methodTimeError;
    }

    public Object invoke(MethodInvocation arg0) throws Throwable {
        Object object;
        if (arg0 == null) {
            throw new InternalException("Cannot act on null MethodInvocation. Stopping.");
        }
        Class<?> implClass = arg0.getThis().getClass();
        Method mthd = arg0.getMethod();
        Object[] args = arg0.getArguments();
        ApiConstraintChecker.errorOnViolation(implClass, (Method)mthd, (Object[])args);
        if (log.isInfoEnabled()) {
            if (Executor.LoggedWork.class.isAssignableFrom(arg0.getThis().getClass())) {
                Executor.LoggedWork work = (Executor.LoggedWork)arg0.getThis();
                log.info(" Executor.doWork -- " + work.description());
            } else {
                log.info(" Meth:\t" + arg0.getMethod().getDeclaringClass() + "." + arg0.getMethod().getName());
            }
            log.info(" Args:\t" + this.getArgumentsString(arg0));
        }
        StringBuilder finalOutput = new StringBuilder();
        Slf4JStopWatch stopWatch = new Slf4JStopWatch();
        try {
            Object o = arg0.proceed();
            finalOutput.append(" Rslt:\t");
            finalOutput.append(ServiceHandler.getResultsString(o, null));
            stopWatch.stop("omero.call.success." + implClass.getName() + "." + mthd.getName());
            object = o;
        }
        catch (Throwable t) {
            try {
                finalOutput.append(" Excp:\t");
                finalOutput.append(t.toString());
                stopWatch.stop("omero.call.exception");
                throw this.getAndLogException(t);
            }
            catch (Throwable throwable) {
                if (log.isInfoEnabled()) {
                    log.info(finalOutput.toString());
                }
                long time = stopWatch.getElapsedTime();
                String msg = String.format("Method %s.%s invocation took %s", arg0.getMethod().getDeclaringClass(), arg0.getMethod().getName(), time);
                if (time > this.methodTimeError) {
                    log.error(msg);
                } else if (time > this.methodTimeWarn) {
                    log.warn(msg);
                }
                this.cleanup();
                throw throwable;
            }
        }
        if (log.isInfoEnabled()) {
            log.info(finalOutput.toString());
        }
        long time = stopWatch.getElapsedTime();
        String msg = String.format("Method %s.%s invocation took %s", arg0.getMethod().getDeclaringClass(), arg0.getMethod().getName(), time);
        if (time > this.methodTimeError) {
            log.error(msg);
        } else if (time > this.methodTimeWarn) {
            log.warn(msg);
        }
        this.cleanup();
        return object;
    }

    protected void cleanup() {
        Set<RegisterServiceCleanupMessage> cleanups = this.cd.emptyCleanups();
        for (RegisterServiceCleanupMessage registerServiceCleanupMessage : cleanups) {
            try {
                log.info("Cleanup: " + registerServiceCleanupMessage.resource);
                registerServiceCleanupMessage.close();
            }
            catch (Exception e) {
                log.warn("Error while cleaning up", (Throwable)e);
            }
        }
    }

    protected Throwable getAndLogException(Throwable t) {
        if (null == t) {
            log.error("Exception thrown. (null)");
            return new InternalException("Exception thrown with null message");
        }
        String msg = " Wrapped Exception: (" + t.getClass().getName() + "):\n" + t.getMessage();
        if (RootException.class.isAssignableFrom(t.getClass())) {
            return t;
        }
        if (DeadlockLoserDataAccessException.class.isAssignableFrom(t.getClass())) {
            DeadlockLoserDataAccessException dldae = (DeadlockLoserDataAccessException)t;
            TryAgain ta = new TryAgain(dldae.getMessage(), 500L);
            ta.setStackTrace(t.getStackTrace());
            this.printException("Deadlock exception thrown.", t);
            return ta;
        }
        if (OptimisticLockingFailureException.class.isAssignableFrom(t.getClass())) {
            OptimisticLockException ole = new OptimisticLockException(t.getMessage());
            ole.setStackTrace(t.getStackTrace());
            this.printException("OptimisticLockingFailureException thrown.", t);
            return ole;
        }
        if (ConcurrencyFailureException.class.isAssignableFrom(t.getClass())) {
            ConcurrencyFailureException cfe = (ConcurrencyFailureException)t;
            ConcurrencyException ce = new ConcurrencyException(cfe.getMessage(), 500L);
            ce.setStackTrace(t.getStackTrace());
            this.printException("Unknown concurrency failure", t);
            return ce;
        }
        if (TransientDataAccessResourceException.class.isAssignableFrom(t.getClass())) {
            ConcurrencyFailureException cfe = (ConcurrencyFailureException)t;
            ConcurrencyException ce = new ConcurrencyException(cfe.getMessage(), 500L);
            ce.setStackTrace(t.getStackTrace());
            this.printException("Unknown transient failure", t);
            return ce;
        }
        if (IllegalArgumentException.class.isAssignableFrom(t.getClass())) {
            ApiUsageException aue = new ApiUsageException(t.getMessage());
            aue.setStackTrace(t.getStackTrace());
            this.printException("IllegalArgumentException thrown.", t);
            return aue;
        }
        if (InvalidDataAccessResourceUsageException.class.isAssignableFrom(t.getClass())) {
            ApiUsageException aue = new ApiUsageException(t.getMessage());
            aue.setStackTrace(t.getStackTrace());
            this.printException("InvalidDataAccessResourceUsageException thrown.", t);
            return aue;
        }
        if (DataIntegrityViolationException.class.isAssignableFrom(t.getClass())) {
            ValidationException ve = new ValidationException(t.getMessage());
            ve.setStackTrace(t.getStackTrace());
            this.printException("DataIntegrityViolationException thrown.", t);
            return ve;
        }
        if (CannotCreateTransactionException.class.isAssignableFrom(t.getClass())) {
            DatabaseBusyException dbe = new DatabaseBusyException("cannot create transaction", 5000L);
            dbe.setStackTrace(t.getStackTrace());
            this.printException("CannotCreateTransactionException thrown.", t);
            return dbe;
        }
        if (HibernateObjectRetrievalFailureException.class.isAssignableFrom(t.getClass())) {
            ValidationException ve = new ValidationException(t.getMessage());
            ve.setStackTrace(t.getStackTrace());
            this.printException("HibernateObjectRetrievalFailureException thrown.", t);
            return ve;
        }
        if (HibernateSystemException.class.isAssignableFrom(t.getClass())) {
            Throwable cause = t.getCause();
            if (cause == null || cause == t) {
                return this.wrapUnknown(t, msg);
            }
            if (PropertyValueException.class.isAssignableFrom(cause.getClass())) {
                ValidationException ve = new ValidationException(cause.getMessage());
                ve.setStackTrace(cause.getStackTrace());
                this.printException("PropertyValueException thrown.", cause);
                return ve;
            }
            return this.wrapUnknown(t, msg);
        }
        return this.wrapUnknown(t, msg);
    }

    private Throwable wrapUnknown(Throwable t, String msg) {
        if (t instanceof Error) {
            log.error("java.lang.Error: " + msg, t);
        }
        InternalException re = new InternalException(msg);
        re.setStackTrace(t.getStackTrace());
        this.printException("Unknown exception thrown.", t);
        return re;
    }

    private String getArgumentsString(MethodInvocation mi) {
        Object[] args = mi.getArguments();
        if (args == null || args.length < 1) {
            return "()";
        }
        String[] prnt = new String[args.length];
        for (int i = 0; i < prnt.length; ++i) {
            prnt[i] = args[i] == null ? "null" : ServiceHandler.getResultsString(args[i], null);
        }
        Object[] allAnnotations = AnnotationUtils.findParameterAnnotations(mi.getThis().getClass(), (Method)mi.getMethod());
        for (int j = 0; j < allAnnotations.length; ++j) {
            Annotation[][] anns = (Annotation[][])allAnnotations[j];
            if (anns == null) continue;
            for (int i = 0; i < args.length; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = anns[i]) {
                    if (!Hidden.class.equals(annotation.annotationType())) continue;
                    prnt[i] = "********";
                }
            }
        }
        String arguments = Arrays.asList(prnt).toString();
        return arguments;
    }

    public static String getResultsString(Object o, IdentityHashMap<Object, String> cache) {
        if (o == null) {
            return "null";
        }
        if (cache == null) {
            cache = new IdentityHashMap();
        } else if (cache.containsKey(o)) {
            return cache.get(o);
        }
        if (o instanceof Collection) {
            int count = 0;
            StringBuilder sb = new StringBuilder(128);
            sb.append("(");
            Collection c = (Collection)o;
            for (Object obj : c) {
                if (count > 0) {
                    sb.append(", ");
                }
                if (count > 2) {
                    sb.append("... ");
                    sb.append(c.size() - 3);
                    sb.append(" more");
                    break;
                }
                sb.append(ServiceHandler.getResultsString(obj, cache));
                ++count;
            }
            sb.append(")");
            return sb.toString();
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            int count = 0;
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Object k : map.keySet()) {
                if (count > 0) {
                    sb.append(", ");
                }
                if (count > 2) {
                    sb.append("... ");
                    sb.append(map.size() - 3);
                    sb.append(" more");
                    break;
                }
                sb.append(k);
                sb.append("=");
                cache.put(o, o.getClass().getName() + ":" + System.identityHashCode(o));
                sb.append(ServiceHandler.getResultsString(map.get(k), cache));
                ++count;
            }
            sb.append("}");
            return sb.toString();
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            if (length == 0) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder(128);
            sb.append("[");
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                if (i > 2) {
                    sb.append("... ");
                    sb.append(i - 2);
                    sb.append(" more");
                    break;
                }
                sb.append(ServiceHandler.getResultsString(Array.get(o, i), cache));
            }
            sb.append("]");
            return sb.toString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        if (s.length() > 100) {
            s = s.substring(0, 100);
        }
        return s;
    }

    private void printException(String msg, Throwable ex) {
        if (log.isWarnEnabled()) {
            log.warn(msg + "\n", ex);
        }
    }
}

