/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sharing;

import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import ome.conditions.SessionException;
import ome.security.basic.CurrentDetails;
import ome.services.sessions.SessionContext;
import ome.services.sessions.state.SessionCache;
import ome.system.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class ShareRestrictionTransactionAttributeSource
implements TransactionAttributeSource {
    private static final Logger log = LoggerFactory.getLogger(ShareRestrictionTransactionAttributeSource.class);
    private final CurrentDetails current;
    private final SessionCache cache;

    public ShareRestrictionTransactionAttributeSource(CurrentDetails details, SessionCache cache) {
        this.current = details;
        this.cache = cache;
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        try {
            Principal principal = this.current.getLast();
            String uuid = principal.getName();
            SessionContext ec = this.cache.getSessionContext(uuid);
            Long shareId = ec.getCurrentShareId();
            if (ec.getCurrentShareId() != null) {
                log.debug("Returning readOnly tx for shared " + shareId);
                DefaultTransactionAttribute ta = new DefaultTransactionAttribute();
                ta.setReadOnly(true);
                return ta;
            }
        }
        catch (SessionException se) {
            return null;
        }
        catch (NoSuchElementException nse) {
            return null;
        }
        return null;
    }
}

