/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import ome.annotations.Hidden;
import ome.annotations.NotNull;
import ome.annotations.RolesAllowed;
import ome.api.ServiceInterface;
import ome.api.local.LocalSession;
import ome.conditions.AuthenticationException;
import ome.conditions.RootException;
import ome.conditions.SecurityViolation;
import ome.conditions.SessionException;
import ome.model.enums.AdminPrivilege;
import ome.model.meta.Experimenter;
import ome.model.meta.Session;
import ome.security.basic.CurrentDetails;
import ome.security.basic.LightAdminPrivileges;
import ome.services.sessions.SessionContext;
import ome.services.sessions.SessionManager;
import ome.services.util.Executor;
import ome.system.EventContext;
import ome.system.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SessionBean
implements LocalSession {
    private static final Logger log = LoggerFactory.getLogger(SessionBean.class);
    private final SessionManager mgr;
    private final Executor ex;
    private final CurrentDetails cd;
    private final LightAdminPrivileges adminPrivileges;

    public SessionBean(SessionManager mgr, Executor ex, CurrentDetails cd, LightAdminPrivileges adminPrivileges) {
        this.mgr = mgr;
        this.ex = ex;
        this.cd = cd;
        this.adminPrivileges = adminPrivileges;
    }

    public Class<? extends ServiceInterface> getServiceInterface() {
        return LocalSession.class;
    }

    @RolesAllowed(value={"user", "HasPassword"})
    public Session createUserSession(final long timeToLiveMs, final long timeToIdleMs, String defaultGroup) {
        String user = this.currentContext().getCurrentUserName();
        if (user == null) {
            throw new SecurityViolation("No current user");
        }
        EventContext context = this.currentContext();
        final Session currentSession = context instanceof SessionContext ? ((SessionContext)context).getSession() : null;
        final String agent = this.cd.size() > 0 ? this.cd.getContext().get("omero.agent") : null;
        try {
            final Principal principal = this.principal(defaultGroup, user);
            Future<Session> future = this.ex.submit(new Callable<Session>(){

                @Override
                public Session call() throws Exception {
                    Experimenter sudoer;
                    SessionManager.CreationRequest req = new SessionManager.CreationRequest();
                    req.principal = principal;
                    String string = req.agent = agent == null ? "createSession" : agent;
                    if (currentSession != null && (sudoer = currentSession.getSudoer()) != null) {
                        req.sudoer = sudoer.getId();
                    }
                    Session session = SessionBean.this.mgr.createFromRequest(req);
                    session.setTimeToIdle(Long.valueOf(timeToIdleMs));
                    session.setTimeToLive(Long.valueOf(timeToLiveMs));
                    return SessionBean.this.mgr.update(session, false);
                }
            });
            return this.ex.get(future);
        }
        catch (Exception e) {
            throw this.creationExceptionHandler(e);
        }
    }

    @RolesAllowed(value={"user"})
    public Session createSessionWithTimeout(@NotNull Principal principal, long milliseconds) {
        return this.createSessionWithTimeouts(principal, milliseconds, 0L);
    }

    @RolesAllowed(value={"user"})
    public Session createSessionWithTimeouts(final @NotNull Principal principal, long timeToLiveMilliseconds, long timeToIdleMilliseconds) {
        ImmutableSet<AdminPrivilege> privileges;
        EventContext context = this.currentContext();
        Session currentSession = context instanceof SessionContext ? ((SessionContext)context).getSession() : null;
        Object groupsLed = context.isCurrentUserAdmin() ? (currentSession != null ? ((privileges = this.adminPrivileges.getSessionPrivileges(currentSession)).contains(this.adminPrivileges.getPrivilege("Sudo")) ? null : context.getLeaderOfGroupsList()) : null) : context.getLeaderOfGroupsList();
        final String agent = this.cd.size() > 0 ? this.cd.getContext().get("omero.agent") : null;
        try {
            Future<Session> future = this.ex.submit(new Callable<Session>((List)groupsLed, timeToIdleMilliseconds, timeToLiveMilliseconds, context, currentSession){
                final /* synthetic */ List val$groupsLed;
                final /* synthetic */ long val$timeToIdleMilliseconds;
                final /* synthetic */ long val$timeToLiveMilliseconds;
                final /* synthetic */ EventContext val$context;
                final /* synthetic */ Session val$currentSession;
                {
                    this.val$groupsLed = list;
                    this.val$timeToIdleMilliseconds = l;
                    this.val$timeToLiveMilliseconds = l2;
                    this.val$context = eventContext;
                    this.val$currentSession = session;
                }

                @Override
                public Session call() throws Exception {
                    Experimenter sudoer;
                    SessionManager.CreationRequest req = new SessionManager.CreationRequest();
                    req.principal = principal;
                    req.agent = agent == null ? "OMERO.sudo" : agent;
                    req.groupsLed = this.val$groupsLed;
                    req.timeToIdle = this.val$timeToIdleMilliseconds;
                    req.timeToLive = this.val$timeToLiveMilliseconds;
                    req.sudoer = this.val$context.getCurrentUserId();
                    if (this.val$currentSession != null && (sudoer = this.val$currentSession.getSudoer()) != null) {
                        req.sudoer = sudoer.getId();
                    }
                    return SessionBean.this.mgr.createFromRequest(req);
                }
            });
            return this.ex.get(future);
        }
        catch (Exception e) {
            throw this.creationExceptionHandler(e);
        }
    }

    @RolesAllowed(value={"user", "guest"})
    public Session createSession(@NotNull Principal principal, @Hidden String credentials) {
        Session session = null;
        try {
            String agent = null;
            if (this.cd.size() > 0) {
                agent = this.cd.getContext().get("omero.agent");
            }
            if (agent == null) {
                agent = "createSession";
            }
            session = this.mgr.createWithAgent(principal, credentials, agent, null);
        }
        catch (Exception e) {
            throw this.creationExceptionHandler(e);
        }
        return session;
    }

    @RolesAllowed(value={"user", "guest"})
    public Session getSession(@NotNull String sessionUuid) {
        return this.mgr.find(sessionUuid);
    }

    @Override
    @RolesAllowed(value={"user", "guest"})
    public Session getSessionQuietly(@NotNull String sessionUuid) {
        return this.mgr.findQuietly(sessionUuid);
    }

    @RolesAllowed(value={"user", "guest"})
    public int getReferenceCount(@NotNull String sessionUuid) {
        return this.mgr.getReferenceCount(sessionUuid);
    }

    @RolesAllowed(value={"user", "guest"})
    public Session updateSession(final @NotNull Session session) {
        Future<Session> future = this.ex.submit(new Callable<Session>(){

            @Override
            public Session call() throws Exception {
                return SessionBean.this.mgr.update(session);
            }
        });
        return this.ex.get(future);
    }

    @RolesAllowed(value={"user", "guest"})
    public int closeSession(final @NotNull Session session) {
        Future<Integer> future = this.ex.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return SessionBean.this.mgr.close(session.getUuid());
            }
        });
        return this.ex.get(future);
    }

    @RolesAllowed(value={"user"})
    public List<Session> getMyOpenSessions() {
        final String uuid = this.currentContext().getCurrentSessionUuid();
        Future<List<Session>> future = this.ex.submit(new Callable<List<Session>>(){

            @Override
            public List<Session> call() throws Exception {
                return SessionBean.this.mgr.findSameUser(uuid, new String[0]);
            }
        });
        return this.ex.get(future);
    }

    @RolesAllowed(value={"user"})
    public List<Session> getMyOpenAgentSessions(final String agent) {
        final String uuid = this.currentContext().getCurrentSessionUuid();
        Future<List<Session>> future = this.ex.submit(new Callable<List<Session>>(){

            @Override
            public List<Session> call() throws Exception {
                return SessionBean.this.mgr.findSameUser(uuid, agent);
            }
        });
        return this.ex.get(future);
    }

    @RolesAllowed(value={"user"})
    public List<Session> getMyOpenClientSessions() {
        final String uuid = this.currentContext().getCurrentSessionUuid();
        Future<List<Session>> future = this.ex.submit(new Callable<List<Session>>(){

            @Override
            public List<Session> call() throws Exception {
                return SessionBean.this.mgr.findSameUser(uuid, "OMERO.insight", "OMERO.web", "OMERO.importer");
            }
        });
        return this.ex.get(future);
    }

    @RolesAllowed(value={"user", "guest"})
    public Object getInput(String session, String key) {
        return this.mgr.getInput(session, key);
    }

    @RolesAllowed(value={"user", "guest"})
    public Object getOutput(String session, String key) {
        return this.mgr.getOutput(session, key);
    }

    @RolesAllowed(value={"user", "guest"})
    public void setInput(String session, String key, Object object) {
        this.mgr.setInput(session, key, object);
    }

    @RolesAllowed(value={"user", "guest"})
    public void setOutput(String session, String key, Object object) {
        this.mgr.setOutput(session, key, object);
    }

    @RolesAllowed(value={"user", "guest"})
    public Set<String> getInputKeys(String session) {
        return this.mgr.inputEnvironment(session).keySet();
    }

    @RolesAllowed(value={"user", "guest"})
    public Set<String> getOutputKeys(String session) {
        return this.mgr.outputEnvironment(session).keySet();
    }

    @RolesAllowed(value={"user", "guest"})
    public Map<String, Object> getInputs(String session) {
        return this.mgr.inputEnvironment(session);
    }

    @RolesAllowed(value={"user", "guest"})
    public Map<String, Object> getOutputs(String session) {
        return this.mgr.outputEnvironment(session);
    }

    EventContext currentContext() {
        String user = this.cd.getLast().getName();
        return this.mgr.getEventContext(new Principal(user));
    }

    private Principal principal(String defaultGroup, String user) {
        Principal p = defaultGroup != null ? new Principal(user, defaultGroup, "User") : new Principal(user);
        return p;
    }

    RuntimeException creationExceptionHandler(Exception e) {
        log.info("Handling session exception: ", (Throwable)e);
        if (e instanceof SessionException) {
            return (SessionException)e;
        }
        if (e instanceof SecurityViolation) {
            return (SecurityViolation)e;
        }
        if (e instanceof RootException) {
            return (AuthenticationException)new AuthenticationException("Error creating session.").initCause((Throwable)e);
        }
        return new AuthenticationException("Unknown error (" + e.getClass().getName() + "):" + e.getMessage());
    }
}

