/*
 * Decompiled with CFR 0.152.
 */
package ome.services.search;

import ome.conditions.ApiUsageException;
import ome.model.internal.Details;
import ome.tools.hibernate.QueryBuilder;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

class OwnerOrGroup {
    String path;
    long id;

    OwnerOrGroup(Details d) {
        this(d, "");
    }

    OwnerOrGroup(Details d, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (d != null) {
            if (d.getOwner() != null) {
                Long _id = d.getOwner().getId();
                if (_id == null) {
                    throw new ApiUsageException("Id for owner cannot be null.");
                }
                this.id = _id;
                this.path = prefix + "details.owner.id";
            } else if (d.getGroup() != null) {
                Long _id = d.getGroup().getId();
                if (_id == null) {
                    throw new ApiUsageException("Id for group cannot be null.");
                }
                this.id = _id;
                this.path = prefix + "details.group.id";
            }
        }
    }

    boolean needed() {
        return this.path != null;
    }

    private void check() {
        if (this.path == null) {
            throw new ApiUsageException("Please call \"needs()\" first.");
        }
    }

    void on(Criteria criteria) {
        this.on(criteria, true);
    }

    void on(Criteria criteria, boolean equals) {
        this.check();
        if (equals) {
            criteria.add((Criterion)Restrictions.eq((String)this.path, (Object)this.id));
        } else {
            criteria.add((Criterion)Restrictions.ne((String)this.path, (Object)this.id));
        }
    }

    void on(QueryBuilder qb) {
        this.on(qb, true);
    }

    void on(QueryBuilder qb, boolean equals) {
        this.check();
        String op = equals ? "=" : "!=";
        String unique = qb.unique_alias("owner");
        qb.and(this.path);
        qb.append(" ");
        qb.append(op);
        qb.append(" :");
        qb.append(unique);
        qb.appendSpace();
        qb.param(unique, (Object)this.id);
    }
}

