/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import ome.api.IQuery;
import ome.services.query.HierarchyNavigator;

public abstract class HierarchyNavigatorWrap<T, E>
extends HierarchyNavigator {
    public HierarchyNavigatorWrap(IQuery iQuery) {
        super(iQuery);
    }

    protected abstract String typeToString(T var1);

    protected abstract T stringToType(String var1);

    protected abstract Map.Entry<String, Long> entityToStringLong(E var1);

    protected abstract E stringLongToEntity(String var1, long var2);

    public void prepareLookups(T toType, Collection<E> from) {
        String toTypeAsString = this.typeToString(toType);
        HashMultimap fromIdsByType = HashMultimap.create();
        for (E entity : from) {
            Map.Entry<String, Long> fromAsStringLong = this.entityToStringLong(entity);
            fromIdsByType.put((Object)fromAsStringLong.getKey(), (Object)fromAsStringLong.getValue());
        }
        for (String fromTypeAsString : fromIdsByType.keySet()) {
            Set fromIdsAsLongs = fromIdsByType.get((Object)fromTypeAsString);
            this.prepareLookups(toTypeAsString, fromTypeAsString, fromIdsAsLongs);
        }
    }

    public ImmutableSet<E> doLookup(T toType, E from) {
        String toTypeAsString = this.typeToString(toType);
        Map.Entry<String, Long> fromAsStringLong = this.entityToStringLong(from);
        ImmutableSet.Builder to = ImmutableSet.builder();
        for (Long toIdAsLong : this.doLookup(toTypeAsString, fromAsStringLong.getKey(), fromAsStringLong.getValue())) {
            to.add(this.stringLongToEntity(toTypeAsString, toIdAsLong));
        }
        return to.build();
    }
}

