/*
 * Decompiled with CFR 0.152.
 */
package ome.services.mail;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ome.api.IQuery;
import ome.model.meta.Experimenter;
import ome.parameters.Parameters;
import ome.services.mail.MailUtil;
import ome.services.util.Executor;
import ome.system.Roles;
import ome.util.SqlAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class MailSender {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean enabled;
    private Executor executor;
    private MailUtil util;
    private IQuery query;
    private Roles roles;
    private String subjectPrefix = "[OMERO] ";
    private String defaultBody = "Automated email sent by the OMERO server.\n";

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public MailUtil getMailUtil() {
        return this.util;
    }

    public void setMailUtil(MailUtil util) {
        this.util = util;
    }

    public IQuery getQueryService() {
        return this.query;
    }

    public void setQueryService(IQuery query) {
        this.query = query;
    }

    public Roles getRoles() {
        return this.roles;
    }

    public void setRoles(Roles roles) {
        this.roles = roles;
    }

    public String getSubjectPrefix() {
        return this.subjectPrefix;
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    public String getDefaultBody() {
        return this.defaultBody;
    }

    public void setDefaultBody(String defaultBody) {
        this.defaultBody = defaultBody;
    }

    protected void sendBlind(Set<String> addresses, String subject) {
        this.sendBlind(addresses, subject, this.getDefaultBody());
    }

    protected void sendBlind(Set<String> addresses, String subject, String body) {
        if (!this.isEnabled()) {
            this.log.warn("sendBlind called when mail is disabled.");
            return;
        }
        if (addresses == null || addresses.isEmpty()) {
            this.log.debug("No emails found.");
            return;
        }
        for (String address : addresses) {
            try {
                this.getMailUtil().sendEmail(address, this.getSubjectPrefix() + subject, body, false, null, null);
            }
            catch (Exception e) {
                this.log.error("Failed to send email: {} ", (Object)address, (Object)e);
            }
        }
    }

    protected String getUserEmail(String user) {
        Experimenter e = (Experimenter)this.getQueryService().findByString(Experimenter.class, "omeName", user);
        if (e == null) {
            return null;
        }
        return e.getEmail();
    }

    protected void addUser(Set<String> addresses, Experimenter exp) {
        String email = exp.getEmail();
        if (!StringUtils.isEmpty((String)email)) {
            addresses.add(email);
        }
    }

    protected Set<String> getAllSystemUsers(boolean newTx) {
        HashSet<String> addresses = new HashSet<String>();
        if (newTx) {
            this.loadFromAction(addresses);
        } else {
            this.loadFromQuery(addresses);
        }
        return addresses;
    }

    private void loadFromQuery(Set<String> addresses) {
        for (Object[] o : this.getQueryService().projection("select e.email from Experimenter e join e.groupExperimenterMap m join m.parent g where g.id = :id", new Parameters().addId(Long.valueOf(this.getRoles().getSystemGroupId())))) {
            String email;
            if (o == null || o.length < 1 || o[0] == null || (email = o[0].toString()).isEmpty()) continue;
            addresses.add(email);
        }
    }

    private void loadFromAction(Set<String> addresses) {
        Collection rv = (Collection)this.executor.executeSql(new Executor.SimpleSqlWork(this, "loadAdminEmails", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Collection<String> doWork(SqlAction sql) {
                return sql.getUserEmailsByGroup(MailSender.this.roles.getSystemGroupId());
            }
        });
        for (String email : rv) {
            if (email.isEmpty()) continue;
            addresses.add(email);
        }
    }
}

