/*
 * Decompiled with CFR 0.152.
 */
package ome.services.graphs;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.internal.Details;
import ome.model.internal.NamedValue;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.security.ACLVoter;
import ome.security.basic.LightAdminPrivileges;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.system.EventContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphTraversal {
    private static final Logger log = LoggerFactory.getLogger(GraphTraversal.class);
    private static final int BATCH_SIZE = 256;
    private static final Set<String> NO_SUBCLASS_QUERY = Collections.synchronizedSet(new HashSet());
    private final Session session;
    private final EventContext eventContext;
    private final boolean isCheckUserPermissions;
    private final ACLVoter aclVoter;
    private final GraphPathBean model;
    private final SetMultimap<String, String> unnullable;
    private final Set<Milestone> progress = EnumSet.noneOf(Milestone.class);
    private final Planning planning;
    private final GraphPolicy policy;
    private final Processor processor;
    @Deprecated
    private boolean isOwnsAll = false;

    public GraphTraversal(Session session, EventContext eventContext, ACLVoter aclVoter, GraphPathBean graphPathBean, SetMultimap<String, String> unnullable, GraphPolicy policy, Processor processor) {
        this.session = session;
        this.eventContext = eventContext;
        this.aclVoter = aclVoter;
        this.model = graphPathBean;
        this.unnullable = unnullable;
        this.planning = new Planning();
        this.policy = policy;
        this.processor = log.isDebugEnabled() ? GraphTraversal.debugWrap(processor) : processor;
        this.isCheckUserPermissions = !LightAdminPrivileges.getAllPrivileges().equals((Object)eventContext.getCurrentAdminPrivileges());
    }

    public Map.Entry<SetMultimap<String, Long>, SetMultimap<String, Long>> planOperation(SetMultimap<String, Long> objects, boolean include, boolean applyRules) throws GraphException {
        if (this.progress.contains((Object)Milestone.PLANNED)) {
            throw new IllegalStateException("operation already planned");
        }
        Set<CI> targetSet = include ? this.planning.included : this.planning.deleted;
        targetSet.addAll(this.objectsToCIs(objects));
        if (applyRules) {
            this.planning.toProcess.addAll(targetSet);
            this.planOperation();
            this.orderFileDeletion();
        } else {
            for (CI cI : targetSet) {
                this.planning.blockedBy.put(cI, new HashSet());
            }
        }
        this.progress.add(Milestone.PLANNED);
        HashMultimap included = HashMultimap.create();
        for (CI includedObject : this.planning.included) {
            included.put((Object)includedObject.className, (Object)includedObject.id);
        }
        HashMultimap hashMultimap = HashMultimap.create();
        for (CI deletedObject : this.planning.deleted) {
            hashMultimap.put((Object)deletedObject.className, (Object)deletedObject.id);
        }
        return new AbstractMap.SimpleImmutableEntry<HashMultimap, HashMultimap>(included, hashMultimap);
    }

    public Map.Entry<Collection<IObject>, Collection<IObject>> planOperation(Collection<? extends IObject> objectInstances, boolean include, boolean applyRules) throws GraphException {
        if (this.progress.contains((Object)Milestone.PLANNED)) {
            throw new IllegalStateException("operation already planned");
        }
        Set<CI> targetSet = include ? this.planning.included : this.planning.deleted;
        HashMultimap objectsToQuery = HashMultimap.create();
        for (IObject iObject : objectInstances) {
            if (iObject.isLoaded() && iObject.getDetails() != null) {
                CI object = new CI(iObject);
                this.noteDetails(object, iObject.getDetails());
                targetSet.add(object);
                continue;
            }
            objectsToQuery.put((Object)iObject.getClass().getName(), (Object)iObject.getId());
        }
        targetSet.addAll(this.objectsToCIs((SetMultimap<String, Long>)objectsToQuery));
        if (applyRules) {
            this.planning.toProcess.addAll(targetSet);
            this.planOperation();
            this.orderFileDeletion();
        } else {
            for (CI cI : targetSet) {
                this.planning.blockedBy.put(cI, new HashSet());
            }
        }
        this.progress.add(Milestone.PLANNED);
        ArrayList<IObject> included = new ArrayList<IObject>(this.planning.included.size());
        for (CI includedObject : this.planning.included) {
            included.add(includedObject.toIObject());
        }
        ArrayList<IObject> arrayList = new ArrayList<IObject>(this.planning.deleted.size());
        for (CI deletedObject : this.planning.deleted) {
            arrayList.add(deletedObject.toIObject());
        }
        return new AbstractMap.SimpleImmutableEntry<Collection<IObject>, Collection<IObject>>(included, arrayList);
    }

    /*
     * Unable to fully structure code
     */
    private void planOperation() throws GraphException {
        optimisticReprocess = null;
        isNotLast = null;
        block0: while (true) {
            if (!this.planning.toProcess.isEmpty() || !this.planning.findIfLast.isEmpty()) {
                toProcess = new HashSet<CI>(this.planning.toProcess);
                toProcess.retainAll(this.planning.cached);
                toProcess.removeAll(this.planning.findIfLast);
                if (!toProcess.isEmpty()) {
                    if (optimisticReprocess != null && !Sets.difference(this.planning.toProcess, optimisticReprocess).isEmpty()) {
                        optimisticReprocess = null;
                    }
                    var4_4 = toProcess.iterator();
                    while (true) {
                        if (!var4_4.hasNext()) continue block0;
                        nextObject = (CI)var4_4.next();
                        this.reviewObject(nextObject, false);
                    }
                }
                toCache = new HashSet<CI>(this.planning.toProcess);
                toCache.removeAll(this.planning.cached);
                if (!toCache.isEmpty()) {
                    optimisticReprocess = null;
                    this.cache(toCache);
                    continue;
                }
                if (!this.planning.toProcess.isEmpty()) {
                    previousToProcess = new HashSet<CI>(this.planning.toProcess);
                    previousFindIfLast = new HashSet<CI>(this.planning.findIfLast);
                    var7_7 = previousToProcess.iterator();
                    while (var7_7.hasNext()) {
                        nextObject = (CI)var7_7.next();
                        this.reviewObject(nextObject, false);
                    }
                    if (!(Sets.symmetricDifference(previousFindIfLast, this.planning.findIfLast).isEmpty() && (optimisticReprocess != null && Sets.symmetricDifference(this.planning.toProcess, optimisticReprocess).isEmpty() || Sets.symmetricDifference((Set)previousToProcess, this.planning.toProcess).isEmpty()))) {
                        optimisticReprocess = new HashSet<CI>(this.planning.toProcess);
                        continue;
                    }
                }
                optimisticReprocess = null;
                for (CI orphan : this.planning.findIfLast) {
                    this.planning.foundIfLast.put(orphan, true);
                    this.planning.unchanged.clear();
                    if (!GraphTraversal.log.isDebugEnabled()) continue;
                    GraphTraversal.log.debug("marked " + orphan + " as " + (Object)GraphPolicy.Orphan.IS_LAST);
                }
                this.planning.toProcess.addAll(this.planning.findIfLast);
                this.planning.findIfLast.clear();
                continue;
            }
            latestIsNotLast = new HashSet<CI>();
            for (Map.Entry<CI, Boolean> objectAndIsLast : this.planning.foundIfLast.entrySet()) {
                if (objectAndIsLast.getValue().booleanValue()) continue;
                latestIsNotLast.add(objectAndIsLast.getKey());
            }
            if (latestIsNotLast.isEmpty() || isNotLast != null && Sets.difference(isNotLast, latestIsNotLast).isEmpty()) break;
            isNotLast = latestIsNotLast;
            this.planning.toProcess.addAll(isNotLast);
            this.planning.findIfLast.addAll(isNotLast);
            var4_4 = isNotLast.iterator();
            while (true) {
                if (var4_4.hasNext()) ** break;
                continue block0;
                object = (CI)var4_4.next();
                this.planning.foundIfLast.remove(object);
                this.planning.unchanged.clear();
                if (!GraphTraversal.log.isDebugEnabled()) continue;
                GraphTraversal.log.debug("marked " + object + " as " + (Object)GraphPolicy.Orphan.RELEVANT + " to verify " + (Object)GraphPolicy.Orphan.IS_NOT_LAST + " status");
            }
            break;
        }
    }

    public void assertNoPolicyViolations() throws GraphException {
        if (!this.progress.contains((Object)Milestone.PLANNED)) {
            throw new IllegalStateException("operation not yet planned");
        }
        for (CI object : this.planning.cached) {
            this.reviewObject(object, true);
        }
    }

    private void noteDetails(CI object, Details objectDetails) throws GraphException {
        IObject objectInstance = object.toIObject();
        if (this.planning.detailsNoted.put(object, objectDetails) != null) {
            return;
        }
        if (this.isCheckUserPermissions) {
            Experimenter objectOwner;
            ExperimenterGroup loadedGroup;
            Permissions permissions;
            if (objectInstance instanceof OriginalFile) {
                String query = "SELECT mimetype, repo FROM OriginalFile WHERE id = :id";
                Object[] result = (Object[])this.session.createQuery("SELECT mimetype, repo FROM OriginalFile WHERE id = :id").setLong("id", object.id).uniqueResult();
                OriginalFile file = new OriginalFile(Long.valueOf(object.id), true);
                file.setMimetype((String)result[0]);
                file.setRepo((String)result[1]);
                objectInstance = file;
                ExperimenterGroup objectGroup = objectDetails.getGroup();
                ExperimenterGroup objectGroupFake = this.planning.fakeGroups.get(objectGroup.getId());
                if (objectGroupFake == null) {
                    NamedValue nv = new NamedValue("omero.policy.binary_access", "-write");
                    Iterator membershipIterator = objectGroup.iterateGroupExperimenterMap();
                    objectGroupFake = new ExperimenterGroup(objectGroup.getId(), true);
                    objectGroupFake.putAt("ome.model.meta.ExperimenterGroup_config", (Object)Lists.newArrayList((Object[])new NamedValue[]{nv}));
                    objectGroupFake.putAt("ome.model.meta.ExperimenterGroup_details", (Object)objectGroup.getDetails());
                    objectGroupFake.putAt("ome.model.meta.ExperimenterGroup_groupExperimenterMap", (Object)ImmutableSet.copyOf((Iterator)membershipIterator));
                    objectGroupFake.putAt("ome.model.meta.ExperimenterGroup_name", (Object)objectGroup.getName());
                    this.planning.fakeGroups.put(objectGroup.getId(), objectGroupFake);
                }
                objectDetails.setGroup(objectGroupFake);
            }
            this.aclVoter.allowLoad(this.session, objectInstance.getClass(), objectDetails, object.id);
            try {
                Details details = (Details)PropertyUtils.getProperty((Object)objectInstance, (String)"details");
                details.setOwner(objectDetails.getOwner());
                details.setGroup(objectDetails.getGroup());
                details.setPermissions(objectDetails.getPermissions());
                this.aclVoter.postProcess(objectInstance);
                permissions = objectInstance.getDetails().getPermissions();
            }
            catch (ReflectiveOperationException roe) {
                log.warn("failed to get details of " + object, (Throwable)roe);
                permissions = objectDetails.getPermissions();
            }
            if (!permissions.isDisallowEdit()) {
                this.planning.mayUpdate.add(object);
            }
            if (!permissions.isDisallowDelete()) {
                this.planning.mayDelete.add(object);
            }
            if (!permissions.isDisallowChgrp()) {
                this.planning.mayChgrp.add(object);
            }
            if (!permissions.isDisallowChown()) {
                this.planning.mayChown.add(object);
            }
            if (objectInstance instanceof ExperimenterGroup && this.aclVoter.allowChmod((IObject)(loadedGroup = (ExperimenterGroup)this.session.load(ExperimenterGroup.class, (Serializable)Long.valueOf(object.id))))) {
                this.planning.mayChmod.add(object);
            }
            if ((objectOwner = objectDetails.getOwner()) != null && (this.isOwnsAll || this.eventContext.getCurrentUserId().equals(objectOwner.getId()))) {
                this.planning.owns.add(object);
            }
        }
        this.policy.noteDetails(this.session, objectInstance, object.className, object.id);
    }

    private Map<Long, CI> findObjectDetails(String className, Collection<Long> ids) throws GraphException {
        HashMap<Long, CI> objectsById = new HashMap<Long, CI>();
        HashSet<Long> idsToQuery = new HashSet<Long>();
        for (Long id : ids) {
            CI cI = new CI(className, id);
            CI alias = this.planning.aliases.get(cI);
            if (alias == null) {
                idsToQuery.add(id);
                continue;
            }
            objectsById.put(cI.id, alias);
        }
        if (!idsToQuery.isEmpty()) {
            boolean subclassesQueried = false;
            if (!NO_SUBCLASS_QUERY.contains(className)) {
                try {
                    String rootQuery = "SELECT r.id, TYPE(r) FROM " + className + " r WHERE r.id IN (:ids)";
                    for (List idsBatch : Iterables.partition(idsToQuery, (int)256)) {
                        for (Object[] result : this.session.createQuery(rootQuery).setParameterList("ids", (Collection)idsBatch).list()) {
                            Long id = (Long)result[0];
                            Class objectClass = (Class)result[1];
                            CI object = new CI(objectClass.getName(), id);
                            objectsById.put(object.id, object);
                            this.planning.aliases.put(new CI(className, object.id), object);
                        }
                    }
                    subclassesQueried = true;
                }
                catch (NullPointerException | QueryException e) {
                    NO_SUBCLASS_QUERY.add(className);
                }
            }
            if (!subclassesQueried) {
                for (Long l : idsToQuery) {
                    CI object = new CI(className, l);
                    objectsById.put(object.id, object);
                    this.planning.aliases.put(object, object);
                }
            }
            HashSet<String> linkProperties = new HashSet<String>();
            for (String superclassName : this.model.getSuperclassesOfReflexive(className)) {
                Object[] result;
                Set<Map.Entry<String, String>> forwardLinks = this.model.getLinkedTo(superclassName);
                result = forwardLinks.iterator();
                while (result.hasNext()) {
                    Map.Entry<String, String> forwardLink = result.next();
                    linkProperties.add(forwardLink.getValue());
                }
            }
            ImmutableList immutableList = ImmutableList.of((Object)"details.owner", (Object)"details.group");
            ArrayList<String> selectTerms = new ArrayList<String>(immutableList.size() + 1);
            selectTerms.add("root.id");
            for (String soughtProperty : immutableList) {
                if (linkProperties.contains(soughtProperty)) {
                    selectTerms.add("root." + soughtProperty);
                    continue;
                }
                selectTerms.add("NULLIF(0,0)");
            }
            selectTerms.add("root.details.permissions");
            String detailsQuery = "SELECT " + Joiner.on((char)',').join(selectTerms) + " FROM " + className + " AS root WHERE root.id IN (:ids)";
            for (List idsBatch : Iterables.partition(idsToQuery, (int)256)) {
                Query hibernateQuery = this.session.createQuery(detailsQuery).setParameterList("ids", (Collection)idsBatch);
                for (Object[] result : hibernateQuery.list()) {
                    Details details = Details.create();
                    Long id = (Long)result[0];
                    details.setOwner((Experimenter)result[1]);
                    details.setGroup((ExperimenterGroup)result[2]);
                    details.setPermissions((Permissions)result[3]);
                    this.noteDetails((CI)objectsById.get(id), details);
                }
            }
        }
        return objectsById;
    }

    private Collection<CI> objectsToCIs(SetMultimap<String, Long> objects) throws GraphException {
        ArrayList<CI> returnValue = new ArrayList<CI>(objects.size());
        for (Map.Entry oneQueryClass : objects.asMap().entrySet()) {
            String className = (String)oneQueryClass.getKey();
            Collection ids = (Collection)oneQueryClass.getValue();
            Collection<CI> retrieved = this.findObjectDetails(className, ids).values();
            if (ids.size() != retrieved.size()) {
                throw new GraphException("cannot read all the specified objects of class " + className);
            }
            returnValue.addAll(retrieved);
        }
        return returnValue;
    }

    private String getLinkedClass(CP linkProperty) {
        for (Map.Entry<String, String> forwardLink : this.model.getLinkedTo(linkProperty.className)) {
            if (!linkProperty.propertyName.equals(forwardLink.getValue())) continue;
            return forwardLink.getKey();
        }
        return null;
    }

    private String getLinkerClass(CP linkProperty) {
        for (Map.Entry<String, String> backwardLink : this.model.getLinkedBy(linkProperty.className)) {
            if (!linkProperty.propertyName.equals(backwardLink.getValue())) continue;
            return backwardLink.getKey();
        }
        return null;
    }

    private List<Map.Entry<CI, CI>> getLinksToCache(CP linkProperty, String query, Collection<Long> ids) throws GraphException {
        String linkedClassName = this.getLinkedClass(linkProperty);
        boolean propertyIsAccessible = this.model.isPropertyAccessible(linkProperty.className, linkProperty.propertyName);
        HashMultimap linkerToLinked = HashMultimap.create();
        for (List idsBatch : Iterables.partition(ids, (int)256)) {
            for (Object[] result : this.session.createQuery(query).setParameterList("ids", (Collection)idsBatch).list()) {
                linkerToLinked.put((Object)((Long)result[0]), (Object)((Long)result[1]));
            }
        }
        ArrayList<Map.Entry<CI, CI>> linkerLinked = new ArrayList<Map.Entry<CI, CI>>();
        Map<Long, CI> linkersById = this.findObjectDetails(linkProperty.className, linkerToLinked.keySet());
        Map<Long, CI> linkedsById = this.findObjectDetails(linkedClassName, new HashSet<Long>(linkerToLinked.values()));
        for (Map.Entry linkerIdLinkedId : linkerToLinked.entries()) {
            CI linker = linkersById.get(linkerIdLinkedId.getKey());
            CI linked = linkedsById.get(linkerIdLinkedId.getValue());
            if (!this.planning.detailsNoted.containsKey(linker)) {
                log.warn("failed to query for " + linker);
                continue;
            }
            if (!this.planning.detailsNoted.containsKey(linked)) {
                log.warn("failed to query for " + linked);
                continue;
            }
            linkerLinked.add(new AbstractMap.SimpleImmutableEntry<CI, CI>(linker, linked));
            if (propertyIsAccessible) {
                this.planning.befores.put((Object)linked, (Object)linker);
                this.planning.afters.put((Object)linker, (Object)linked);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(linkProperty.toCPI(linker.id) + " links to " + linked);
        }
        return linkerLinked;
    }

    private void cache(Collection<CI> toCache) throws GraphException {
        String query;
        CP linkProperty;
        HashMultimap forwardLinksWanted = HashMultimap.create();
        HashMultimap backwardLinksWanted = HashMultimap.create();
        for (CI cI : toCache) {
            for (String inclusionCandidateSuperclassName : this.model.getSuperclassesOfReflexive(cI.className)) {
                for (Map.Entry<String, String> entry : this.model.getLinkedTo(inclusionCandidateSuperclassName)) {
                    CP linkProperty2 = new CP(inclusionCandidateSuperclassName, entry.getValue());
                    forwardLinksWanted.put((Object)linkProperty2, (Object)cI.id);
                }
                for (Map.Entry<String, String> entry : this.model.getLinkedBy(inclusionCandidateSuperclassName)) {
                    CP linkProperty2 = new CP(entry.getKey(), entry.getValue());
                    backwardLinksWanted.put((Object)linkProperty2, (Object)cI.id);
                }
            }
        }
        for (Map.Entry entry : forwardLinksWanted.asMap().entrySet()) {
            linkProperty = (CP)entry.getKey();
            query = "SELECT linker.id, linked.id FROM " + linkProperty.className + " AS linker JOIN linker." + linkProperty.propertyName + " AS linked WHERE linker.id IN (:ids)";
            for (Map.Entry<Object, Object> entry2 : this.getLinksToCache(linkProperty, query, (Collection)entry.getValue())) {
                this.planning.forwardLinksCached.put((Object)linkProperty.toCPI(((CI)entry2.getKey()).id), entry2.getValue());
            }
        }
        for (Map.Entry entry : backwardLinksWanted.asMap().entrySet()) {
            linkProperty = (CP)entry.getKey();
            query = "SELECT linker.id, linked.id FROM " + linkProperty.className + " AS linker JOIN linker." + linkProperty.propertyName + " AS linked WHERE linked.id IN (:ids)";
            for (Map.Entry<Object, Object> entry3 : this.getLinksToCache(linkProperty, query, (Collection)entry.getValue())) {
                this.planning.backwardLinksCached.put((Object)linkProperty.toCPI(((CI)entry3.getValue()).id), entry3.getKey());
            }
        }
        this.planning.cached.addAll(toCache);
        this.planning.toProcess.addAll(toCache);
    }

    private void orphanCheckNoLongerExcluded(CI object) {
        for (String superclassName : this.model.getSuperclassesOfReflexive(object.className)) {
            for (Map.Entry<String, String> forwardLink : this.model.getLinkedTo(superclassName)) {
                CPI linkSource = new CPI(superclassName, forwardLink.getValue(), object.id);
                for (CI linked : this.planning.forwardLinksCached.get((Object)linkSource)) {
                    if (!Boolean.FALSE.equals(this.planning.foundIfLast.get(linked))) continue;
                    this.planning.findIfLast.add(linked);
                    this.planning.foundIfLast.remove(linked);
                    this.planning.toProcess.add(linked);
                }
            }
            for (Map.Entry<String, String> backwardLink : this.model.getLinkedBy(superclassName)) {
                CPI linkTarget = new CPI(backwardLink.getKey(), backwardLink.getValue(), object.id);
                for (CI linker : this.planning.backwardLinksCached.get((Object)linkTarget)) {
                    if (!Boolean.FALSE.equals(this.planning.foundIfLast.get(linker))) continue;
                    this.planning.findIfLast.add(linker);
                    this.planning.foundIfLast.remove(linker);
                    this.planning.toProcess.add(linker);
                }
            }
        }
    }

    private GraphPolicy.Action getAction(CI object) {
        if (this.planning.included.contains(object)) {
            return GraphPolicy.Action.INCLUDE;
        }
        if (this.planning.deleted.contains(object)) {
            return GraphPolicy.Action.DELETE;
        }
        if (this.planning.outside.contains(object)) {
            return GraphPolicy.Action.OUTSIDE;
        }
        return GraphPolicy.Action.EXCLUDE;
    }

    private GraphPolicy.Orphan getOrphan(CI object) {
        if (this.planning.findIfLast.contains(object)) {
            return GraphPolicy.Orphan.RELEVANT;
        }
        Boolean isLast = this.planning.foundIfLast.get(object);
        if (isLast == null) {
            return GraphPolicy.Orphan.IRRELEVANT;
        }
        return isLast != false ? GraphPolicy.Orphan.IS_LAST : GraphPolicy.Orphan.IS_NOT_LAST;
    }

    private GraphPolicy.Details getDetails(Map<CI, GraphPolicy.Details> cache, CI object) throws GraphException {
        GraphPolicy.Details details = cache.get(object);
        if (details == null) {
            GraphPolicy.Orphan orphan;
            Details objectDetails = this.planning.detailsNoted.get(object);
            if (objectDetails == null) {
                throw new GraphException("cannot read " + object);
            }
            Experimenter owner = objectDetails.getOwner();
            ExperimenterGroup group = objectDetails.getGroup();
            Long ownerId = owner == null ? null : owner.getId();
            Long groupId = group == null ? null : group.getId();
            GraphPolicy.Action action = this.getAction(object);
            GraphPolicy.Orphan orphan2 = orphan = action == GraphPolicy.Action.EXCLUDE ? this.getOrphan(object) : GraphPolicy.Orphan.IRRELEVANT;
            details = this.isCheckUserPermissions ? new DetailsWithCI(object.toIObject(), ownerId, groupId, action, orphan, this.planning.mayUpdate.contains(object), this.planning.mayDelete.contains(object), this.planning.mayChmod.contains(object), this.planning.mayChgrp.contains(object), this.planning.mayChown.contains(object), this.planning.owns.contains(object), !this.planning.overrides.contains(object)) : new DetailsWithCI(object.toIObject(), ownerId, groupId, action, orphan, true, true, true, true, true, true, true);
            cache.put(object, details);
        }
        return details;
    }

    private void reviewObject(CI object, boolean isErrorRules) throws GraphException {
        GraphPolicy.Action chosenAction;
        HashMap<CI, GraphPolicy.Details> detailsCache = new HashMap<CI, GraphPolicy.Details>();
        GraphPolicy.Details objectDetails = this.getDetails(detailsCache, object);
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("reviewing ");
            sb.append(objectDetails);
            if (isErrorRules) {
                sb.append(" for error conditions");
            }
            log.debug(sb.toString());
        }
        HashMap<String, Set<GraphPolicy.Details>> linkedFromDetails = new HashMap<String, Set<GraphPolicy.Details>>();
        HashMap<String, Set<GraphPolicy.Details>> linkedToDetails = new HashMap<String, Set<GraphPolicy.Details>>();
        HashSet<String> notNullable = new HashSet<String>();
        for (String superclassName : this.model.getSuperclassesOfReflexive(object.className)) {
            CP linkProperty;
            for (Map.Entry<String, String> entry : this.model.getLinkedTo(superclassName)) {
                linkProperty = new CP(superclassName, entry.getValue());
                if (this.model.getPropertyKind(linkProperty.className, linkProperty.propertyName) == GraphPathBean.PropertyKind.REQUIRED) {
                    notNullable.add(linkProperty.toString());
                }
                HashSet<GraphPolicy.Details> linkedsDetails = new HashSet<GraphPolicy.Details>();
                linkedToDetails.put(linkProperty.toString(), linkedsDetails);
                CPI linkSource = linkProperty.toCPI(object.id);
                for (CI linked : this.planning.forwardLinksCached.get((Object)linkSource)) {
                    linkedsDetails.add(this.getDetails(detailsCache, linked));
                }
            }
            for (Map.Entry entry : this.model.getLinkedBy(superclassName)) {
                linkProperty = new CP((String)entry.getKey(), (String)entry.getValue());
                if (this.model.getPropertyKind(linkProperty.className, linkProperty.propertyName) == GraphPathBean.PropertyKind.REQUIRED) {
                    notNullable.add(linkProperty.toString());
                }
                HashSet<GraphPolicy.Details> linkersDetails = new HashSet<GraphPolicy.Details>();
                linkedFromDetails.put(linkProperty.toString(), linkersDetails);
                CPI linkTarget = linkProperty.toCPI(object.id);
                for (CI linker : this.planning.backwardLinksCached.get((Object)linkTarget)) {
                    linkersDetails.add(this.getDetails(detailsCache, linker));
                }
            }
        }
        Set<GraphPolicy.Details> changes = this.policy.review(linkedFromDetails, objectDetails, linkedToDetails, notNullable, isErrorRules);
        this.planning.toProcess.remove(object);
        if (changes == null) {
            return;
        }
        boolean anyChanges = false;
        for (GraphPolicy.Details details : changes) {
            boolean isChanged;
            CI instance;
            block32: {
                block31: {
                    instance = new CI(details.subject);
                    GraphPolicy.Action previousAction = this.getAction(instance);
                    isChanged = true;
                    if (previousAction == details.action) break block31;
                    switch (previousAction) {
                        case EXCLUDE: {
                            this.planning.findIfLast.remove(instance);
                            this.planning.foundIfLast.remove(instance);
                            this.orphanCheckNoLongerExcluded(instance);
                            break;
                        }
                        case DELETE: {
                            this.planning.deleted.remove(instance);
                            break;
                        }
                        default: {
                            throw new GraphException("policy cannot change action from " + (Object)((Object)previousAction));
                        }
                    }
                    switch (details.action) {
                        case DELETE: {
                            this.planning.deleted.add(instance);
                            this.planning.toProcess.add(instance);
                            break block32;
                        }
                        case INCLUDE: {
                            this.planning.included.add(instance);
                            this.planning.toProcess.add(instance);
                            break block32;
                        }
                        case OUTSIDE: {
                            this.planning.outside.add(instance);
                            this.planning.toProcess.remove(instance);
                            break block32;
                        }
                        default: {
                            throw new GraphException("policy cannot change action to " + (Object)((Object)details.action));
                        }
                    }
                }
                if (!(details.orphan != GraphPolicy.Orphan.IS_LAST && details.orphan != GraphPolicy.Orphan.IS_NOT_LAST || this.planning.foundIfLast.containsKey(instance))) {
                    this.planning.findIfLast.remove(instance);
                    this.planning.foundIfLast.put(instance, details.orphan == GraphPolicy.Orphan.IS_LAST);
                    this.planning.toProcess.add(instance);
                } else if (details.action == GraphPolicy.Action.EXCLUDE && details.orphan == GraphPolicy.Orphan.RELEVANT && this.planning.findIfLast.add(instance)) {
                    this.planning.toProcess.add(instance);
                } else if (instance.equals(object) || details.action == GraphPolicy.Action.OUTSIDE) {
                    isChanged = false;
                } else {
                    if (this.planning.unchanged.add(instance)) {
                        this.planning.toProcess.add(instance);
                    }
                    isChanged = false;
                }
            }
            boolean bl = anyChanges = anyChanges || isChanged;
            if (this.isCheckUserPermissions && !details.isCheckPermissions) {
                this.planning.overrides.add(instance);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("adjusted " + details);
        }
        if (anyChanges) {
            this.planning.toProcess.addAll(this.planning.unchanged);
            this.planning.unchanged.clear();
        }
        if (!((chosenAction = this.getAction(object)) != GraphPolicy.Action.DELETE && chosenAction != GraphPolicy.Action.INCLUDE || this.planning.blockedBy.containsKey(object))) {
            Set<CI> set = this.planning.blockedBy.keySet();
            this.planning.blockedBy.put(object, new HashSet(Sets.intersection((Set)this.planning.befores.get((Object)object), set)));
            for (CI afterItem : Sets.intersection((Set)this.planning.afters.get((Object)object), set)) {
                this.planning.blockedBy.get(afterItem).add(object);
            }
        }
    }

    private void orderFileDeletion() {
        String originalFileClassName = OriginalFile.class.getName();
        HashSet<Long> originalFileIds = new HashSet<Long>();
        for (CI object : this.planning.deleted) {
            if (!originalFileClassName.equals(object.className)) continue;
            originalFileIds.add(object.id);
        }
        HashMultimap directoryRepos = HashMultimap.create();
        String directoryRepoQuery = "SELECT id, repo FROM OriginalFile WHERE mimetype = 'Directory' AND repo IS NOT NULL AND id IN (:ids)";
        for (List originalFileIdsBatch : Iterables.partition(originalFileIds, (int)256)) {
            Query hibQuery = this.session.createQuery("SELECT id, repo FROM OriginalFile WHERE mimetype = 'Directory' AND repo IS NOT NULL AND id IN (:ids)");
            hibQuery.setParameterList("ids", (Collection)originalFileIdsBatch);
            List results = hibQuery.list();
            for (Object[] result : results) {
                Long id = (Long)result[0];
                String repo = (String)result[1];
                directoryRepos.put((Object)repo, (Object)id);
            }
        }
        String contentQuery = "SELECT id FROM OriginalFile WHERE repo = :repo AND path IN (SELECT path || name || '/' FROM OriginalFile WHERE id = :id)";
        for (Map.Entry repoAndDirectoryId : directoryRepos.entries()) {
            String repo = (String)repoAndDirectoryId.getKey();
            Long directoryId = (Long)repoAndDirectoryId.getValue();
            CI directory = new CI(originalFileClassName, directoryId);
            Query hibQuery = this.session.createQuery("SELECT id FROM OriginalFile WHERE repo = :repo AND path IN (SELECT path || name || '/' FROM OriginalFile WHERE id = :id)");
            hibQuery.setParameter("repo", (Object)repo);
            hibQuery.setParameter("id", (Object)directoryId);
            List contentIds = hibQuery.list();
            Iterator iterator = contentIds.iterator();
            while (iterator.hasNext()) {
                long contentId = (Long)iterator.next();
                if (!originalFileIds.contains(contentId)) continue;
                CI content = new CI(originalFileClassName, contentId);
                Set<CI> blockers = this.planning.blockedBy.get(directory);
                if (blockers == null) {
                    blockers = new HashSet<CI>();
                    this.planning.blockedBy.put(directory, blockers);
                }
                blockers.add(content);
                log.debug("before deleting {} must first delete {}", (Object)directory, (Object)content);
            }
        }
    }

    private void addRemoval(Map<CP, SetMultimap<Long, Map.Entry<String, Long>>> linkerToIdToLinked, CPI linker, CI linked) {
        if (this.model.isPropertyAccessible(linker.className, linker.propertyName)) {
            HashMultimap idMap = linkerToIdToLinked.get(linker.toCP());
            if (idMap == null) {
                idMap = HashMultimap.create();
                linkerToIdToLinked.put(linker.toCP(), (SetMultimap<Long, Map.Entry<String, Long>>)idMap);
            }
            idMap.put((Object)linker.id, new AbstractMap.SimpleImmutableEntry<String, Long>(linked.className, linked.id));
        }
    }

    private static Processor debugWrap(final Processor processor) {
        return new Processor(){

            @Override
            public void nullProperties(String className, String propertyName, Collection<Long> ids) {
                if (!(ids instanceof SortedSet)) {
                    ids = new TreeSet<Long>(ids);
                }
                if (log.isDebugEnabled()) {
                    log.debug("processor: null " + className + "[" + Joiner.on((char)',').join(ids) + "]." + propertyName);
                }
                processor.nullProperties(className, propertyName, ids);
            }

            @Override
            public void deleteInstances(String className, Collection<Long> ids) throws GraphException {
                if (!(ids instanceof SortedSet)) {
                    ids = new TreeSet<Long>(ids);
                }
                if (log.isDebugEnabled()) {
                    log.debug("processor: delete " + className + "[" + Joiner.on((char)',').join(ids) + "]");
                }
                processor.deleteInstances(className, ids);
            }

            @Override
            public void processInstances(String className, Collection<Long> ids) throws GraphException {
                if (!(ids instanceof SortedSet)) {
                    ids = new TreeSet<Long>(ids);
                }
                if (log.isDebugEnabled()) {
                    log.debug("processor: process " + className + "[" + Joiner.on((char)',').join(ids) + "]");
                }
                processor.processInstances(className, ids);
            }

            @Override
            public Set<GraphPolicy.Ability> getRequiredPermissions() {
                return processor.getRequiredPermissions();
            }

            @Override
            public void assertMayProcess(String className, long id, Details details) throws GraphException {
                processor.assertMayProcess(className, id, details);
            }
        };
    }

    private void assertMayBeProcessed(String className, Collection<Long> ids) throws GraphException {
        Set<CI> objects = GraphTraversal.idsToCIs(className, ids);
        this.assertPermissions(objects, this.processor.getRequiredPermissions());
        if (this.isCheckUserPermissions) {
            for (CI object : Sets.difference(objects, this.planning.overrides)) {
                try {
                    this.processor.assertMayProcess(object.className, object.id, this.planning.detailsNoted.get(object));
                }
                catch (GraphException e) {
                    throw new GraphException("cannot process " + object + ": " + e.message);
                }
            }
        }
    }

    private void assertMayBeDeleted(String className, Collection<Long> ids) throws GraphException {
        this.assertPermissions(GraphTraversal.idsToCIs(className, ids), Collections.singleton(GraphPolicy.Ability.DELETE));
    }

    private void assertMayBeUpdated(String className, Collection<Long> ids) throws GraphException {
        this.assertPermissions(GraphTraversal.idsToCIs(className, ids), Collections.singleton(GraphPolicy.Ability.UPDATE));
    }

    private void assertPermissions(Set<CI> objects, Collection<GraphPolicy.Ability> abilities) throws GraphException {
        Sets.SetView violations;
        if (abilities == null || !this.isCheckUserPermissions) {
            return;
        }
        objects = Sets.difference(objects, this.planning.overrides);
        if (abilities.contains((Object)GraphPolicy.Ability.DELETE) && !(violations = Sets.difference((Set)objects, this.planning.mayDelete)).isEmpty()) {
            throw new GraphException("not permitted to delete " + Joiner.on((String)", ").join((Iterable)violations));
        }
        if (abilities.contains((Object)GraphPolicy.Ability.UPDATE) && !(violations = Sets.difference((Set)objects, this.planning.mayUpdate)).isEmpty()) {
            throw new GraphException("not permitted to update " + Joiner.on((String)", ").join((Iterable)violations));
        }
        if (abilities.contains((Object)GraphPolicy.Ability.CHMOD) && !(violations = Sets.difference((Set)objects, this.planning.mayChmod)).isEmpty()) {
            throw new GraphException("not permitted to change permissions on " + Joiner.on((String)", ").join((Iterable)violations));
        }
        if (abilities.contains((Object)GraphPolicy.Ability.CHGRP) && !(violations = Sets.difference((Set)objects, this.planning.mayChgrp)).isEmpty()) {
            throw new GraphException("not permitted to move " + Joiner.on((String)", ").join((Iterable)violations));
        }
        if (abilities.contains((Object)GraphPolicy.Ability.CHOWN) && !(violations = Sets.difference((Set)objects, this.planning.mayChown)).isEmpty()) {
            throw new GraphException("not permitted to give " + Joiner.on((String)", ").join((Iterable)violations));
        }
        if (abilities.contains((Object)GraphPolicy.Ability.OWN) && !(violations = Sets.difference((Set)objects, this.planning.owns)).isEmpty()) {
            throw new GraphException("does not own " + Joiner.on((String)", ").join((Iterable)violations));
        }
    }

    private static Set<CI> idsToCIs(String className, Collection<Long> ids) {
        HashSet<CI> objects = new HashSet<CI>();
        for (Long id : ids) {
            objects.add(new CI(className, id));
        }
        return objects;
    }

    public void assertNoUnlinking() throws GraphException {
        if (!this.progress.contains((Object)Milestone.PLANNED)) {
            throw new IllegalStateException("operation not yet planned");
        }
        if (!this.planning.deleted.isEmpty()) {
            throw new GraphException("cannot bypass unlinking step if any model objects are to be deleted");
        }
        this.progress.add(Milestone.UNLINKED);
    }

    public PlanExecutor unlinkTargets(boolean isUnlinkIncludeFromExclude) throws GraphException {
        Collection allIds;
        CP linker;
        GraphPolicy.Action linkerAction;
        CPI linkTarget;
        boolean isCollection;
        CP linkProperty;
        if (!this.progress.contains((Object)Milestone.PLANNED)) {
            throw new IllegalStateException("operation not yet planned");
        }
        HashMultimap toNullByCP = HashMultimap.create();
        HashMap<CP, SetMultimap<Long, Map.Entry<String, Long>>> linkerToIdToLinked = new HashMap<CP, SetMultimap<Long, Map.Entry<String, Long>>>();
        for (CI object : this.planning.included) {
            for (String superclassName : this.model.getSuperclassesOfReflexive(object.className)) {
                for (Map.Entry<String, String> forwardLink : this.model.getLinkedTo(superclassName)) {
                    linkProperty = new CP(superclassName, forwardLink.getValue());
                    isCollection = this.model.getPropertyKind(linkProperty.className, linkProperty.propertyName) == GraphPathBean.PropertyKind.COLLECTION;
                    CPI linkSource = linkProperty.toCPI(object.id);
                    for (CI linked : this.planning.forwardLinksCached.get((Object)linkSource)) {
                        GraphPolicy.Action linkedAction = this.getAction(linked);
                        if (linkedAction != GraphPolicy.Action.DELETE && (!isUnlinkIncludeFromExclude || linkedAction != GraphPolicy.Action.EXCLUDE)) continue;
                        if (isCollection) {
                            this.addRemoval(linkerToIdToLinked, linkProperty.toCPI(object.id), linked);
                            continue;
                        }
                        toNullByCP.put((Object)linkProperty, (Object)object.id);
                    }
                }
                if (!isUnlinkIncludeFromExclude) continue;
                for (Map.Entry<String, String> backwardLink : this.model.getLinkedBy(superclassName)) {
                    linkProperty = new CP(backwardLink.getKey(), backwardLink.getValue());
                    isCollection = this.model.getPropertyKind(linkProperty.className, linkProperty.propertyName) == GraphPathBean.PropertyKind.COLLECTION;
                    linkTarget = linkProperty.toCPI(object.id);
                    for (CI linker2 : this.planning.backwardLinksCached.get((Object)linkTarget)) {
                        linkerAction = this.getAction(linker2);
                        if (linkerAction != GraphPolicy.Action.EXCLUDE) continue;
                        if (isCollection) {
                            this.addRemoval(linkerToIdToLinked, linkProperty.toCPI(linker2.id), object);
                            continue;
                        }
                        toNullByCP.put((Object)linkProperty, (Object)linker2.id);
                    }
                }
            }
        }
        for (CI object : this.planning.deleted) {
            for (String superclassName : this.model.getSuperclassesOfReflexive(object.className)) {
                for (Map.Entry<String, String> backwardLink : this.model.getLinkedBy(superclassName)) {
                    linkProperty = new CP(backwardLink.getKey(), backwardLink.getValue());
                    isCollection = this.model.getPropertyKind(linkProperty.className, linkProperty.propertyName) == GraphPathBean.PropertyKind.COLLECTION;
                    linkTarget = linkProperty.toCPI(object.id);
                    for (CI linker2 : this.planning.backwardLinksCached.get((Object)linkTarget)) {
                        linkerAction = this.getAction(linker2);
                        if (linkerAction == GraphPolicy.Action.DELETE) continue;
                        if (isCollection) {
                            this.addRemoval(linkerToIdToLinked, linkProperty.toCPI(linker2.id), object);
                            continue;
                        }
                        toNullByCP.put((Object)linkProperty, (Object)linker2.id);
                    }
                }
            }
        }
        final Map eachToNullByCP = toNullByCP.asMap();
        for (Map.Entry nullCurr : eachToNullByCP.entrySet()) {
            linker = (CP)nullCurr.getKey();
            if (this.unnullable.get((Object)linker.className).contains(linker.propertyName) || this.model.getPropertyKind(linker.className, linker.propertyName) == GraphPathBean.PropertyKind.REQUIRED) {
                throw new GraphException("cannot null " + linker);
            }
            allIds = (Collection)nullCurr.getValue();
            this.assertMayBeUpdated(linker.className, allIds);
        }
        Iterator iterator = linkerToIdToLinked.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry removeCurr = iterator.next();
            linker = (CP)removeCurr.getKey();
            allIds = ((SetMultimap)removeCurr.getValue()).keySet();
            this.assertMayBeUpdated(linker.className, allIds);
            throw new GraphException("cannot remove elements from collection " + linker);
        }
        return new PlanExecutor(){

            @Override
            public void execute() throws GraphException {
                if (GraphTraversal.this.progress.contains((Object)Milestone.UNLINKED)) {
                    throw new IllegalStateException("model objects already unlinked");
                }
                for (Map.Entry nullCurr : eachToNullByCP.entrySet()) {
                    CP linker = (CP)nullCurr.getKey();
                    Collection allIds = (Collection)nullCurr.getValue();
                    for (List ids : Iterables.partition((Iterable)allIds, (int)256)) {
                        GraphTraversal.this.processor.nullProperties(linker.className, linker.propertyName, ids);
                    }
                }
                GraphTraversal.this.progress.add(Milestone.UNLINKED);
            }
        };
    }

    public PlanExecutor processTargets() throws GraphException {
        if (!this.progress.contains((Object)Milestone.PLANNED)) {
            throw new IllegalStateException("operation not yet planned");
        }
        final ArrayList<AbstractMap.SimpleImmutableEntry<Map, Map>> toJoinAndDelete = new ArrayList<AbstractMap.SimpleImmutableEntry<Map, Map>>();
        while (!this.planning.blockedBy.isEmpty()) {
            HashSet<CI> nowUnblocked = new HashSet<CI>();
            Iterator<Map.Entry<CI, Set<CI>>> blocks = this.planning.blockedBy.entrySet().iterator();
            while (blocks.hasNext()) {
                Map.Entry<CI, Set<CI>> block = blocks.next();
                CI cI = block.getKey();
                if (!block.getValue().isEmpty()) continue;
                blocks.remove();
                nowUnblocked.add(cI);
            }
            if (nowUnblocked.isEmpty()) {
                throw new GraphException("cycle detected among " + Joiner.on((String)", ").join(this.planning.blockedBy.keySet()));
            }
            for (Set set : this.planning.blockedBy.values()) {
                set.removeAll(nowUnblocked);
            }
            HashMultimap toJoin = HashMultimap.create();
            HashMultimap hashMultimap = HashMultimap.create();
            for (CI cI : nowUnblocked) {
                if (this.planning.included.contains(cI)) {
                    toJoin.put((Object)cI.className, (Object)cI.id);
                    continue;
                }
                hashMultimap.put((Object)cI.className, (Object)cI.id);
            }
            Map eachToJoin = toJoin.asMap();
            for (Map.Entry oneClassToJoin : eachToJoin.entrySet()) {
                String className = (String)oneClassToJoin.getKey();
                Collection allIds = (Collection)oneClassToJoin.getValue();
                this.assertMayBeProcessed(className, allIds);
            }
            Map map = hashMultimap.asMap();
            for (Map.Entry oneClassToDelete : map.entrySet()) {
                String className = (String)oneClassToDelete.getKey();
                Collection allIds = (Collection)oneClassToDelete.getValue();
                this.assertMayBeDeleted(className, allIds);
            }
            toJoinAndDelete.add(new AbstractMap.SimpleImmutableEntry<Map, Map>(eachToJoin, map));
        }
        return new PlanExecutor(){

            @Override
            public void execute() throws GraphException {
                if (!GraphTraversal.this.progress.contains((Object)Milestone.UNLINKED)) {
                    throw new IllegalStateException("model objects not yet unlinked");
                }
                if (GraphTraversal.this.progress.contains((Object)Milestone.PROCESSED)) {
                    throw new IllegalStateException("model objects already processed");
                }
                for (Map.Entry next : toJoinAndDelete) {
                    Collection allIds;
                    String className;
                    Map toJoin = (Map)next.getKey();
                    Map toDelete = (Map)next.getValue();
                    if (!toDelete.isEmpty()) {
                        for (Map.Entry oneClassToDelete : toDelete.entrySet()) {
                            className = (String)oneClassToDelete.getKey();
                            allIds = (Collection)oneClassToDelete.getValue();
                            for (List ids : Iterables.partition((Iterable)allIds, (int)256)) {
                                GraphTraversal.this.processor.deleteInstances(className, ids);
                            }
                        }
                    }
                    if (toJoin.isEmpty()) continue;
                    for (Map.Entry oneClassToJoin : toJoin.entrySet()) {
                        className = (String)oneClassToJoin.getKey();
                        allIds = (Collection)oneClassToJoin.getValue();
                        for (List ids : Iterables.partition((Iterable)allIds, (int)256)) {
                            GraphTraversal.this.processor.processInstances(className, ids);
                        }
                    }
                }
                GraphTraversal.this.progress.add(Milestone.PROCESSED);
            }
        };
    }

    public SetMultimap<String, Long> getLinkeds(String propertyValueClass, String propertyName, Long id) {
        if (!this.progress.contains((Object)Milestone.PLANNED)) {
            throw new IllegalStateException("operation not yet planned");
        }
        HashMultimap linkeds = HashMultimap.create();
        for (CI linked : this.planning.forwardLinksCached.get((Object)new CPI(propertyValueClass, propertyName, id))) {
            linkeds.put((Object)linked.className, (Object)linked.id);
        }
        return linkeds;
    }

    public SetMultimap<String, Long> getLinkers(String propertyValueClass, String propertyName, Long id) {
        if (!this.progress.contains((Object)Milestone.PLANNED)) {
            throw new IllegalStateException("operation not yet planned");
        }
        HashMultimap linkers = HashMultimap.create();
        for (CI linker : this.planning.backwardLinksCached.get((Object)new CPI(propertyValueClass, propertyName, id))) {
            linkers.put((Object)linker.className, (Object)linker.id);
        }
        return linkers;
    }

    @Deprecated
    public void setOwnsAll() {
        this.isOwnsAll = true;
    }

    public static interface Processor {
        public void nullProperties(String var1, String var2, Collection<Long> var3);

        public void deleteInstances(String var1, Collection<Long> var2) throws GraphException;

        public void processInstances(String var1, Collection<Long> var2) throws GraphException;

        public Set<GraphPolicy.Ability> getRequiredPermissions();

        public void assertMayProcess(String var1, long var2, Details var4) throws GraphException;
    }

    public static interface PlanExecutor {
        public void execute() throws GraphException;
    }

    private static class Planning {
        final Set<CI> toProcess = new HashSet<CI>();
        final Set<CI> included = new HashSet<CI>();
        final Set<CI> deleted = new HashSet<CI>();
        final Set<CI> outside = new HashSet<CI>();
        final Set<CI> unchanged = new HashSet<CI>();
        final Set<CI> findIfLast = new HashSet<CI>();
        final Map<CI, Boolean> foundIfLast = new HashMap<CI, Boolean>();
        final Map<CI, CI> aliases = new HashMap<CI, CI>();
        final Set<CI> cached = new HashSet<CI>();
        final SetMultimap<CPI, CI> forwardLinksCached = HashMultimap.create();
        final SetMultimap<CPI, CI> backwardLinksCached = HashMultimap.create();
        final SetMultimap<CI, CI> befores = HashMultimap.create();
        final SetMultimap<CI, CI> afters = HashMultimap.create();
        final Map<CI, Set<CI>> blockedBy = new HashMap<CI, Set<CI>>();
        final Map<CI, Details> detailsNoted = new HashMap<CI, Details>();
        final Map<Long, ExperimenterGroup> fakeGroups = new HashMap<Long, ExperimenterGroup>();
        final Set<CI> mayUpdate = new HashSet<CI>();
        final Set<CI> mayDelete = new HashSet<CI>();
        final Set<CI> mayChmod = new HashSet<CI>();
        final Set<CI> mayChgrp = new HashSet<CI>();
        final Set<CI> mayChown = new HashSet<CI>();
        final Set<CI> owns = new HashSet<CI>();
        final Set<CI> overrides = new HashSet<CI>();

        private Planning() {
        }
    }

    private static enum Milestone {
        PLANNED,
        UNLINKED,
        PROCESSED;

    }

    private static final class CPI {
        final String className;
        final String propertyName;
        final long id;
        private CP asCP;

        CPI(String className, String propertyName, long id) {
            this.className = className;
            this.propertyName = propertyName;
            this.id = id;
        }

        CP toCP() {
            if (this.asCP == null) {
                this.asCP = new CP(this.className, this.propertyName);
            }
            return this.asCP;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CPI) {
                CPI other = (CPI)object;
                return this.id == other.id && this.className.equals(other.className) && this.propertyName.equals(other.propertyName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getClass(), this.className, this.propertyName, this.id});
        }

        public String toString() {
            return this.className + "[" + this.id + "]." + this.propertyName;
        }
    }

    private static final class CP {
        final String className;
        final String propertyName;

        CP(String className, String propertyName) {
            this.className = className;
            this.propertyName = propertyName;
        }

        CPI toCPI(long id) {
            return new CPI(this.className, this.propertyName, id);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CP) {
                CP other = (CP)object;
                return this.className.equals(other.className) && this.propertyName.equals(other.propertyName);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getClass(), this.className, this.propertyName});
        }

        public String toString() {
            return (this.className + "." + this.propertyName).intern();
        }
    }

    private static final class CI {
        final String className;
        final long id;

        CI(String className, long id) {
            this.className = className;
            this.id = id;
        }

        CI(IObject object) {
            this.className = object instanceof HibernateProxy ? Hibernate.getClass((Object)object).getName() : object.getClass().getName();
            this.id = object.getId();
        }

        IObject toIObject() throws GraphException {
            try {
                Class<?> actualClass = Class.forName(this.className);
                return (IObject)actualClass.getConstructor(Long.class, Boolean.TYPE).newInstance(this.id, true);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                throw new GraphException("no invocable constructor for: new " + this.className + "(Long.valueOf(" + this.id + "L), false)");
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CI) {
                CI other = (CI)object;
                return this.id == other.id && this.className.equals(other.className);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getClass(), this.className, this.id});
        }

        public String toString() {
            return this.className + "[" + this.id + "]";
        }
    }

    private static final class DetailsWithCI
    extends GraphPolicy.Details {
        private final CI subjectAsCI;

        DetailsWithCI(IObject subject, Long ownerId, Long groupId, GraphPolicy.Action action, GraphPolicy.Orphan orphan, boolean mayUpdate, boolean mayDelete, boolean mayChmod, boolean mayChgrp, boolean mayChown, boolean isOwner, boolean isCheckPermissions) {
            super(subject, ownerId, groupId, action, orphan, mayUpdate, mayDelete, mayChmod, mayChgrp, mayChown, isOwner, isCheckPermissions);
            this.subjectAsCI = new CI(subject);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof DetailsWithCI) {
                DetailsWithCI other = (DetailsWithCI)object;
                return this.subjectAsCI.equals(other.subjectAsCI);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getClass(), this.subjectAsCI});
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.subjectAsCI);
            sb.append('/');
            sb.append(this.action == GraphPolicy.Action.EXCLUDE ? this.orphan : this.action);
            if (!this.isCheckPermissions) {
                sb.append('*');
            }
            return sb.toString();
        }
    }
}

