/*
 * Decompiled with CFR 0.152.
 */
package ome.services.graphs;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ome.model.IObject;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphPolicyRulePredicate;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphPolicyRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphPolicyRule.class);
    private static final Pattern NEW_TERM_PATTERN = Pattern.compile("(\\w+\\:)?(\\!?[\\w]+)?(\\[\\!?[EDIO]+\\])?(\\{\\!?[iroa]+\\})?(\\/\\!?[udomgn]+)?(\\;\\S+)?");
    private static final Pattern PREDICATE_PATTERN = Pattern.compile("\\;(\\w+)\\=([^\\;]+)(\\;\\S+)?");
    private static final Pattern EXISTING_TERM_PATTERN = Pattern.compile("(\\w+)");
    private static final Pattern CHANGE_PATTERN = Pattern.compile("(\\w+\\:)(\\[[EDIO\\-]\\])?(\\{[iroa]\\})?(\\/n)?");
    private List<String> matches = Collections.emptyList();
    private List<String> changes = Collections.emptyList();
    private String errorMessage = null;

    public void setMatches(String matches) {
        this.matches = ImmutableList.copyOf((Object[])matches.split(",\\s*"));
    }

    public void setChanges(String changes) {
        this.changes = ImmutableList.copyOf((Object[])changes.split(",\\s*"));
    }

    public void setError(String message) {
        this.errorMessage = message;
    }

    public String toString() {
        String trigger = Joiner.on((String)", ").join(this.matches);
        String consequence = this.errorMessage == null ? "to " + Joiner.on((String)", ").join(this.changes) : "is error: " + this.errorMessage;
        return trigger + ' ' + consequence;
    }

    private static TermMatch parseTermMatch(GraphPathBean graphPathBean, String term) throws GraphException {
        HashMap<String, String> predicateArguments;
        EnumSet<GraphPolicy.Ability> prohibitedAbilities;
        EnumSet<GraphPolicy.Ability> requiredAbilities;
        EnumSet<GraphPolicy.Orphan> permittedOrphans;
        EnumSet<GraphPolicy.Action> permittedActions;
        Class<? extends IObject> prohibitedClass;
        Class<? extends IObject> requiredClass;
        String termName;
        String termName2;
        Matcher existingTermMatcher = EXISTING_TERM_PATTERN.matcher(term);
        if (existingTermMatcher.matches() && graphPathBean.getClassForSimpleName(termName2 = existingTermMatcher.group(1)) == null) {
            return new ExistingTermMatch(termName2);
        }
        Matcher newTermMatcher = NEW_TERM_PATTERN.matcher(term);
        if (!newTermMatcher.matches()) {
            throw new GraphException("failed to parse match term " + term);
        }
        Boolean isCheckPermissions = null;
        String termNameGroup = newTermMatcher.group(1);
        if (termNameGroup == null) {
            termName = null;
        } else {
            termName = termNameGroup.substring(0, termNameGroup.length() - 1);
            if (graphPathBean.getClassForSimpleName(termName) != null) {
                throw new GraphException("redefined known class " + termName + " in " + term);
            }
        }
        String classNameGroup = newTermMatcher.group(2);
        if (classNameGroup == null) {
            requiredClass = null;
            prohibitedClass = null;
        } else if (classNameGroup.charAt(0) == '!') {
            requiredClass = null;
            prohibitedClass = graphPathBean.getClassForSimpleName(classNameGroup.substring(1));
            if (prohibitedClass == null) {
                throw new GraphException("unknown class named in " + term);
            }
        } else {
            requiredClass = graphPathBean.getClassForSimpleName(classNameGroup);
            prohibitedClass = null;
            if (requiredClass == null) {
                throw new GraphException("unknown class named in " + term);
            }
        }
        String actionGroup = newTermMatcher.group(3);
        if (actionGroup == null) {
            permittedActions = null;
        } else {
            EnumSet<GraphPolicy.Action> actions = EnumSet.noneOf(GraphPolicy.Action.class);
            boolean invert = false;
            for (char action : actionGroup.toCharArray()) {
                if (action == 'E') {
                    actions.add(GraphPolicy.Action.EXCLUDE);
                    continue;
                }
                if (action == 'D') {
                    actions.add(GraphPolicy.Action.DELETE);
                    continue;
                }
                if (action == 'I') {
                    actions.add(GraphPolicy.Action.INCLUDE);
                    continue;
                }
                if (action == 'O') {
                    actions.add(GraphPolicy.Action.OUTSIDE);
                    continue;
                }
                if (action != '!') continue;
                invert = true;
            }
            permittedActions = invert ? EnumSet.complementOf(actions) : actions;
        }
        String orphanGroup = newTermMatcher.group(4);
        if (orphanGroup == null) {
            permittedOrphans = null;
        } else {
            EnumSet<GraphPolicy.Orphan> orphans = EnumSet.noneOf(GraphPolicy.Orphan.class);
            boolean invert = false;
            for (char orphan : orphanGroup.toCharArray()) {
                if (orphan == 'i') {
                    orphans.add(GraphPolicy.Orphan.IRRELEVANT);
                    continue;
                }
                if (orphan == 'r') {
                    orphans.add(GraphPolicy.Orphan.RELEVANT);
                    continue;
                }
                if (orphan == 'o') {
                    orphans.add(GraphPolicy.Orphan.IS_LAST);
                    continue;
                }
                if (orphan == 'a') {
                    orphans.add(GraphPolicy.Orphan.IS_NOT_LAST);
                    continue;
                }
                if (orphan != '!') continue;
                invert = true;
            }
            permittedOrphans = invert ? EnumSet.complementOf(orphans) : orphans;
        }
        String abilityGroup = newTermMatcher.group(5);
        if (abilityGroup == null) {
            requiredAbilities = null;
            prohibitedAbilities = null;
        } else {
            EnumSet<GraphPolicy.Ability> abilities = EnumSet.noneOf(GraphPolicy.Ability.class);
            boolean required = true;
            for (char ability : abilityGroup.toCharArray()) {
                if (ability == 'u') {
                    abilities.add(GraphPolicy.Ability.UPDATE);
                    continue;
                }
                if (ability == 'd') {
                    abilities.add(GraphPolicy.Ability.DELETE);
                    continue;
                }
                if (ability == 'o') {
                    abilities.add(GraphPolicy.Ability.OWN);
                    continue;
                }
                if (ability == 'm') {
                    abilities.add(GraphPolicy.Ability.CHGRP);
                    continue;
                }
                if (ability == 'g') {
                    abilities.add(GraphPolicy.Ability.CHOWN);
                    continue;
                }
                if (ability == 'n') {
                    isCheckPermissions = !required;
                    continue;
                }
                if (ability != '!') continue;
                required = false;
            }
            if (required) {
                requiredAbilities = abilities;
                prohibitedAbilities = null;
            } else {
                requiredAbilities = null;
                prohibitedAbilities = abilities;
            }
        }
        if (newTermMatcher.group(6) == null) {
            predicateArguments = null;
        } else {
            predicateArguments = new HashMap<String, String>();
            String remainingPredicates = newTermMatcher.group(6);
            while (remainingPredicates != null) {
                Matcher predicateMatcher = PREDICATE_PATTERN.matcher(remainingPredicates);
                if (!predicateMatcher.matches()) {
                    throw new GraphException("failed to parse predicates suffixing match term " + term);
                }
                predicateArguments.put(predicateMatcher.group(1), predicateMatcher.group(2));
                remainingPredicates = predicateMatcher.group(3);
            }
        }
        return new NewTermMatch(termName, requiredClass, prohibitedClass, permittedActions, permittedOrphans, requiredAbilities, prohibitedAbilities, isCheckPermissions, predicateArguments);
    }

    private static RelationshipMatch parseRelationshipMatch(GraphPathBean graphPathBean, String leftTerm, String equals, String rightTerm) throws GraphException {
        String propertyName;
        int periodIndex;
        Boolean notNullable;
        Boolean sameOwner;
        int slash = equals.indexOf(47);
        if (slash < 0) {
            sameOwner = null;
        } else {
            sameOwner = equals.endsWith("/o");
            equals = equals.substring(0, slash);
        }
        if ("=".equals(equals)) {
            notNullable = null;
        } else if ("==".equals(equals)) {
            notNullable = Boolean.TRUE;
        } else if ("=?".equals(equals)) {
            notNullable = Boolean.FALSE;
        } else {
            throw new GraphException(Joiner.on((char)' ').join((Object)"failed to parse match", (Object)leftTerm, new Object[]{equals, rightTerm}));
        }
        if (rightTerm.indexOf(46) > 0) {
            String forSwap = rightTerm;
            rightTerm = leftTerm;
            leftTerm = forSwap;
        }
        if ((periodIndex = leftTerm.indexOf(46)) > 0) {
            propertyName = leftTerm.substring(periodIndex + 1);
            leftTerm = leftTerm.substring(0, periodIndex);
        } else {
            propertyName = null;
        }
        TermMatch leftTermMatch = GraphPolicyRule.parseTermMatch(graphPathBean, leftTerm);
        TermMatch rightTermMatch = GraphPolicyRule.parseTermMatch(graphPathBean, rightTerm);
        return new RelationshipMatch(leftTermMatch, rightTermMatch, propertyName, notNullable, sameOwner);
    }

    private static Change parseChange(String change) throws GraphException {
        boolean isOverridePermissions;
        GraphPolicy.Orphan orphan;
        GraphPolicy.Action action;
        Matcher matcher = CHANGE_PATTERN.matcher(change);
        if (!matcher.matches()) {
            throw new GraphException("failed to parse change " + change);
        }
        String termNameGroup = matcher.group(1);
        String termName = termNameGroup.substring(0, termNameGroup.length() - 1);
        if (matcher.group(2) == null) {
            action = null;
        } else {
            switch (matcher.group(2).charAt(1)) {
                case 'E': {
                    action = GraphPolicy.Action.EXCLUDE;
                    break;
                }
                case 'D': {
                    action = GraphPolicy.Action.DELETE;
                    break;
                }
                case 'I': {
                    action = GraphPolicy.Action.INCLUDE;
                    break;
                }
                case 'O': {
                    action = GraphPolicy.Action.OUTSIDE;
                    break;
                }
                default: {
                    action = null;
                }
            }
        }
        if (matcher.group(3) == null) {
            orphan = null;
        } else {
            switch (matcher.group(3).charAt(1)) {
                case 'i': {
                    orphan = GraphPolicy.Orphan.IRRELEVANT;
                    break;
                }
                case 'r': {
                    orphan = GraphPolicy.Orphan.RELEVANT;
                    break;
                }
                case 'o': {
                    orphan = GraphPolicy.Orphan.IS_LAST;
                    break;
                }
                case 'a': {
                    orphan = GraphPolicy.Orphan.IS_NOT_LAST;
                    break;
                }
                default: {
                    orphan = null;
                }
            }
        }
        if (matcher.group(4) == null) {
            isOverridePermissions = false;
        } else {
            switch (matcher.group(4).charAt(1)) {
                case 'n': {
                    isOverridePermissions = true;
                    break;
                }
                default: {
                    isOverridePermissions = false;
                }
            }
        }
        return new Change(termName, action, orphan, isOverridePermissions);
    }

    public static GraphPolicy parseRules(GraphPathBean graphPathBean, Collection<GraphPolicyRule> rules) throws GraphException {
        ArrayList<ParsedPolicyRule> parsedPolicyRules = new ArrayList<ParsedPolicyRule>();
        for (GraphPolicyRule policyRule : rules) {
            Object termCount2;
            ArrayList<TermMatch> termMatches = new ArrayList<TermMatch>();
            ArrayList<RelationshipMatch> relationshipMatches = new ArrayList<RelationshipMatch>();
            ArrayList<ConditionMatch> conditionMatches = new ArrayList<ConditionMatch>();
            HashMultimap termsByName = HashMultimap.create();
            HashMultiset termCounts = HashMultiset.create();
            for (String string : policyRule.matches) {
                String[] words = string.trim().split("\\s+");
                if (words.length == 1) {
                    String word = words[0];
                    if (word.startsWith("$")) {
                        conditionMatches.add(new ConditionMatch(true, word.substring(1)));
                        continue;
                    }
                    if (word.startsWith("!$")) {
                        conditionMatches.add(new ConditionMatch(false, word.substring(2)));
                        continue;
                    }
                    TermMatch termMatch = GraphPolicyRule.parseTermMatch(graphPathBean, word);
                    termMatches.add(termMatch);
                    if (termMatch.getName() == null) continue;
                    termsByName.put((Object)termMatch.getName(), (Object)termMatch);
                    continue;
                }
                if (words.length == 3) {
                    String rightTermName;
                    RelationshipMatch relationshipMatch = GraphPolicyRule.parseRelationshipMatch(graphPathBean, words[0], words[1], words[2]);
                    relationshipMatches.add(relationshipMatch);
                    String leftTermName = relationshipMatch.leftTerm.getName();
                    if (leftTermName != null) {
                        termsByName.put((Object)leftTermName, (Object)relationshipMatch.leftTerm);
                        if (relationshipMatch.propertyName != null) {
                            termCounts.add((Object)leftTermName);
                        }
                    }
                    if ((rightTermName = relationshipMatch.rightTerm.getName()) == null) continue;
                    termsByName.put((Object)rightTermName, (Object)relationshipMatch.rightTerm);
                    if (relationshipMatch.propertyName == null) continue;
                    termCounts.add((Object)rightTermName);
                    continue;
                }
                throw new GraphException("failed to parse match " + string);
            }
            ImmutableSet.Builder commonTerms = ImmutableSet.builder();
            for (Object termCount2 : termCounts.entrySet()) {
                if (termCount2.getCount() <= 1) continue;
                commonTerms.add(termCount2.getElement());
            }
            HashMap<String, NewTermMatch> hashMap = new HashMap<String, NewTermMatch>();
            for (TermMatch term : termsByName.values()) {
                String termName;
                if (!(term instanceof NewTermMatch) || (termName = term.getName()) == null || hashMap.put(termName, (NewTermMatch)term) == null) continue;
                throw new GraphException("redefined term " + termName + " in rule " + policyRule);
            }
            termCount2 = termsByName.values().iterator();
            while (termCount2.hasNext()) {
                TermMatch term;
                term = (TermMatch)termCount2.next();
                if (!(term instanceof ExistingTermMatch)) continue;
                NewTermMatch fullTerm = (NewTermMatch)hashMap.get(term.getName());
                if (fullTerm == null) {
                    throw new GraphException("undefined term " + term.getName() + " in rule " + policyRule);
                }
                ((ExistingTermMatch)term).setReference(fullTerm);
            }
            if (policyRule.errorMessage == null) {
                ArrayList<Change> changes = new ArrayList<Change>();
                for (String change : policyRule.changes) {
                    changes.add(GraphPolicyRule.parseChange(change.trim()));
                }
                parsedPolicyRules.add(new ParsedPolicyRule(policyRule.toString(), termMatches, relationshipMatches, conditionMatches, (Set<String>)commonTerms.build(), changes));
                continue;
            }
            parsedPolicyRules.add(new ParsedPolicyRule(policyRule.toString(), termMatches, relationshipMatches, conditionMatches, (Set<String>)commonTerms.build(), policyRule.errorMessage));
        }
        return new CleanGraphPolicy(parsedPolicyRules);
    }

    private static class CleanGraphPolicy
    extends GraphPolicy {
        private final ImmutableList<ParsedPolicyRule> policyRulesChange;
        private final ImmutableList<ParsedPolicyRule> policyRulesError;
        private final Set<String> conditions = new HashSet<String>();

        CleanGraphPolicy(List<ParsedPolicyRule> policyRules) {
            ImmutableList.Builder policyRulesChangeBuilder = ImmutableList.builder();
            ImmutableList.Builder policyRulesErrorBuilder = ImmutableList.builder();
            for (ParsedPolicyRule policyRule : policyRules) {
                if (policyRule.errorMessage == null) {
                    policyRulesChangeBuilder.add((Object)policyRule);
                    continue;
                }
                policyRulesErrorBuilder.add((Object)policyRule);
            }
            this.policyRulesChange = policyRulesChangeBuilder.build();
            this.policyRulesError = policyRulesErrorBuilder.build();
        }

        private CleanGraphPolicy(ImmutableList<ParsedPolicyRule> policyRulesChange, ImmutableList<ParsedPolicyRule> policyRulesError) {
            this.policyRulesChange = policyRulesChange;
            this.policyRulesError = policyRulesError;
        }

        @Override
        public GraphPolicy getCleanInstance() {
            return new CleanGraphPolicy(this.policyRulesChange, this.policyRulesError);
        }

        @Override
        public void setCondition(String name) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("set graph policy condition: " + name);
            }
            this.conditions.add(name);
        }

        @Override
        public boolean isCondition(String name) {
            return this.conditions.contains(name);
        }

        @Override
        public Set<GraphPolicy.Details> review(Map<String, Set<GraphPolicy.Details>> linkedFrom, GraphPolicy.Details rootObject, Map<String, Set<GraphPolicy.Details>> linkedTo, Set<String> notNullable, boolean isErrorRules) throws GraphException {
            HashSet<GraphPolicy.Details> changedObjects = new HashSet<GraphPolicy.Details>();
            for (ParsedPolicyRule policyRule : isErrorRules ? this.policyRulesError : this.policyRulesChange) {
                boolean conditionsSatisfied = true;
                for (ConditionMatch matcher : policyRule.conditionMatchers) {
                    if (matcher.set == this.isCondition(matcher.name)) continue;
                    conditionsSatisfied = false;
                    break;
                }
                if (!conditionsSatisfied) continue;
                if (policyRule.termMatchers.size() + policyRule.relationshipMatchers.size() == 1) {
                    this.reviewWithSingleMatch(linkedFrom, rootObject, linkedTo, notNullable, policyRule, changedObjects);
                    continue;
                }
                this.reviewWithManyMatches(linkedFrom, rootObject, linkedTo, notNullable, policyRule, changedObjects);
            }
            return changedObjects;
        }

        private void reviewWithSingleMatch(Map<String, Set<GraphPolicy.Details>> linkedFrom, GraphPolicy.Details rootObject, Map<String, Set<GraphPolicy.Details>> linkedTo, Set<String> notNullable, ParsedPolicyRule policyRule, Set<GraphPolicy.Details> changedObjects) throws GraphException {
            TreeMap<String, GraphPolicy.Details> namedTerms = new TreeMap<String, GraphPolicy.Details>();
            MutableBoolean isCheckAllPermissions = new MutableBoolean(true);
            if (!policyRule.termMatchers.isEmpty()) {
                Set<GraphPolicy.Details> allTerms = GraphPolicy.allObjects(linkedFrom.values(), rootObject, linkedTo.values());
                for (TermMatch matcher : policyRule.termMatchers) {
                    for (GraphPolicy.Details object : allTerms) {
                        if (!matcher.isMatch(this.predicates, namedTerms, isCheckAllPermissions, object, true)) continue;
                        CleanGraphPolicy.recordChanges(policyRule, changedObjects, namedTerms, isCheckAllPermissions.booleanValue());
                        namedTerms.clear();
                        isCheckAllPermissions.setValue(true);
                    }
                }
            }
            for (RelationshipMatch matcher : policyRule.relationshipMatchers) {
                boolean isNotNullable;
                String classProperty;
                for (Map.Entry<String, Set<GraphPolicy.Details>> dataPerProperty : linkedFrom.entrySet()) {
                    classProperty = dataPerProperty.getKey();
                    isNotNullable = notNullable.contains(classProperty);
                    for (GraphPolicy.Details linkerObject : dataPerProperty.getValue()) {
                        if (!matcher.isMatch(this.predicates, namedTerms, isCheckAllPermissions, linkerObject, rootObject, classProperty, isNotNullable, true)) continue;
                        CleanGraphPolicy.recordChanges(policyRule, changedObjects, namedTerms, isCheckAllPermissions.booleanValue());
                        namedTerms.clear();
                        isCheckAllPermissions.setValue(true);
                    }
                }
                for (Map.Entry<String, Set<GraphPolicy.Details>> dataPerProperty : linkedTo.entrySet()) {
                    classProperty = dataPerProperty.getKey();
                    isNotNullable = notNullable.contains(classProperty);
                    for (GraphPolicy.Details linkedObject : dataPerProperty.getValue()) {
                        if (!matcher.isMatch(this.predicates, namedTerms, isCheckAllPermissions, rootObject, linkedObject, classProperty, isNotNullable, true)) continue;
                        CleanGraphPolicy.recordChanges(policyRule, changedObjects, namedTerms, isCheckAllPermissions.booleanValue());
                        namedTerms.clear();
                        isCheckAllPermissions.setValue(true);
                    }
                }
            }
        }

        private void reviewWithManyMatches(Map<String, Set<GraphPolicy.Details>> linkedFrom, GraphPolicy.Details rootObject, Map<String, Set<GraphPolicy.Details>> linkedTo, Set<String> notNullable, ParsedPolicyRule policyRule, Set<GraphPolicy.Details> changedObjects) throws GraphException {
            TreeMap<String, GraphPolicy.Details> namedTerms = new TreeMap<String, GraphPolicy.Details>();
            HashMultimap prohibitedTerms = HashMultimap.create();
            MutableBoolean isCheckAllPermissions = new MutableBoolean(true);
            HashSet<TermMatch> unmatchedTerms = new HashSet<TermMatch>(policyRule.termMatchers);
            Set<GraphPolicy.Details> allTerms = unmatchedTerms.isEmpty() ? Collections.emptySet() : GraphPolicy.allObjects(linkedFrom.values(), rootObject, linkedTo.values());
            HashSet<RelationshipMatch> unmatchedRelationships = new HashSet<RelationshipMatch>(policyRule.relationshipMatchers);
            boolean isPossibleMatch = true;
            while (true) {
                GraphPolicy.Details object;
                Object rightDetails;
                Iterator unmatchedRelationshipIterator;
                Object matcher;
                boolean isNotNullable;
                String classProperty;
                int namedTermCount = namedTerms.size();
                Iterator unmatchedTermIterator = unmatchedTerms.iterator();
                while (unmatchedTermIterator.hasNext()) {
                    Iterator<Map.Entry<String, Set<GraphPolicy.Details>>> matcher2 = (TermMatch)unmatchedTermIterator.next();
                    for (GraphPolicy.Details object2 : allTerms) {
                        if (matcher2.getName() != null && prohibitedTerms.get((Object)matcher2.getName()).contains(object2) || !matcher2.isMatch(this.predicates, namedTerms, isCheckAllPermissions, object2, true)) continue;
                        unmatchedTermIterator.remove();
                    }
                }
                for (Map.Entry<String, Set<GraphPolicy.Details>> dataPerProperty : linkedFrom.entrySet()) {
                    classProperty = (String)dataPerProperty.getKey();
                    isNotNullable = notNullable.contains(classProperty);
                    for (GraphPolicy.Details linkerObject : dataPerProperty.getValue()) {
                        unmatchedTermIterator = unmatchedTerms.iterator();
                        while (unmatchedTermIterator.hasNext()) {
                            matcher = (TermMatch)unmatchedTermIterator.next();
                            if (matcher.getName() != null && prohibitedTerms.get((Object)matcher.getName()).contains(linkerObject) || !matcher.isMatch(this.predicates, namedTerms, isCheckAllPermissions, linkerObject, true)) continue;
                            unmatchedTermIterator.remove();
                        }
                        unmatchedRelationshipIterator = unmatchedRelationships.iterator();
                        while (unmatchedRelationshipIterator.hasNext()) {
                            matcher = (RelationshipMatch)unmatchedRelationshipIterator.next();
                            String leftTermName = ((RelationshipMatch)matcher).leftTerm.getName();
                            if (leftTermName != null && prohibitedTerms.get((Object)leftTermName).contains(linkerObject) || !((RelationshipMatch)matcher).isMatch(this.predicates, namedTerms, isCheckAllPermissions, linkerObject, rootObject, classProperty, isNotNullable, isPossibleMatch)) continue;
                            unmatchedRelationshipIterator.remove();
                        }
                    }
                }
                for (Map.Entry<String, Set<GraphPolicy.Details>> dataPerProperty : linkedTo.entrySet()) {
                    classProperty = dataPerProperty.getKey();
                    isNotNullable = notNullable.contains(classProperty);
                    for (GraphPolicy.Details linkedObject : dataPerProperty.getValue()) {
                        unmatchedTermIterator = unmatchedTerms.iterator();
                        while (unmatchedTermIterator.hasNext()) {
                            matcher = (TermMatch)unmatchedTermIterator.next();
                            if (matcher.getName() != null && prohibitedTerms.get((Object)matcher.getName()).contains(linkedObject) || !matcher.isMatch(this.predicates, namedTerms, isCheckAllPermissions, linkedObject, true)) continue;
                            unmatchedTermIterator.remove();
                        }
                        unmatchedRelationshipIterator = unmatchedRelationships.iterator();
                        while (unmatchedRelationshipIterator.hasNext()) {
                            matcher = (RelationshipMatch)unmatchedRelationshipIterator.next();
                            String rightTermName = ((RelationshipMatch)matcher).rightTerm.getName();
                            if (rightTermName != null && prohibitedTerms.get((Object)rightTermName).contains(linkedObject) || !((RelationshipMatch)matcher).isMatch(this.predicates, namedTerms, isCheckAllPermissions, rootObject, linkedObject, classProperty, isNotNullable, isPossibleMatch)) continue;
                            unmatchedRelationshipIterator.remove();
                        }
                    }
                }
                unmatchedRelationshipIterator = unmatchedRelationships.iterator();
                while (unmatchedRelationshipIterator.hasNext()) {
                    GraphPolicy.Details leftDetails;
                    RelationshipMatch matcher2 = (RelationshipMatch)unmatchedRelationshipIterator.next();
                    if (matcher2.propertyName != null || matcher2.notNullable != null || matcher2.leftTerm instanceof NewTermMatch || matcher2.rightTerm instanceof NewTermMatch || (leftDetails = (GraphPolicy.Details)namedTerms.get(matcher2.leftTerm.getName())) == null || prohibitedTerms.get((Object)matcher2.leftTerm.getName()).contains(leftDetails) || (rightDetails = (GraphPolicy.Details)namedTerms.get(matcher2.rightTerm.getName())) == null || prohibitedTerms.get((Object)matcher2.rightTerm.getName()).contains(rightDetails) || !matcher2.isMatch(this.predicates, namedTerms, isCheckAllPermissions, leftDetails, (GraphPolicy.Details)rightDetails, null, false, isPossibleMatch)) continue;
                    unmatchedRelationshipIterator.remove();
                }
                if (isPossibleMatch && unmatchedTerms.isEmpty() && unmatchedRelationships.isEmpty()) {
                    CleanGraphPolicy.recordChanges(policyRule, changedObjects, namedTerms, isCheckAllPermissions.booleanValue());
                    return;
                }
                if (namedTerms.size() != namedTermCount) continue;
                Sets.SetView namedCommonTerms = Sets.intersection(namedTerms.keySet(), policyRule.commonTerms);
                boolean isCommonConsistentWithUnmatched = true;
                rightDetails = unmatchedTerms.iterator();
                while (rightDetails.hasNext()) {
                    TermMatch matcher3 = (TermMatch)rightDetails.next();
                    String termName = matcher3.getName();
                    if (termName == null || !namedCommonTerms.contains(termName) || matcher3.isMatch(this.predicates, namedTerms, isCheckAllPermissions, object = (GraphPolicy.Details)namedTerms.get(termName), true)) continue;
                    isCommonConsistentWithUnmatched = false;
                    break;
                }
                if (isCommonConsistentWithUnmatched) {
                    rightDetails = unmatchedRelationships.iterator();
                    while (rightDetails.hasNext()) {
                        String rightTermName;
                        RelationshipMatch matcher4 = (RelationshipMatch)rightDetails.next();
                        String leftTermName = matcher4.leftTerm.getName();
                        if (leftTermName != null && namedCommonTerms.contains(leftTermName)) {
                            object = (GraphPolicy.Details)namedTerms.get(leftTermName);
                            if (!matcher4.leftTerm.isMatch(this.predicates, namedTerms, isCheckAllPermissions, object, true)) {
                                isCommonConsistentWithUnmatched = false;
                                break;
                            }
                        }
                        if ((rightTermName = matcher4.rightTerm.getName()) == null || !namedCommonTerms.contains(rightTermName)) continue;
                        GraphPolicy.Details object3 = (GraphPolicy.Details)namedTerms.get(rightTermName);
                        if (matcher4.rightTerm.isMatch(this.predicates, namedTerms, isCheckAllPermissions, object3, true)) continue;
                        isCommonConsistentWithUnmatched = false;
                        break;
                    }
                }
                boolean retry = false;
                if (isCommonConsistentWithUnmatched) {
                    for (String namedCommonTerm : namedCommonTerms) {
                        GraphPolicy.Details commonTermDetails = (GraphPolicy.Details)namedTerms.get(namedCommonTerm);
                        if (commonTermDetails.equals(rootObject)) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("matched " + Joiner.on((char)',').join(namedTerms.keySet()) + " so will review " + commonTermDetails + " for rule " + policyRule.asString);
                        }
                        changedObjects.add(commonTermDetails);
                        prohibitedTerms.put((Object)namedCommonTerm, (Object)commonTermDetails);
                        retry = true;
                    }
                }
                namedTerms.clear();
                isCheckAllPermissions.setValue(true);
                unmatchedTerms.addAll(policyRule.termMatchers);
                unmatchedRelationships.addAll(policyRule.relationshipMatchers);
                if (retry) {
                    isPossibleMatch = false;
                    continue;
                }
                if (!isPossibleMatch || policyRule.commonTerms.isEmpty()) break;
                isPossibleMatch = false;
            }
        }

        private static void recordChanges(ParsedPolicyRule policyRule, Set<GraphPolicy.Details> changedObjects, Map<String, GraphPolicy.Details> namedTerms, boolean isCheckAllPermissions) throws GraphException {
            StringBuffer logMessage;
            if (LOGGER != null && LOGGER.isDebugEnabled()) {
                logMessage = new StringBuffer();
                logMessage.append("matched ");
                logMessage.append(policyRule.asString);
                logMessage.append(", where ");
                for (Map.Entry<String, GraphPolicy.Details> namedTerm : namedTerms.entrySet()) {
                    logMessage.append(namedTerm.getKey());
                    logMessage.append(" is ");
                    logMessage.append(namedTerm.getValue());
                    logMessage.append(", ");
                }
            } else {
                logMessage = null;
            }
            if (policyRule.errorMessage != null) {
                String message = policyRule.errorMessage;
                for (Map.Entry entry : namedTerms.entrySet()) {
                    String termName = (String)entry.getKey();
                    IObject termMatch = ((GraphPolicy.Details)entry.getValue()).subject;
                    message = message.replace("{" + termName + "}", termMatch.getClass().getSimpleName() + '[' + termMatch.getId() + ']');
                }
                if (logMessage != null) {
                    logMessage.append("error thrown");
                    LOGGER.debug(logMessage.toString());
                }
                throw new GraphException(message);
            }
            HashMap<Change, GraphPolicy.Details> changedTerms = new HashMap<Change, GraphPolicy.Details>();
            for (Change change : policyRule.changes) {
                changedTerms.put(change, change.toChanged(namedTerms));
            }
            if (!isCheckAllPermissions) {
                for (Map.Entry entry : changedTerms.entrySet()) {
                    if (!((Change)entry.getKey()).isEffectiveChange()) continue;
                    ((GraphPolicy.Details)entry.getValue()).isCheckPermissions = false;
                }
            }
            if (logMessage != null) {
                logMessage.append("making ");
                logMessage.append(Joiner.on((String)", ").join(changedTerms.values()));
                LOGGER.debug(logMessage.toString());
            }
            changedObjects.addAll(changedTerms.values());
        }
    }

    private static class ParsedPolicyRule {
        final String asString;
        final List<TermMatch> termMatchers;
        final List<RelationshipMatch> relationshipMatchers;
        final List<ConditionMatch> conditionMatchers;
        final Set<String> commonTerms;
        final List<Change> changes;
        final String errorMessage;

        ParsedPolicyRule(String asString, List<TermMatch> termMatchers, List<RelationshipMatch> relationshipMatchers, List<ConditionMatch> conditionMatchers, Set<String> commonTerms, List<Change> changes) {
            this.asString = asString;
            this.termMatchers = termMatchers;
            this.relationshipMatchers = relationshipMatchers;
            this.conditionMatchers = conditionMatchers;
            this.commonTerms = commonTerms;
            this.changes = changes;
            this.errorMessage = null;
        }

        ParsedPolicyRule(String asString, List<TermMatch> termMatchers, List<RelationshipMatch> relationshipMatchers, List<ConditionMatch> conditionMatchers, Set<String> commonTerms, String errorMessage) {
            this.asString = asString;
            this.termMatchers = termMatchers;
            this.relationshipMatchers = relationshipMatchers;
            this.conditionMatchers = conditionMatchers;
            this.commonTerms = commonTerms;
            this.changes = Collections.emptyList();
            this.errorMessage = errorMessage;
        }
    }

    private static class Change {
        private final String namedTerm;
        private final GraphPolicy.Action action;
        private final GraphPolicy.Orphan orphan;
        private final boolean isOverridePermissions;

        Change(String namedTerm, GraphPolicy.Action action, GraphPolicy.Orphan orphan, boolean isOverridePermissions) {
            this.namedTerm = namedTerm;
            this.action = action;
            this.orphan = orphan;
            this.isOverridePermissions = isOverridePermissions;
        }

        GraphPolicy.Details toChanged(Map<String, GraphPolicy.Details> namedTerms) throws GraphException {
            GraphPolicy.Details details = namedTerms.get(this.namedTerm);
            if (details == null) {
                throw new GraphException("policy rule: reference to unknown term " + this.namedTerm);
            }
            if (this.action != null) {
                details.action = this.action;
            }
            if (this.orphan != null) {
                details.orphan = this.orphan;
            }
            if (this.isOverridePermissions) {
                details.isCheckPermissions = false;
            }
            return details;
        }

        boolean isEffectiveChange() {
            return this.action != null || this.orphan != null;
        }
    }

    private static class ConditionMatch {
        final boolean set;
        final String name;

        ConditionMatch(boolean set, String name) {
            this.set = set;
            this.name = name;
        }
    }

    private static class RelationshipMatch {
        private final TermMatch leftTerm;
        private final TermMatch rightTerm;
        private final String propertyName;
        private final Boolean notNullable;
        private final Boolean sameOwner;

        RelationshipMatch(TermMatch leftTerm, TermMatch rightTerm, String propertyName, Boolean notNullable, Boolean sameOwner) {
            this.leftTerm = leftTerm;
            this.rightTerm = rightTerm;
            this.propertyName = propertyName == null ? null : '.' + propertyName;
            this.notNullable = notNullable;
            this.sameOwner = sameOwner;
        }

        boolean isMatch(Map<String, GraphPolicyRulePredicate> predicates, Map<String, GraphPolicy.Details> namedTerms, MutableBoolean isCheckAllPermissions, GraphPolicy.Details leftDetails, GraphPolicy.Details rightDetails, String classProperty, boolean notNullable, boolean isRequireNew) throws GraphException {
            boolean isMatch;
            if (this.sameOwner != null && leftDetails.ownerId != null && rightDetails.ownerId != null && this.sameOwner.booleanValue() != leftDetails.ownerId.equals(rightDetails.ownerId) || this.notNullable != null && this.notNullable != notNullable || this.propertyName != null && !classProperty.endsWith(this.propertyName)) {
                return false;
            }
            HashMap<String, GraphPolicy.Details> newNamedTerms = new HashMap<String, GraphPolicy.Details>(namedTerms);
            MutableBoolean newIsCheckAllPermissions = new MutableBoolean(isCheckAllPermissions.booleanValue());
            boolean bl = isMatch = this.leftTerm.isMatch(predicates, newNamedTerms, newIsCheckAllPermissions, leftDetails, isRequireNew) && this.rightTerm.isMatch(predicates, newNamedTerms, newIsCheckAllPermissions, rightDetails, isRequireNew);
            if (isMatch) {
                namedTerms.putAll(newNamedTerms);
                isCheckAllPermissions.setValue(newIsCheckAllPermissions.booleanValue());
            }
            return isMatch;
        }
    }

    private static class NewTermMatch
    implements TermMatch {
        private static Set<GraphPolicy.Action> ONLY_EXCLUDE = Collections.singleton(GraphPolicy.Action.EXCLUDE);
        private static Set<GraphPolicy.Action> ALL_ACTIONS = EnumSet.allOf(GraphPolicy.Action.class);
        private static Set<GraphPolicy.Orphan> ALL_ORPHANS = EnumSet.allOf(GraphPolicy.Orphan.class);
        private final String termName;
        private final Class<? extends IObject> requiredClass;
        private final Class<? extends IObject> prohibitedClass;
        private final Collection<GraphPolicy.Action> permittedActions;
        private final Collection<GraphPolicy.Orphan> permittedOrphans;
        private final Set<GraphPolicy.Ability> requiredAbilities;
        private final Set<GraphPolicy.Ability> prohibitedAbilities;
        private final Boolean isCheckPermissions;
        private final Map<String, String> predicateArguments;

        NewTermMatch(String termName, Class<? extends IObject> requiredClass, Class<? extends IObject> prohibitedClass, Collection<GraphPolicy.Action> permittedActions, Collection<GraphPolicy.Orphan> permittedOrphans, Collection<GraphPolicy.Ability> requiredAbilities, Collection<GraphPolicy.Ability> prohibitedAbilities, Boolean isCheckPermissions, Map<String, String> predicateArguments) {
            this.termName = termName;
            this.requiredClass = requiredClass;
            this.prohibitedClass = prohibitedClass;
            if (permittedOrphans == null) {
                this.permittedActions = permittedActions == null ? ALL_ACTIONS : ImmutableSet.copyOf(permittedActions);
                this.permittedOrphans = ALL_ORPHANS;
            } else {
                this.permittedActions = ONLY_EXCLUDE;
                this.permittedOrphans = ImmutableSet.copyOf(permittedOrphans);
            }
            this.requiredAbilities = requiredAbilities == null ? ImmutableSet.of() : ImmutableSet.copyOf(requiredAbilities);
            this.prohibitedAbilities = prohibitedAbilities == null ? ImmutableSet.of() : ImmutableSet.copyOf(prohibitedAbilities);
            this.isCheckPermissions = isCheckPermissions;
            this.predicateArguments = predicateArguments;
        }

        @Override
        public String getName() {
            return this.termName;
        }

        @Override
        public boolean isMatch(Map<String, GraphPolicyRulePredicate> predicates, Map<String, GraphPolicy.Details> namedTerms, MutableBoolean isCheckAllPermissions, GraphPolicy.Details details, boolean isRequireNew) throws GraphException {
            Class<?> subjectClass = details.subject.getClass();
            boolean previousIsCheckAllPermissions = isCheckAllPermissions.booleanValue();
            if (previousIsCheckAllPermissions && !details.isCheckPermissions) {
                isCheckAllPermissions.setValue(false);
            }
            if (!(this.requiredClass != null && !this.requiredClass.isAssignableFrom(subjectClass) || this.prohibitedClass != null && this.prohibitedClass.isAssignableFrom(subjectClass) || !this.permittedActions.contains((Object)details.action) || details.action == GraphPolicy.Action.EXCLUDE && !this.permittedOrphans.contains((Object)details.orphan) || !Sets.difference(this.requiredAbilities, details.permissions).isEmpty() || !Sets.intersection(this.prohibitedAbilities, details.permissions).isEmpty() || this.isCheckPermissions != null && this.isCheckPermissions != details.isCheckPermissions)) {
                if (this.predicateArguments != null) {
                    for (Map.Entry<String, String> predicateArgument : this.predicateArguments.entrySet()) {
                        String predicateName = predicateArgument.getKey();
                        String predicateValue = predicateArgument.getValue();
                        GraphPolicyRulePredicate predicate = predicates.get(predicateName);
                        if (predicate == null) {
                            throw new GraphException("unknown predicate: " + predicateName);
                        }
                        if (predicate.isMatch(details, predicateValue)) continue;
                        return false;
                    }
                }
                if (this.termName == null) {
                    return true;
                }
                GraphPolicy.Details oldDetails = namedTerms.get(this.termName);
                if (oldDetails == null) {
                    namedTerms.put(this.termName, details);
                    return true;
                }
                if (oldDetails.equals(details)) {
                    return true;
                }
            }
            isCheckAllPermissions.setValue(previousIsCheckAllPermissions);
            return false;
        }
    }

    private static class ExistingTermMatch
    implements TermMatch {
        final String termName;
        NewTermMatch refersTo = null;

        ExistingTermMatch(String termName) {
            this.termName = termName;
        }

        void setReference(NewTermMatch reference) {
            if (this.refersTo != null) {
                throw new IllegalStateException("cannot reset reference");
            }
            if (reference == null) {
                throw new IllegalArgumentException("cannot set null reference");
            }
            if (!reference.termName.equals(this.termName)) {
                throw new IllegalStateException("term name mismatch");
            }
            this.refersTo = reference;
        }

        @Override
        public String getName() {
            return this.termName;
        }

        @Override
        public boolean isMatch(Map<String, GraphPolicyRulePredicate> predicates, Map<String, GraphPolicy.Details> namedTerms, MutableBoolean isCheckAllPermissions, GraphPolicy.Details details, boolean isRequireNew) throws GraphException {
            if (this.refersTo == null) {
                throw new IllegalStateException("unresolved reference");
            }
            if (isRequireNew) {
                return details.equals(namedTerms.get(this.termName));
            }
            return this.refersTo.isMatch(predicates, namedTerms, isCheckAllPermissions, details, isRequireNew);
        }
    }

    private static interface TermMatch {
        public String getName();

        public boolean isMatch(Map<String, GraphPolicyRulePredicate> var1, Map<String, GraphPolicy.Details> var2, MutableBoolean var3, GraphPolicy.Details var4, boolean var5) throws GraphException;
    }
}

