/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ome.model.meta.Node;
import ome.security.NodeProvider;
import ome.services.util.ReadOnlyStatus;
import ome.system.Principal;
import ome.system.ServiceFactory;
import ome.util.SqlAction;
import org.springframework.beans.factory.BeanCreationException;

public class NodeProviderWrapper<P extends NodeProvider & ReadOnlyStatus.IsAware>
implements NodeProvider {
    private final List<P> read;
    private final List<P> write;

    public NodeProviderWrapper(ReadOnlyStatus readOnly, List<P> providers) {
        this.read = providers;
        this.write = new ArrayList<P>(this.read.size());
        for (NodeProvider provider : this.read) {
            if (((ReadOnlyStatus.IsAware)((Object)provider)).isReadOnly(readOnly)) continue;
            this.write.add(provider);
        }
        if (this.write.isEmpty()) {
            throw new BeanCreationException("must be given a read-write node provider");
        }
    }

    @Override
    public Set<String> getManagerList(boolean onlyActive) {
        HashSet<String> rvs = new HashSet<String>();
        for (NodeProvider provider : this.read) {
            Set<String> rv = provider.getManagerList(onlyActive);
            if (rv == null) continue;
            rvs.addAll(rv);
        }
        return rvs;
    }

    @Override
    public long getManagerIdByUuid(String managerUuid, SqlAction sql) {
        for (NodeProvider provider : this.read) {
            long managerId = provider.getManagerIdByUuid(managerUuid, sql);
            if (managerId == 0L) continue;
            return managerId;
        }
        return 0L;
    }

    @Override
    public Node getManagerByUuid(String managerUuid, ServiceFactory sf) {
        for (NodeProvider provider : this.read) {
            Node manager = provider.getManagerByUuid(managerUuid, sf);
            if (manager == null) continue;
            return manager;
        }
        return null;
    }

    @Override
    public int closeSessionsForManager(String managerUuid) {
        int rv = 0;
        for (NodeProvider provider : this.write) {
            rv += provider.closeSessionsForManager(managerUuid);
        }
        return rv;
    }

    @Override
    public void setManagerDown(String managerUuid) {
        for (NodeProvider provider : this.write) {
            provider.setManagerDown(managerUuid);
        }
    }

    @Override
    public Node addManager(String managerUuid, String proxyString) {
        return ((NodeProvider)this.write.get(0)).addManager(managerUuid, proxyString);
    }

    @Override
    public Principal principal() {
        return ((NodeProvider)this.write.get(0)).principal();
    }
}

