/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import javax.naming.directory.SearchControls;
import ome.model.meta.Experimenter;
import ome.security.auth.AttributeSet;
import ome.security.auth.LdapConfig;
import ome.security.auth.OmeroModelContextMapper;
import org.springframework.ldap.core.DirContextAdapter;

public class PersonContextMapper
extends OmeroModelContextMapper {
    public PersonContextMapper(LdapConfig cfg, String base) {
        this(cfg, base, null);
    }

    public PersonContextMapper(LdapConfig cfg, String base, String attribute) {
        super(cfg, base, attribute);
    }

    public String get(String attribute, DirContextAdapter context) {
        String attributeName = this.cfg.getUserAttribute(attribute);
        if (attributeName != null) {
            return context.getStringAttribute(attributeName);
        }
        return null;
    }

    @Override
    public Object mapFromContext(Object obj) {
        DirContextAdapter ctx = (DirContextAdapter)obj;
        Experimenter person = new Experimenter();
        person.setOmeName(this.get("omeName", ctx));
        person.setFirstName(this.get("firstName", ctx));
        person.setMiddleName(this.get("middleName", ctx));
        person.setLastName(this.get("lastName", ctx));
        person.setInstitution(this.get("institution", ctx));
        person.setEmail(this.get("email", ctx));
        person.setLdap(Boolean.valueOf(true));
        person.putAt("LDAP_DN", (Object)ctx.getNameInNamespace());
        if (this.attribute != null) {
            person.putAt("LDAP_ATTR", (Object)ctx.getAttributeSortedStringSet(this.attribute));
        }
        person.putAt("LDAP_PROPS", (Object)new AttributeSet(ctx));
        return person;
    }

    public SearchControls getControls() {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        controls.setReturningObjFlag(true);
        if (this.attribute == null) {
            return controls;
        }
        String inst = this.cfg.getUserAttribute("institution");
        String email = this.cfg.getUserAttribute("email");
        String middleName = this.cfg.getUserAttribute("middleName");
        String[] attrs = new String[]{"dn", this.attribute, this.cfg.getUserAttribute("omeName"), this.cfg.getUserAttribute("firstName"), this.cfg.getUserAttribute("lastName"), inst == null ? "dn" : inst, email == null ? "dn" : email, middleName == null ? "dn" : middleName};
        controls.setReturningAttributes(attrs);
        return controls;
    }
}

