/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imagej.ImgPlusMetadata;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.LanczosInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, initializer="init", headless=true, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Stacks", mnemonic=116), @Menu(label="Reslice...", mnemonic=116)}, attrs={@Attr(name="no-legacy")})
public class ResliceImage<T extends RealType<T>>
extends ContextCommand {
    private static final String LANCZOS = "Lanczos";
    private static final String LINEAR = "Linear";
    private static final String NEAREST_NEIGHBOR = "Nearest Neighbor";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Origin", persist=false)
    private String originString;
    @Parameter(label="Spacings", persist=false)
    private String spacingsString;
    @Parameter(label="Interpolation", choices={"Linear", "Nearest Neighbor", "Lanczos"}, persist=false)
    private String method = "Linear";
    @Parameter(label="Use user units", persist=false)
    private boolean useUserUnits;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private StatusService statusService;
    private String err = null;
    private List<Long> origin = new ArrayList<Long>();
    private List<Double> spacings = new ArrayList<Double>();

    public void setDataset(Dataset ds) {
        this.dataset = ds;
        this.init();
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setOriginMin(int d) {
        this.origin.set(d, 0L);
        this.originString = this.originString();
    }

    public boolean originMin(int d) {
        return this.origin.get(d) == 0L;
    }

    public void setOriginMax(int d) {
        this.origin.set(d, this.dataset.dimension(d) - 1L);
        this.originString = this.originString();
    }

    public boolean originMax(int d) {
        return this.origin.get(d) != 0L;
    }

    public void setSpacing(int d, double spacing) {
        if (d < 0 || d >= this.spacings.size()) {
            throw new IllegalArgumentException("dimension " + d + " out of bounds (0," + (this.spacings.size() - 1) + ")");
        }
        this.spacings.set(d, spacing);
        this.spacingsString = this.spacingsString();
    }

    public double getSpacing(int d) {
        if (d < 0 || d >= this.spacings.size()) {
            throw new IllegalArgumentException("dimension " + d + " out of bounds (0," + (this.spacings.size() - 1) + ")");
        }
        return this.spacings.get(d);
    }

    public void setInterpolationMethod(String str) {
        if (str.equals(LINEAR)) {
            this.method = LINEAR;
        } else if (str.equals(NEAREST_NEIGHBOR)) {
            this.method = NEAREST_NEIGHBOR;
        } else if (str.equals(LANCZOS)) {
            this.method = LANCZOS;
        } else {
            throw new IllegalArgumentException("Unknown interpolation method: " + str);
        }
    }

    public String getInterpolationMethod() {
        return this.method;
    }

    public void setUseUserUnits(boolean val) {
        this.useUserUnits = val;
    }

    public boolean useUserUnits() {
        return this.useUserUnits;
    }

    public String getError() {
        return this.err;
    }

    public void run() {
        List<Long> orig = this.parseOrigin(this.dataset, this.originString);
        if (orig == null) {
            this.cancel(this.err);
            return;
        }
        List<Double> spaces = this.parseSpacings(this.dataset, this.spacingsString);
        if (spaces == null) {
            this.cancel(this.err);
            return;
        }
        if (this.useUserUnits) {
            this.toPixelUnits(this.dataset, spaces);
        }
        this.statusService.showStatus("Resampling data ...");
        this.resampleData(this.dataset, orig, spaces);
        this.statusService.showStatus("Done.");
    }

    protected void init() {
        this.origin.clear();
        this.spacings.clear();
        for (int i = 0; i < this.dataset.numDimensions(); ++i) {
            this.origin.add(0L);
            this.spacings.add(1.0);
        }
        this.originString = this.originString();
        this.spacingsString = this.spacingsString();
    }

    private List<Long> parseOrigin(Dataset ds, String spec) {
        int i;
        if (spec == null) {
            this.err = "Origin specification string is null.";
            return null;
        }
        String[] terms = spec.split(",");
        if (terms.length == 0) {
            this.err = "Origin specification string is empty.";
            return null;
        }
        ArrayList<Long> orig = new ArrayList<Long>();
        for (i = 0; i < ds.numDimensions(); ++i) {
            orig.add(0L);
        }
        for (i = 0; i < terms.length; ++i) {
            long value;
            int axisIndex;
            block10: {
                String term = terms[i].trim();
                String[] parts = term.split("=");
                if (parts.length != 2) {
                    this.err = "Err in origin specification string: each subentry must be a number and then an '=' sign, and then either 'min' or 'max'.";
                    return null;
                }
                try {
                    axisIndex = Integer.parseInt(parts[0].trim());
                    String val = parts[1].trim().toLowerCase();
                    if (val.equals("min")) {
                        value = 0L;
                        break block10;
                    }
                    if (val.equals("max")) {
                        value = ds.dimension(i) - 1L;
                        break block10;
                    }
                    this.err = "Err in origin specification: each origin spec must be [axis number]=min or [axis number]=max.";
                    return null;
                }
                catch (NumberFormatException e) {
                    this.err = "Err in origin specification string: each subentry must be a number and then an '=' sign, and then either 'min' or 'max'.";
                    return null;
                }
            }
            if (axisIndex < 0 || axisIndex >= ds.numDimensions()) {
                this.err = "An axis index is outside dimensionality of input dataset.";
                return null;
            }
            orig.set(axisIndex, value);
        }
        return orig;
    }

    private List<Double> parseSpacings(Dataset ds, String spec) {
        int i;
        if (spec == null) {
            this.err = "Spacings specification string is null.";
            return null;
        }
        String[] terms = spec.split(",");
        if (terms.length == 0) {
            this.err = "Spacings specification string is empty.";
            return null;
        }
        ArrayList<Double> spaces = new ArrayList<Double>();
        for (i = 0; i < ds.numDimensions(); ++i) {
            spaces.add(1.0);
        }
        for (i = 0; i < terms.length; ++i) {
            double space;
            int axisIndex;
            String term = terms[i].trim();
            String[] parts = term.split("=");
            if (parts.length != 2) {
                this.err = "Err in spacings specification string: each spacing must be two numbers separated by an '=' sign.";
                return null;
            }
            try {
                axisIndex = Integer.parseInt(parts[0].trim());
                space = Double.parseDouble(parts[1].trim());
            }
            catch (NumberFormatException e) {
                this.err = "Err in spacings specification string: each spacing must be two numbers separated by an '=' sign.";
                return null;
            }
            if (axisIndex < 0 || axisIndex >= ds.numDimensions()) {
                this.err = "An axis index is outside dimensionality of input dataset.";
                return null;
            }
            spaces.set(axisIndex, space);
        }
        return spaces;
    }

    private void resampleData(Dataset ds, List<Long> orig, List<Double> spaces) {
        long[] destDims = this.newSize(ds, spaces);
        ImgPlus<T> dest = this.newData(destDims, ds);
        ImgPlus src = ds.getImgPlus();
        RealType zero = (RealType)((RealType)src.firstElement()).createVariable();
        zero.setZero();
        InterpolatorFactory<T, RandomAccessible<T>> ifac = this.getInterpolator();
        RealRandomAccess inter = ifac.create((Object)Views.extend((RandomAccessibleInterval)src, (OutOfBoundsFactory)new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE)));
        Cursor c2 = Views.iterable(dest).localizingCursor();
        int numDims = ds.numDimensions();
        long[] start = new long[numDims];
        double[] space = new double[numDims];
        long[] maxes = new long[numDims];
        for (int i = 0; i < numDims; ++i) {
            start[i] = orig.get(i);
            space[i] = spaces.get(i);
            maxes[i] = dest.dimension(i) - 1L;
        }
        long[] p = new long[numDims];
        while (c2.hasNext()) {
            c2.fwd();
            c2.localize(p);
            for (int i = 0; i < p.length; ++i) {
                double pos = this.position(start[i], space[i], p[i], maxes[i]);
                inter.setPosition(pos, i);
            }
            ((RealType)c2.get()).set((Type)inter.get());
        }
        ds.setImgPlus(dest);
    }

    private String originString() {
        String str = "";
        for (int i = 0; i < this.origin.size(); ++i) {
            if (i != 0) {
                str = str + ", ";
            }
            str = str + i + "=" + (this.origin.get(i) == 0L ? "min" : "max");
        }
        return str;
    }

    private String spacingsString() {
        String str = "";
        for (int i = 0; i < this.spacings.size(); ++i) {
            if (i != 0) {
                str = str + ", ";
            }
            str = str + i + "=" + this.spacings.get(i);
        }
        return str;
    }

    private InterpolatorFactory<T, RandomAccessible<T>> getInterpolator() {
        if (this.method.equals(LINEAR)) {
            return new NLinearInterpolatorFactory();
        }
        if (this.method.equals(NEAREST_NEIGHBOR)) {
            return new NearestNeighborInterpolatorFactory();
        }
        if (this.method.equals(LANCZOS)) {
            return new LanczosInterpolatorFactory();
        }
        throw new IllegalArgumentException("unknown interpolation method: " + this.method);
    }

    private void toPixelUnits(Dataset ds, List<Double> spaces) {
        for (int i = 0; i < spaces.size(); ++i) {
            CalibratedAxis axis = (CalibratedAxis)ds.axis(i);
            double userUnit = spaces.get(i);
            double pixelUnit = axis.rawValue(userUnit) - axis.rawValue(0.0);
            spaces.set(i, pixelUnit);
        }
    }

    private double position(long org, double spacing, long pos, long max) {
        if (org == 0L) {
            return spacing * (double)pos;
        }
        return (double)org - spacing * (double)(max - pos);
    }

    private long[] newSize(Dataset ds, List<Double> spaces) {
        long[] newDims = new long[ds.numDimensions()];
        ds.dimensions(newDims);
        for (int i = 0; i < newDims.length; ++i) {
            newDims[i] = Math.round((double)newDims[i] / spaces.get(i));
            if (newDims[1] >= 1L) continue;
            newDims[i] = 1L;
        }
        return newDims;
    }

    private ImgPlus<T> newData(long[] newDims, Dataset base) {
        ImgPlus imgPlus = base.getImgPlus();
        RealType type = (RealType)imgPlus.firstElement();
        ImgFactory factory = imgPlus.factory();
        Img result = factory.create(newDims, (Object)type);
        return new ImgPlus(result, (ImgPlusMetadata)base);
    }
}

