/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.binary;

import net.imagej.Dataset;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.types.ConnectedType;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import org.scijava.ItemIO;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Parameter;

public abstract class AbstractMorphOpsCommand
extends ContextCommand {
    public static final String FOUR = "Four";
    public static final String EIGHT = "Eight";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Neighbors", choices={"Four", "Eight"})
    private String neighbors = "Four";
    protected static OutOfBoundsFactory<BitType, RandomAccessibleInterval<BitType>> defaultFactory = new OutOfBoundsConstantValueFactory((Type)new BitType(false));

    protected abstract void updateDataset(Dataset var1);

    public ConnectedType getConnectedType() {
        if (this.neighbors == FOUR) {
            return ConnectedType.FOUR_CONNECTED;
        }
        return ConnectedType.EIGHT_CONNECTED;
    }

    public void setConnectedType(ConnectedType type) {
        this.neighbors = type.equals((Object)ConnectedType.FOUR_CONNECTED) ? FOUR : EIGHT;
    }

    public void run() {
        if (!this.isBitType(this.dataset)) {
            this.cancel("This command requires input dataset to be of type BitType.");
        } else {
            this.updateDataset(this.dataset);
        }
    }

    private boolean isBitType(Dataset ds) {
        RealType type = (RealType)ds.getImgPlus().firstElement();
        return type instanceof BitType;
    }
}

