/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.array.blas.DOT;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;

public final class HouseholderLeft
extends MatrixOperation {
    public static final HouseholderLeft SETUP = new HouseholderLeft();
    public static int THRESHOLD = 128;

    public static void invoke(BigDecimal[] data, int structure, int first, int limit, Householder.Big householder) {
        BigDecimal[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        BigDecimal tmpBeta = householder.beta;
        for (int j = first; j < limit; ++j) {
            int i;
            BigDecimal tmpScale = BigMath.ZERO;
            int tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                tmpScale = BigFunction.ADD.invoke(tmpScale, BigFunction.MULTIPLY.invoke(tmpHouseholderVector[i], data[tmpIndex++]));
            }
            tmpScale = BigFunction.MULTIPLY.invoke(tmpScale, tmpBeta);
            tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                data[tmpIndex] = BigFunction.SUBTRACT.invoke(data[tmpIndex], BigFunction.MULTIPLY.invoke(tmpScale, tmpHouseholderVector[i]));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(ComplexNumber[] data, int structure, int first, int limit, Householder.Complex householder) {
        ComplexNumber[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        ComplexNumber tmpBeta = householder.beta;
        for (int j = first; j < limit; ++j) {
            int i;
            ComplexNumber tmpScale = ComplexNumber.ZERO;
            int tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                tmpScale = tmpScale.add(tmpHouseholderVector[i].conjugate().multiply(data[tmpIndex++]));
            }
            tmpScale = tmpScale.multiply(tmpBeta);
            tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                data[tmpIndex] = data[tmpIndex].subtract(tmpScale.multiply(tmpHouseholderVector[i]));
                ++tmpIndex;
            }
        }
    }

    public static void invoke(double[] data, int structure, int first, int limit, Householder.Primitive householder) {
        double[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        double tmpBeta = householder.beta;
        for (int j = first; j < limit; ++j) {
            double tmpScale = DOT.invoke(data, j * structure, tmpHouseholderVector, 0, tmpFirstNonZero, structure);
            AXPY.invoke(data, j * structure, -(tmpScale *= tmpBeta), tmpHouseholderVector, 0, tmpFirstNonZero, structure);
        }
    }

    public static <N extends Number> void invoke(N[] data, int structure, int first, int limit, Householder.Generic<N> householder, Scalar.Factory<N> scalar) {
        N[] tmpHouseholderVector = householder.vector;
        int tmpFirstNonZero = householder.first;
        Object tmpBeta = householder.beta;
        for (int j = first; j < limit; ++j) {
            int i;
            Scalar tmpScale = scalar.zero();
            int tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                tmpScale = tmpScale.add((Scalar)((Scalar)((VectorSpace)tmpHouseholderVector[i]).conjugate()).multiply(data[tmpIndex++]));
            }
            tmpScale = (Scalar)tmpScale.multiply(tmpBeta);
            tmpIndex = tmpFirstNonZero + j * structure;
            for (i = tmpFirstNonZero; i < structure; ++i) {
                data[tmpIndex] = ((Scalar)data[tmpIndex]).subtract((Scalar)tmpScale.multiply(tmpHouseholderVector[i])).get();
                ++tmpIndex;
            }
        }
    }

    private HouseholderLeft() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

