/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.RecoverableCondition;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.GenericDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;

abstract class QRDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements QR<N> {
    private final boolean myFullSize;
    private int myNumberOfHouseholderTransformations = 0;

    protected QRDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory, boolean fullSize) {
        super(factory);
        this.myFullSize = fullSize;
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        this.reset();
        DecompositionStore tmpStore = this.setInPlace(matrix);
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        Householder tmpHouseholder = this.makeHouseholder(tmpRowDim);
        int tmpLimit = Math.min(tmpRowDim, tmpColDim);
        for (int ij = 0; ij < tmpLimit; ++ij) {
            if (ij + 1 >= tmpRowDim || !tmpStore.generateApplyAndCopyHouseholderColumn(ij, ij, tmpHouseholder)) continue;
            tmpStore.transformLeft(tmpHouseholder, ij + 1);
            ++this.myNumberOfHouseholderTransformations;
        }
        return this.computed(true);
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction aggregator = this.aggregator().product();
        this.getInPlace().visitDiagonal(aggregator);
        if (this.myNumberOfHouseholderTransformations % 2 == 1) {
            return ((Scalar)((Scalar)this.scalar().one().negate()).multiply(aggregator.get())).get();
        }
        return aggregator.get();
    }

    @Override
    public MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        return this.getSolution(this.makeIdentity(this.getRowDim()), preallocated);
    }

    @Override
    public MatrixStore<N> getQ() {
        DecompositionStore retVal = this.makeEye(this.getRowDim(), this.myFullSize ? this.getRowDim() : this.getMinDim());
        HouseholderReference tmpReference = HouseholderReference.makeColumn(this.getInPlace());
        for (int j = this.getMinDim() - 1; j >= 0; --j) {
            tmpReference.point(j, j);
            if (tmpReference.isZero()) continue;
            retVal.transformLeft(tmpReference, j);
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> getR() {
        Object retVal = this.getInPlace().logical().triangular(true, false).get();
        int padding = this.getRowDim() - this.getColDim();
        if (this.myFullSize && padding > 0) {
            retVal = retVal.logical().below(padding).get();
        }
        return retVal;
    }

    @Override
    public int getRank() {
        int retVal = 0;
        DecompositionStore tmpInPlace = this.getInPlace();
        AggregatorFunction tmpLargest = this.aggregator().largest();
        tmpInPlace.visitDiagonal(0L, 0L, tmpLargest);
        double tmpLargestValue = tmpLargest.doubleValue();
        int tmpMinDim = this.getMinDim();
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            if (tmpInPlace.isSmall(ij, ij, tmpLargestValue)) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs) {
        return this.getSolution(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> preallocated) {
        rhs.supplyTo(preallocated);
        DecompositionStore tmpStore = this.getInPlace();
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        HouseholderReference tmpReference = HouseholderReference.makeColumn(tmpStore);
        int tmpLimit = this.getMinDim();
        for (int j = 0; j < tmpLimit; ++j) {
            tmpReference.point(j, j);
            if (tmpReference.isZero()) continue;
            preallocated.transformLeft(tmpReference, 0);
        }
        preallocated.substituteBackwards(tmpStore, false, false, false);
        if (tmpColDim < tmpRowDim) {
            return preallocated.logical().limits(tmpColDim, (int)preallocated.countColumns()).get();
        }
        if (tmpColDim > tmpRowDim) {
            return preallocated.logical().below(tmpColDim - tmpRowDim).get();
        }
        return preallocated;
    }

    @Override
    public final MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse();
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public final MatrixStore<N> invert(Access2D<?> original, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isFullRank() {
        return this.getRank() == this.getMinDim();
    }

    @Override
    public boolean isFullSize() {
        return this.myFullSize;
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.allocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countRows(), templateRHS.countColumns());
    }

    @Override
    public void reset() {
        super.reset();
        this.myNumberOfHouseholderTransformations = 0;
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs));
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    protected boolean checkSolvability() {
        return this.isComputed() && this.isFullColumnRank();
    }

    protected DecompositionStore<N> getL() {
        int tmpRowDim = this.getColDim();
        int tmpColDim = this.getMinDim();
        DecompositionStore retVal = this.makeZero(tmpRowDim, tmpColDim);
        DecompositionStore tmpStore = this.getInPlace();
        for (int j = 0; j < tmpColDim; ++j) {
            for (int i = j; i < tmpRowDim; ++i) {
                retVal.set((long)i, (long)j, (Number)tmpStore.get(j, i));
            }
        }
        return retVal;
    }

    static final class Rational
    extends QRDecomposition<RationalNumber> {
        Rational() {
            this(false);
        }

        Rational(boolean fullSize) {
            super(GenericDenseStore.RATIONAL, fullSize);
        }
    }

    static final class Quat
    extends QRDecomposition<Quaternion> {
        Quat() {
            this(false);
        }

        Quat(boolean fullSize) {
            super(GenericDenseStore.QUATERNION, fullSize);
        }
    }

    static final class Primitive
    extends QRDecomposition<Double> {
        Primitive() {
            this(false);
        }

        Primitive(boolean fullSize) {
            super(PrimitiveDenseStore.FACTORY, fullSize);
        }
    }

    static final class Complex
    extends QRDecomposition<ComplexNumber> {
        Complex() {
            this(false);
        }

        Complex(boolean fullSize) {
            super(GenericDenseStore.COMPLEX, fullSize);
        }
    }

    static final class Big
    extends QRDecomposition<BigDecimal> {
        Big() {
            this(false);
        }

        Big(boolean fullSize) {
            super(BigDenseStore.FACTORY, fullSize);
        }
    }
}

