/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.frc;

import ch.epfl.biop.frc.FRC;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import java.io.File;

public class FRC_
implements PlugIn {
    private static ResultsTable rt;
    private static final String pref = "biop.frc.";

    public void run(String arg) {
        FRC.ThresholdMethod[] thr_methods = FRC.ThresholdMethod.values();
        String[] thr_names = new String[thr_methods.length];
        int k = 0;
        for (FRC.ThresholdMethod tm : thr_methods) {
            thr_names[k] = tm.toString();
            ++k;
        }
        if (rt == null || WindowManager.getWindow((String)"FRC Results") == null) {
            rt = new ResultsTable();
        }
        FRC frc = new FRC();
        int thr_i = (int)Prefs.get((String)"biop.frc.thrm.index", (double)0.0);
        boolean is_plot = Prefs.get((String)"biop.frc.is.plot", (boolean)false);
        if (arg.compareTo("batch") == 0) {
            String dir1 = Prefs.get((String)"biop.frc.dir1", (String)"");
            String dir2 = Prefs.get((String)"biop.frc.dir2", (String)"");
            GenericDialogPlus gdp = new GenericDialogPlus("Batch FRC Calculation");
            gdp.addMessage("Two folders must be provided.\nEach folder has a matching file in the other.");
            gdp.addDirectoryField("First Folder", dir1);
            gdp.addDirectoryField("Second Folder", dir2);
            gdp.addChoice("Resolution Criteria", thr_names, thr_names[thr_i]);
            gdp.addCheckbox("Save Plot", is_plot);
            gdp.showDialog();
            if (gdp.wasCanceled()) {
                return;
            }
            dir1 = gdp.getNextString();
            dir2 = gdp.getNextString();
            thr_i = gdp.getNextChoiceIndex();
            is_plot = gdp.getNextBoolean();
            Prefs.set((String)"biop.frc.dir1", (String)dir1);
            Prefs.set((String)"biop.frc.dir2", (String)dir2);
            Prefs.set((String)"biop.frc.thrm.index", (int)thr_i);
            Prefs.set((String)"biop.frc.is.plot", (boolean)is_plot);
            File d1 = new File(dir1);
            File d2 = new File(dir2);
            FRC.ThresholdMethod tm = thr_methods[thr_i];
            frc.batchCalculateFireNumber(d1, d2, tm, rt, is_plot);
        } else {
            String[] image_list = WindowManager.getImageTitles();
            if (image_list.length < 2) {
                IJ.error((String)"Need at least 2 images open for FRC Computation");
            }
            GenericDialog gd = new GenericDialog("FRC Calculation");
            gd.addChoice("Image_1", image_list, image_list[0]);
            gd.addChoice("Image_2", image_list, image_list[1]);
            gd.addChoice("Resolution Criteria", thr_names, thr_names[thr_i]);
            gd.addCheckbox("Display Plot", is_plot);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            ImagePlus im1 = WindowManager.getImage((String)gd.getNextChoice());
            ImagePlus im2 = WindowManager.getImage((String)gd.getNextChoice());
            thr_i = gd.getNextChoiceIndex();
            is_plot = gd.getNextBoolean();
            FRC.ThresholdMethod tm = thr_methods[thr_i];
            Prefs.set((String)"biop.frc.thrm.index", (int)thr_i);
            Prefs.set((String)"biop.frc.is.plot", (boolean)is_plot);
            double[][] frc_curve = frc.calculateFrcCurve(im1.getProcessor(), im2.getProcessor());
            double[][] smooth_frc = frc.getSmoothedCurve(frc_curve);
            double fire = frc.calculateFireNumber(smooth_frc, tm);
            rt.incrementCounter();
            rt.addLabel(im1.getTitle() + ":" + im2.getTitle());
            rt.addValue("FRC [" + (Object)((Object)tm) + "]", fire);
            rt.addValue("FRC [" + (Object)((Object)tm) + "] Calibrated [" + im1.getCalibration().getUnit() + "]", fire * im1.getCalibration().pixelHeight);
            rt.show("FRC Results");
            if (is_plot) {
                Plot p = frc.doPlot(frc_curve, smooth_frc, tm, fire, im1.getTitle());
                p.show();
            }
        }
    }

    public static void main(String[] args) {
        Class<FRC_> clazz = FRC_.class;
        String url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString();
        String pluginsDir = url.substring("file:".length(), url.length() - clazz.getName().length() - ".class".length());
        System.setProperty("plugins.dir", pluginsDir);
        new ImageJ();
        ImagePlus image1 = IJ.openImage((String)"http://imagej.net/images/blobs.gif");
        ImagePlus image2 = image1.duplicate();
        IJ.run((ImagePlus)image2, (String)"Add Noise", (String)"");
        IJ.run((ImagePlus)image1, (String)"Add Noise", (String)"");
        image1.show();
        image2.show();
        IJ.runPlugIn((String)clazz.getName(), (String)"");
    }
}

