/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.frc;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Plot;
import ij.measure.ResultsTable;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import org.apache.commons.math3.analysis.interpolation.LoessInterpolator;
import org.apache.commons.math3.util.FastMath;

public class FRC {
    public double perimeterSamplingFactor = 1.0;
    public boolean useHalfCircle = true;
    private float[] taperX = new float[0];
    private float[] taperY = new float[0];

    public double[][] calculateFrcCurve(ImageProcessor ip1, ImageProcessor ip2) {
        IJ.showStatus((String)"Calculating complex FFT images...");
        int maxWidth = FastMath.max((int)ip1.getWidth(), (int)ip2.getWidth());
        int maxHeight = FastMath.max((int)ip1.getHeight(), (int)ip2.getHeight());
        ip1 = this.pad(ip1, maxWidth, maxHeight);
        ip2 = this.pad(ip2, maxWidth, maxHeight);
        FloatProcessor[] fft1 = this.getComplexFFT(ip1);
        FloatProcessor[] fft2 = this.getComplexFFT(ip2);
        IJ.showStatus((String)"Preparing FRC curve calculation...");
        int size = fft1[0].getWidth();
        float[] numerator = new float[size * size];
        float[] absFFT1 = new float[numerator.length];
        float[] absFFT2 = new float[numerator.length];
        float[] dataA1 = (float[])fft1[0].getPixels();
        float[] dataB1 = (float[])fft1[1].getPixels();
        float[] dataA2 = (float[])fft2[0].getPixels();
        float[] dataB2 = (float[])fft2[1].getPixels();
        int y = size;
        int i = size * size - 1;
        while (y-- > 0) {
            int x = size;
            while (x-- > 0) {
                numerator[i] = dataA1[i] * dataA2[i] + dataB1[i] * dataB2[i];
                absFFT1[i] = dataA1[i] * dataA1[i] + dataB1[i] * dataB1[i];
                absFFT2[i] = dataA2[i] * dataA2[i] + dataB2[i] * dataB2[i];
                --i;
            }
        }
        int radius = 1;
        double centre = size / 2;
        double max = Math.max(maxWidth, maxHeight) / 2 - 1;
        IJ.showStatus((String)"Calculating FRC curve...");
        double[][] frcCurve = new double[(int)max][3];
        frcCurve[0][0] = 0.0;
        frcCurve[0][1] = 1.0;
        frcCurve[0][2] = 1.0;
        float[][] images = new float[][]{numerator, absFFT1, absFFT2};
        while ((double)radius < max) {
            double limit;
            double progress = 1.0 * (double)radius / max;
            IJ.showProgress((double)progress);
            IJ.showStatus((String)("Calculating FRC curve...[Radius = " + radius + "px]"));
            double sum1 = 0.0;
            double sum2 = 0.0;
            double sum3 = 0.0;
            double angleStep = 1.0 / (this.perimeterSamplingFactor * (double)radius);
            int numSum = 0;
            double d = limit = this.useHalfCircle ? Math.PI : Math.PI * 2;
            for (double angle = 0.0; angle < limit; angle += angleStep) {
                double x = centre + (double)radius * Math.cos(angle);
                double y2 = centre + (double)radius * Math.sin(angle);
                double[] values = this.getInterpolatedValues(x, y2, images, size);
                sum1 += values[0];
                sum2 += values[1];
                sum3 += values[2];
                ++numSum;
            }
            double val = sum1 / Math.sqrt(sum2 * sum3);
            frcCurve[radius][0] = radius;
            frcCurve[radius][1] = val;
            frcCurve[radius][2] = numSum;
            ++radius;
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"Finished calculating FRC curve...");
        return frcCurve;
    }

    private ImageProcessor pad(ImageProcessor ip, int width, int height) {
        width = width % 2 == 0 ? width : width + 1;
        int n = height = height % 2 == 0 ? height : height + 1;
        if (ip.getWidth() != width || ip.getHeight() != height) {
            ImageProcessor ip2 = ip.createProcessor(width, height);
            ip2.insert(ip, 0, 0);
            ip = ip2;
        }
        return ip;
    }

    public FloatProcessor[] getComplexFFT(ImageProcessor ip) {
        FloatProcessor taperedDataImage = this.getSquareTaperedImage(ip);
        FHT fht = new FHT((ImageProcessor)taperedDataImage);
        fht.transform();
        FloatProcessor[] ret = new FloatProcessor[2];
        ImageStack stack1 = fht.getComplexTransform();
        ret[0] = (FloatProcessor)stack1.getProcessor(1);
        ret[1] = (FloatProcessor)stack1.getProcessor(2);
        return ret;
    }

    public FloatProcessor getSquareTaperedImage(ImageProcessor dataImage) {
        this.taperX = this.getWindowFunction(this.taperX, dataImage.getWidth());
        this.taperY = this.getWindowFunction(this.taperY, dataImage.getHeight());
        int size = FastMath.max((int)dataImage.getWidth(), (int)dataImage.getHeight());
        int newSize = 0;
        for (int i = 4; i < 15 && size > (newSize = (int)Math.pow(2.0, i)); ++i) {
        }
        if (size > newSize) {
            return null;
        }
        dataImage = dataImage.toFloat(0, null);
        float[] data = (float[])dataImage.getPixels();
        float[] pixels = new float[newSize * newSize];
        int maxy_1 = dataImage.getHeight() - 1;
        int maxx_1 = dataImage.getWidth() - 1;
        int oldWidth = dataImage.getWidth();
        for (int y = 1; y < maxy_1; ++y) {
            float yTmp = this.taperY[y];
            int x = 1;
            int i = y * oldWidth + 1;
            int ii = y * newSize + 1;
            while (x < maxx_1) {
                pixels[ii] = data[i] * this.taperX[x] * yTmp;
                ++x;
                ++i;
                ++ii;
            }
        }
        return new FloatProcessor(newSize, newSize, pixels, null);
    }

    private float[] getWindowFunction(float[] taper, int size) {
        if (taper.length != size) {
            if (this.taperX.length == size) {
                return this.taperX;
            }
            if (this.taperY.length == size) {
                return this.taperY;
            }
            int boundary = size / 8;
            int upperBoundary = size - boundary;
            taper = new float[size];
            for (int i = 0; i < size; ++i) {
                taper[i] = i < boundary || i > size - upperBoundary ? (float)Math.pow(Math.sin(Math.PI * 4 * (double)i / (double)size), 2.0) : 1.0f;
            }
        }
        return taper;
    }

    private double[] getInterpolatedValues(double x, double y, float[][] images, int maxx) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        if (xFraction < 0.0) {
            xFraction = 0.0;
        }
        if (yFraction < 0.0) {
            yFraction = 0.0;
        }
        int lowerLeftIndex = ybase * maxx + xbase;
        int lowerRightIndex = lowerLeftIndex + 1;
        int upperLeftIndex = lowerLeftIndex + maxx;
        int upperRightIndex = upperLeftIndex + 1;
        int noImages = 3;
        double[] values = new double[3];
        for (int i = 0; i < 3; ++i) {
            float[] image = images[i];
            double lowerLeft = image[lowerLeftIndex];
            double lowerRight = image[lowerRightIndex];
            double upperRight = image[upperLeftIndex];
            double upperLeft = image[upperRightIndex];
            double upperAverage = upperLeft + xFraction * (upperRight - upperLeft);
            double lowerAverage = lowerLeft + xFraction * (lowerRight - lowerLeft);
            values[i] = lowerAverage + yFraction * (upperAverage - lowerAverage);
        }
        return values;
    }

    public double[][] getSmoothedCurve(double[][] frcCurve, double bandwidth, int robustness) {
        double[][] sCurve = new double[frcCurve.length][3];
        double[] xVals = new double[frcCurve.length];
        double[] yVals = new double[frcCurve.length];
        for (int i = 0; i < frcCurve.length; ++i) {
            xVals[i] = frcCurve[i][0];
            yVals[i] = frcCurve[i][1];
            sCurve[i][0] = frcCurve[i][0];
            sCurve[i][1] = frcCurve[i][1];
            sCurve[i][2] = frcCurve[i][2];
        }
        double[] ySmoothed = new double[frcCurve.length];
        try {
            LoessInterpolator loess = new LoessInterpolator(bandwidth, robustness);
            ySmoothed = loess.smooth(xVals, yVals);
            for (int i = 0; i < frcCurve.length; ++i) {
                sCurve[i][1] = ySmoothed[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sCurve;
    }

    public double[][] getSmoothedCurve(double[][] frcCurve) {
        double bandwidth = 0.0707;
        int robustness = 0;
        return this.getSmoothedCurve(frcCurve, bandwidth, robustness);
    }

    public double[] calculateThresholdCurve(double[][] frcCurve, ThresholdMethod method) {
        double[] threshold = new double[frcCurve.length];
        block4: for (int i = 0; i < threshold.length; ++i) {
            switch (method) {
                case HALF_BIT: {
                    threshold[i] = (0.2071 * Math.sqrt(frcCurve[i][2]) + 1.9102) / (1.2071 * Math.sqrt(frcCurve[i][2]) + 0.9102);
                    continue block4;
                }
                case THREE_SIGMA: {
                    threshold[i] = 3.0 / Math.sqrt(frcCurve[i][2] / 2.0);
                    continue block4;
                }
                default: {
                    threshold[i] = 0.1428;
                }
            }
        }
        return threshold;
    }

    public double[] getIntersections(double[][] frcCurve, double[] thresholdCurve) {
        if (frcCurve.length != thresholdCurve.length) {
            IJ.error((String)"Error", (String)"Unable to calculate FRC curve intersections due to input length mismatch.");
            return null;
        }
        double[] intersections = new double[frcCurve.length - 1];
        int count = 0;
        for (int i = 1; i < frcCurve.length; ++i) {
            double y1 = frcCurve[i - 1][1];
            double y2 = frcCurve[i][1];
            double y3 = thresholdCurve[i - 1];
            double y4 = thresholdCurve[i];
            if (!(y3 >= y1 && y4 < y2) && (!(y1 >= y3) || !(y2 < y4))) continue;
            double x1 = frcCurve[i - 1][0];
            double x2 = frcCurve[i][0];
            double x1_x2 = x1 - x2;
            double y3_y4 = y3 - y4;
            double y1_y2 = y1 - y2;
            double x3 = x1;
            double x4 = x2;
            double x3_x4 = x3 - x4;
            if (x1_x2 * y3_y4 - y1_y2 * x3_x4 == 0.0) {
                if (y1 != y3) continue;
                intersections[count++] = x1;
                continue;
            }
            double px = ((x1 * y2 - y1 * x2) * x3_x4 - x1_x2 * (x3 * y4 - y3 * x4)) / (x1_x2 * y3_y4 - y1_y2 * x3_x4);
            if (!(px >= x1) || !(px < x2)) continue;
            intersections[count++] = px;
        }
        return Arrays.copyOf(intersections, count);
    }

    public double getCorrectIntersection(double[] intersections, ThresholdMethod method) {
        if (intersections == null || intersections.length == 0) {
            return 0.0;
        }
        switch (method) {
            case HALF_BIT: 
            case THREE_SIGMA: {
                return intersections.length > 1 ? intersections[1] : intersections[0];
            }
        }
        return intersections[0];
    }

    public double calculateFireNumber(ImageProcessor ip1, ImageProcessor ip2, ThresholdMethod method) {
        double[][] frcCurve = this.calculateFrcCurve(ip1, ip2);
        return this.calculateFireNumber(frcCurve, method);
    }

    public double calculateFireNumber(double[][] frcCurve, ThresholdMethod method) {
        double[] thresholdCurve = this.calculateThresholdCurve(frcCurve, method);
        double[] intersections = this.getIntersections(frcCurve, thresholdCurve);
        double fire = Double.NaN;
        if (intersections == null || intersections.length != 0) {
            double spatialFrequency = this.getCorrectIntersection(intersections, method);
            fire = (double)(2 * (frcCurve.length + 1)) / spatialFrequency;
        }
        return fire;
    }

    public void batchCalculateFireNumber(File directory1, File directory2, ThresholdMethod method, ResultsTable rt, boolean is_save_plot) {
        String[] the_files = directory1.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        });
        File save_dir = new File(directory1.getParentFile(), "Graphs");
        save_dir.mkdir();
        for (String the_file : the_files) {
            File f1 = new File(directory1.getAbsolutePath() + File.separator + the_file);
            File f2 = new File(directory2.getAbsolutePath() + File.separator + the_file);
            if (!f2.exists()) continue;
            ImagePlus i1 = IJ.openImage((String)f1.getAbsolutePath());
            ImagePlus i2 = IJ.openImage((String)f2.getAbsolutePath());
            double[][] frc_curve = this.calculateFrcCurve(i1.getProcessor(), i2.getProcessor());
            double[][] smooth_frc = this.getSmoothedCurve(frc_curve);
            double fire = this.calculateFireNumber(smooth_frc, method);
            rt.incrementCounter();
            rt.addLabel(i1.getTitle());
            rt.addValue("FRC [" + (Object)((Object)method) + "]", fire);
            rt.addValue("FRC [" + (Object)((Object)method) + "] Calibrated [" + i1.getCalibration().getUnit() + "]", fire * i1.getCalibration().pixelHeight);
            rt.show("FRC Results");
            if (!is_save_plot) continue;
            Plot p = this.doPlot(frc_curve, smooth_frc, method, fire, i1.getTitle());
            ImagePlus plot_image = p.makeHighResolution("FRC", 3.0f, true, false);
            String plot_name = save_dir.getAbsolutePath() + File.separator + f1.getName().substring(0, f1.getName().lastIndexOf("."));
            plot_name = plot_name + "_" + method.toString().replaceAll("/", " over ") + ".tif";
            IJ.save((ImagePlus)plot_image, (String)plot_name);
        }
    }

    public Plot doPlot(double[][] frc_curve, double[][] smooth_frc, ThresholdMethod tm, double fire, String name) {
        FRC frc = new FRC();
        double[] x = new double[frc_curve.length];
        double[] y = new double[frc_curve.length];
        double[] sy = new double[frc_curve.length];
        for (int i = 0; i < frc_curve.length; ++i) {
            x[i] = frc_curve[i][0] / (double)(2 * (frc_curve.length + 1));
            y[i] = frc_curve[i][1];
            sy[i] = smooth_frc[i][1];
        }
        double[] thr_curve = frc.calculateThresholdCurve(smooth_frc, tm);
        Plot p = new Plot("FRC Of " + name, "Spatial Frequency", "Correlation");
        p.setLineWidth(1);
        p.setLimits(0.0, x[x.length - 1], 0.0, 1.0);
        p.setColor(new Color(0, 0, 0));
        p.addPoints(x, y, 2);
        p.setColor(new Color(255, 120, 120));
        p.addPoints(x, sy, 2);
        p.setColor(new Color(120, 120, 255));
        p.addPoints(x, thr_curve, 2);
        p.setColor(new Color(69, 69, 69));
        p.drawLine(1.0 / fire, 0.0, 1.0 / fire, 1.0);
        p.addLabel(0.02, 0.3, "FIRE = " + String.format("%.3f", fire));
        p.addLegend("FRC\nSmoothed FRC\nThreshold");
        return p;
    }

    public static enum ThresholdMethod {
        FIXED_1_OVER_7("Fixed 1/7"),
        HALF_BIT("Half-bit"),
        THREE_SIGMA("Three sigma");

        private String name;

        private ThresholdMethod(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

