/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.coloc.utils;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.plugin.Duplicator;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class Utils {
    public static synchronized void clearOutside(ImageProcessor ip, ImageProcessor mask) {
        for (int i = 0; i < ip.getWidth(); ++i) {
            for (int j = 0; j < ip.getHeight(); ++j) {
                ip.setf(i, j, mask.getf(i, j) > 0.0f ? ip.getf(i, j) : 0.0f);
            }
        }
    }

    public static ImageProcessor binarize(ImageProcessor ip, int lowerThr) {
        ByteProcessor bp = new ByteProcessor(ip.getWidth(), ip.getHeight());
        for (int x = 0; x < ip.getWidth(); ++x) {
            for (int y = 0; y < ip.getHeight(); ++y) {
                if (!(ip.getf(x, y) >= (float)lowerThr)) continue;
                bp.set(x, y, 255);
            }
        }
        return bp;
    }

    public static ImagePlus binarize(ImagePlus imp, int lowerThr) {
        if (imp.getStackSize() == 1) {
            ImagePlus imp2 = new ImagePlus("Mask " + imp.getTitle(), Utils.binarize(imp.getProcessor(), lowerThr));
            imp2.setCalibration(imp.getCalibration());
            return imp2;
        }
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = imp.createEmptyStack();
        int nSlices = imp.getStackSize();
        for (int i = 1; i <= nSlices; ++i) {
            String label = stack1.getSliceLabel(i);
            ImageProcessor ip = stack1.getProcessor(i);
            stack2.addSlice(label, Utils.binarize(ip, lowerThr));
        }
        ImagePlus imp2 = new ImagePlus("Mask " + imp.getTitle(), stack2);
        imp2.setCalibration(imp.getCalibration());
        return imp2;
    }

    public static double[][] getDisplayRange(ImagePlus imp) {
        double[][] drange = new double[imp.getNChannels()][];
        for (int i = 0; i < drange.length; ++i) {
            imp.setC(i + 1);
            drange[i] = new double[2];
            drange[i][0] = imp.getDisplayRangeMin();
            drange[i][1] = imp.getDisplayRangeMax();
        }
        return drange;
    }

    public static void setDisplayRange(ImagePlus impr, double[][] range) {
        for (int i = 0; i < range.length; ++i) {
            impr.setC(i + 1);
            impr.setDisplayRange(range[i][0], range[i][1]);
        }
    }

    public static ImagePlus scale(ImagePlus fluo, int width) {
        if (fluo.getStackSize() == 1) {
            ImageProcessor ip = fluo.getProcessor();
            ip.setInterpolationMethod(1);
            return new ImagePlus(fluo.getTitle(), ip.resize(width));
        }
        ImageStack fscaledStack = fluo.createEmptyStack();
        for (int i = 0; i < fluo.getStackSize(); ++i) {
            ImageProcessor ip = fluo.getProcessor();
            fscaledStack.addSlice(ip.resize(width));
        }
        return new ImagePlus(fluo.getTitle(), fscaledStack);
    }

    public static ImagePlus[] cropSlices(ImagePlus singleTimeImp, Roi roi, Boolean doSeparateZ) {
        int nC = singleTimeImp.getNChannels();
        int nZ = singleTimeImp.getNSlices();
        Duplicator dup = new Duplicator();
        if (doSeparateZ.booleanValue()) {
            ImagePlus[] zSlices = new ImagePlus[nZ];
            for (int z = 1; z <= nZ; ++z) {
                zSlices[z - 1] = dup.run(singleTimeImp, 1, nC, z, z, 1, 1);
                zSlices[z - 1].setTitle(singleTimeImp.getTitle() + " Z" + z);
                if (roi == null) continue;
                zSlices[z - 1].setRoi(roi);
            }
            return zSlices;
        }
        ImagePlus[] allSlices = new ImagePlus[]{singleTimeImp};
        allSlices[0].setTitle(singleTimeImp.getTitle());
        if (roi != null) {
            allSlices[0].setRoi(roi);
        }
        return allSlices;
    }

    public static ImagePlus cropTime(ImagePlus imp, Roi roi, int timepoint, Boolean is_crop) {
        int nC = imp.getNChannels();
        int nZ = imp.getNSlices();
        Duplicator dup = new Duplicator();
        if (is_crop.booleanValue()) {
            imp.setRoi(roi);
        } else {
            imp.killRoi();
        }
        ImagePlus tmp = dup.run(imp, 1, nC, 1, nZ, timepoint, timepoint);
        tmp.setTitle(imp.getTitle() + " T" + timepoint);
        if (roi != null && is_crop.booleanValue()) {
            Roi roi2 = (Roi)roi.clone();
            roi2.setLocation(0, 0);
            tmp.setRoi(roi2);
            roi = roi2;
        }
        return tmp;
    }

    public static ImageProcessor getMask(ImagePlus imp, Roi roi) {
        ByteProcessor ip = new ByteProcessor(imp.getWidth(), imp.getHeight());
        ip.setRoi(roi);
        ip.setValue(255.0);
        ip.fill(ip.getMask());
        return ip;
    }
}

