/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.coloc.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Plot;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.RGBStackMerge;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math3.special.Erf;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.util.CombinatoricsUtils;

public class RandomCostes {
    public ImagePlus imp_orig;
    public ImagePlus imgA;
    public ImagePlus imgB;
    public int squareSize;
    public int nShuffling;
    public boolean binarize;
    public int thrA;
    public int thrB;
    public Roi roi;
    public double pearsonNormalized = Double.NaN;
    public double pearson = Double.NaN;
    public double pValueIsCorrelated = Double.NaN;
    public double pValueIsAntiCorrelated = Double.NaN;
    ImagePlus impSampleShuffle;
    StandardDeviation sd;
    double[] valuesShuffling;

    public RandomCostes(ImagePlus imgA, ImagePlus imgB, int squareSize, int nShuffling, boolean binarize, int thrA, int thrB) {
        this.imgA = imgA.duplicate();
        this.imgB = imgB.duplicate();
        this.roi = imgA.getRoi();
        if (this.roi == null) {
            this.roi = new Roi(0, 0, imgA.getWidth(), imgA.getHeight());
        }
        this.squareSize = squareSize;
        this.nShuffling = nShuffling;
        this.binarize = binarize;
        if (binarize) {
            imgA.getProcessor().setThreshold((double)thrA, Double.MAX_VALUE, 2);
            ImagePlus imgTempA = new ImagePlus();
            imgTempA.setProcessor((ImageProcessor)imgA.getProcessor().createMask());
            this.imgA = imgTempA;
            imgB.getProcessor().setThreshold((double)thrB, Double.MAX_VALUE, 2);
            ImagePlus imgTempB = new ImagePlus();
            imgTempB.setProcessor((ImageProcessor)imgB.getProcessor().createMask());
            this.imgB = imgTempB;
        }
        this.imp_orig = RGBStackMerge.mergeChannels((ImagePlus[])new ImagePlus[]{imgA, imgB}, (boolean)true);
        this.thrA = thrA;
        this.thrB = thrB;
    }

    public void compute() {
        this.imp_orig.setDisplayMode(3);
        this.imp_orig.setRoi((Roi)null);
        ImagePlus imp = this.imp_orig.duplicate();
        imp.setRoi(this.roi);
        ShapeRoi sroi = new ShapeRoi(this.roi);
        Shape shape = sroi.getShape();
        Rectangle bounds = shape.getBounds();
        int nBlocks = 0;
        ImagePlus impCH1 = IJ.createImage((String)"Costes Block CH1", (String)"32-bit black", (int)this.squareSize, (int)this.squareSize, (int)1);
        ImagePlus impCH2 = IJ.createImage((String)"Costes Block CH2", (String)"32-bit black", (int)this.squareSize, (int)this.squareSize, (int)1);
        int x = bounds.x;
        while (x + this.squareSize < bounds.x + bounds.width) {
            int y = bounds.y;
            while (y + this.squareSize < bounds.y + bounds.height) {
                Rectangle r = new Rectangle(x, y, this.squareSize, this.squareSize);
                if (sroi.getShape().contains(r)) {
                    this.imgA.setRoi((int)((double)x + sroi.getXBase()), (int)((double)y + sroi.getYBase()), this.squareSize, this.squareSize);
                    IJ.run((ImagePlus)this.imgA, (String)"Copy", (String)"");
                    IJ.run((ImagePlus)impCH1, (String)"Add Slice", (String)"");
                    impCH1.setSlice(nBlocks);
                    IJ.run((ImagePlus)impCH1, (String)"Paste", (String)"");
                    this.imgB.setRoi((int)((double)x + sroi.getXBase()), (int)((double)y + sroi.getYBase()), this.squareSize, this.squareSize);
                    IJ.run((ImagePlus)this.imgB, (String)"Copy", (String)"");
                    IJ.run((ImagePlus)impCH2, (String)"Add Slice", (String)"");
                    impCH2.setSlice(nBlocks);
                    IJ.run((ImagePlus)impCH2, (String)"Paste", (String)"");
                    ++nBlocks;
                }
                y += this.squareSize;
            }
            x += this.squareSize;
        }
        double pearson = this.getPearson(impCH1, impCH2);
        ArrayList<Integer> blockIndexes = new ArrayList<Integer>();
        for (int i = 0; i < nBlocks; ++i) {
            blockIndexes.add(i);
        }
        imp.setRoi(this.roi);
        double maxShuffling = CombinatoricsUtils.factorialDouble((int)nBlocks);
        if (this.nShuffling < 100) {
            System.out.println("Take care! Low number of shuffling...");
        }
        if ((double)this.nShuffling > 2.0 * maxShuffling) {
            System.out.println("Take care! You ask for " + this.nShuffling + " shufflings, but the maximal number of shuffling is " + maxShuffling);
            System.out.println("You are sampling many times the same shuffling.");
        }
        this.sd = new StandardDeviation(false);
        double sum = 0.0;
        int nAbove = 0;
        int nBelow = 0;
        this.valuesShuffling = new double[this.nShuffling];
        ImagePlus impCH2Shuffled = IJ.createImage((String)"Costes Block CH2 Shuffled", (String)"32-bit black", (int)this.squareSize, (int)this.squareSize, (int)nBlocks);
        for (int iShuffle = 0; iShuffle < this.nShuffling; ++iShuffle) {
            Collections.shuffle(blockIndexes);
            for (int iSlice = 0; iSlice < nBlocks; ++iSlice) {
                impCH2Shuffled.getStack().setProcessor(impCH2.getStack().getProcessor((Integer)blockIndexes.get(iSlice) + 1), iSlice + 1);
            }
            double value = this.getPearson(impCH1, impCH2Shuffled);
            if (value > pearson) {
                ++nAbove;
            }
            if (value < pearson) {
                ++nBelow;
            }
            sum += value;
            this.sd.increment(value);
            this.valuesShuffling[iShuffle] = value;
        }
        double shufflingMean = sum / (double)this.nShuffling;
        double shufflingStd = this.sd.getResult();
        this.pearsonNormalized = (pearson - shufflingMean) / shufflingStd;
        this.pearson = pearson;
        this.pValueIsCorrelated = Erf.erfc((double)(-this.pearsonNormalized)) / 2.0;
        this.pValueIsAntiCorrelated = Erf.erfc((double)this.pearsonNormalized) / 2.0;
        imp.changes = false;
        ImagePlus impSampleShuffleCH1 = IJ.createImage((String)"Sample CH1", (String)"32-bit black", (int)imp.getWidth(), (int)imp.getHeight(), (int)1);
        ImagePlus impSampleShuffleCH2 = IJ.createImage((String)"Sample Shuffle CH2", (String)"32-bit black", (int)imp.getWidth(), (int)imp.getHeight(), (int)1);
        int iSlice = 0;
        int x2 = bounds.x;
        while (x2 + this.squareSize < bounds.x + bounds.width) {
            int y = bounds.y;
            while (y + this.squareSize < bounds.y + bounds.height) {
                Rectangle r = new Rectangle(x2, y, this.squareSize, this.squareSize);
                if (sroi.getShape().contains(r)) {
                    this.imgA.setRoi((int)((double)x2 + sroi.getXBase()), (int)((double)y + sroi.getYBase()), this.squareSize, this.squareSize);
                    IJ.run((ImagePlus)this.imgA, (String)"Copy", (String)"");
                    impSampleShuffleCH1.setRoi((int)((double)x2 + sroi.getXBase()), (int)((double)y + sroi.getYBase()), this.squareSize, this.squareSize);
                    IJ.run((ImagePlus)impSampleShuffleCH1, (String)"Paste", (String)"");
                    impCH2Shuffled.setSlice(++iSlice);
                    IJ.run((ImagePlus)impCH2Shuffled, (String)"Copy", (String)"");
                    impSampleShuffleCH2.setRoi((int)((double)x2 + sroi.getXBase()), (int)((double)y + sroi.getYBase()), this.squareSize, this.squareSize);
                    IJ.run((ImagePlus)impSampleShuffleCH2, (String)"Paste", (String)"");
                    ++nBlocks;
                }
                y += this.squareSize;
            }
            x2 += this.squareSize;
        }
        impSampleShuffleCH1.setLut(this.imgA.getLuts()[0]);
        impSampleShuffleCH2.setLut(this.imgB.getLuts()[0]);
        imp.close();
        this.impSampleShuffle = RGBStackMerge.mergeChannels((ImagePlus[])new ImagePlus[]{impSampleShuffleCH1, impSampleShuffleCH2}, (boolean)true);
    }

    public Plot getPearsonDistributionGraph(boolean userDefinedLimits, double userMin, double userMax) {
        double binRes = 0.25;
        int minBin = (int)(-6.0 / binRes);
        int maxBin = (int)(6.0 / binRes);
        if (!Double.isNaN(this.pearsonNormalized) && this.pearsonNormalized != Double.NEGATIVE_INFINITY && this.pearsonNormalized != Double.POSITIVE_INFINITY) {
            if (this.pearsonNormalized > 0.0) {
                maxBin = Math.max(maxBin, (int)(this.pearsonNormalized * 1.5 / binRes + 1.0));
            } else if (this.pearsonNormalized < 0.0) {
                minBin = Math.min(minBin, (int)(this.pearsonNormalized * 1.5 / binRes - 1.0));
            }
        }
        double[] bins = new double[maxBin - minBin];
        double[] xs = new double[maxBin - minBin];
        double[] gaussFit = new double[maxBin - minBin];
        for (int iV = 0; iV < this.valuesShuffling.length; ++iV) {
            int iBin = (int)(this.valuesShuffling[iV] / this.sd.getResult() / binRes - (double)minBin + 0.5);
            if (iBin < 0) {
                bins[0] = bins[0] + 1.0;
                continue;
            }
            if (iBin >= bins.length) {
                int n = bins.length - 1;
                bins[n] = bins[n] + 1.0;
                continue;
            }
            int n = iBin;
            bins[n] = bins[n] + 1.0;
        }
        double normFactor = 1.0 / Math.sqrt(Math.PI * 2);
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = (double)(minBin + i) * binRes * this.sd.getResult();
            int n = i;
            bins[n] = bins[n] / (double)this.valuesShuffling.length;
            int n2 = i;
            bins[n2] = bins[n2] / binRes;
            gaussFit[i] = Math.exp(-xs[i] * xs[i] / (2.0 * this.sd.getResult() * this.sd.getResult())) * normFactor;
        }
        String titlePlot = "Random Costes";
        if (this.binarize) {
            titlePlot = titlePlot + " Mask";
        }
        Plot plot = new Plot(titlePlot, "Pearson", "Probability");
        plot.setColor("black");
        plot.setLineWidth(3);
        plot.addPoints(xs, gaussFit, 2);
        plot.addPoints(xs, bins, 0);
        plot.setColor("red");
        plot.addPoints(new double[]{this.pearson, this.pearson}, new double[]{0.0, 0.4}, 2);
        if (userDefinedLimits) {
            plot.setLimits(userMin, userMax, 0.0, 0.4);
        }
        return plot;
    }

    public ImagePlus getExampleShuffleImage() {
        return this.impSampleShuffle;
    }

    double getPearson(ImagePlus img1, ImagePlus img2) {
        int nSlices = img1.getNSlices();
        int rheight = img1.getHeight();
        int rwidth = img1.getWidth();
        double N = nSlices * rheight * rwidth;
        double sumX = 0.0;
        double sumXX = 0.0;
        double sumXY = 0.0;
        double sumYY = 0.0;
        double sumY = 0.0;
        for (int s = 1; s < nSlices; ++s) {
            ImageProcessor ip1 = img1.getStack().getProcessor(s);
            ImageProcessor ip2 = img2.getStack().getProcessor(s);
            for (int y = 0; y < rheight; ++y) {
                for (int x = 0; x < rwidth; ++x) {
                    float ch1 = ip1.getPixelValue(x, y);
                    float ch2 = ip2.getPixelValue(x, y);
                    sumX += (double)ch1;
                    sumXY += (double)(ch1 * ch2);
                    sumXX += (double)(ch1 * ch1);
                    sumYY += (double)(ch2 * ch2);
                    sumY += (double)ch2;
                }
            }
        }
        double pearsons1 = sumXY - sumX * sumY / N;
        double pearsons2 = sumXX - sumX * sumX / N;
        double pearsons3 = sumYY - sumY * sumY / N;
        double rTotal = pearsons1 / Math.sqrt(pearsons2 * pearsons3);
        return rTotal;
    }
}

