/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.coloc.utils;

import ch.epfl.biop.coloc.utils.RandomCostes;
import ch.epfl.biop.coloc.utils.Utils;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Overlay;
import ij.gui.Plot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.ResultsTable;
import ij.plugin.ChannelSplitter;
import ij.plugin.RGBStackMerge;
import ij.plugin.ZProjector;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.Color;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.integer.IntType;
import sc.fiji.coloc.algorithms.AutoThresholdRegression;
import sc.fiji.coloc.algorithms.Histogram2D;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.algorithms.PearsonsCorrelation;
import sc.fiji.coloc.algorithms.SpearmanRankCorrelation;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.ResultHandler;
import sc.fiji.coloc.results.Warning;

public class ImageColocalizer {
    int width;
    int height;
    int nbSlices;
    int depth;
    int length;
    int widthCostes;
    int heightCostes;
    int nbsliceCostes;
    String titleA;
    String titleB;
    int[] A;
    int[] B;
    int[] M;
    int Amin;
    int Amax;
    int Bmin;
    int Bmax;
    double Amean;
    double Bmean;
    Calibration cal;
    Calibration micronCal;
    ResultsTable rt;
    boolean doThat;
    double sumA;
    double sumB;
    double sumAB;
    double sumsqrA;
    double Aarraymean;
    double Barraymean;
    private Plot fluorogram_plot;
    private Plot cff_plot;
    private Plot ica_a_plot;
    private Plot ica_b_plot;
    private Roi roi = null;
    String roiName = "";
    private ImagePlus impA;
    private ImagePlus impB;
    private int thrA;
    private int thrB;
    private ImageProcessor mask;
    ResultHandler<IntType> resultHandler = new ResultHandler<IntType>(){

        public void handleImage(RandomAccessibleInterval<IntType> image, String name) {
        }

        public void handleHistogram(Histogram2D<IntType> histogram, String name) {
        }

        public void handleWarning(Warning warning) {
            IJ.log((String)warning.getShortMessage());
        }

        public void handleValue(String name, String value) {
        }

        public void handleValue(String name, double value) {
        }

        public void handleValue(String name, double value, int decimals) {
        }

        public void process() {
        }
    };
    public ImagePlus randomCostesMaskPlot;
    public ImagePlus randomCostesPlot;
    public ImagePlus randomCostesMaskExampleShuffledImg;
    public ImagePlus randomCostesExampleShuffledImg;

    public ImageColocalizer(ImagePlus ipA, ImagePlus ipB) {
        this.setup(ipA, ipB, new Calibration());
    }

    public ImageColocalizer(ImagePlus ipA, ImagePlus ipB, Calibration cal) {
        this.setup(ipA, ipB, cal);
    }

    public ImageColocalizer(ImagePlus imp, int channelA, int channelB) {
        Roi roi = imp.getRoi();
        imp.deleteRoi();
        ImagePlus[] channels = ChannelSplitter.split((ImagePlus)imp);
        if (roi != null) {
            channels[channelA - 1].setRoi(roi);
            channels[channelB - 1].setRoi(roi);
        }
        this.setup(channels[channelA - 1], channels[channelB - 1], imp.getCalibration());
    }

    public void setup(ImagePlus oipA, ImagePlus oipB, Calibration cal) {
        if (oipA.getRoi() != null || oipB.getRoi() != null) {
            this.roi = oipA.getRoi() != null ? oipA.getRoi() : oipB.getRoi();
            this.roiName = this.roi.getName();
            oipA.deleteRoi();
            oipB.deleteRoi();
            this.impA = oipA.duplicate();
            this.impB = oipB.duplicate();
            oipA.setRoi(this.roi);
            oipB.setRoi(this.roi);
            ImageProcessor tip = oipA.getProcessor();
            tip.setRoi(this.roi);
            this.mask = Utils.getMask(this.impA, this.roi);
            for (int i = 1; i <= this.impA.getNSlices(); ++i) {
                Utils.clearOutside(this.impA.getStack().getProcessor(i), this.mask);
                Utils.clearOutside(this.impB.getStack().getProcessor(i), this.mask);
            }
            this.impA.setTitle(oipA.getTitle());
            this.impB.setTitle(oipB.getTitle());
        } else {
            this.impA = oipA;
            this.impB = oipB;
            this.mask = Utils.getMask(this.impA, this.roi);
        }
        this.width = this.impA.getWidth();
        this.height = this.impA.getHeight();
        this.nbSlices = this.impA.getNSlices();
        this.depth = this.impA.getBitDepth();
        if (this.width != this.impB.getWidth() || this.height != this.impB.getHeight() || this.nbSlices != this.impB.getNSlices() || this.depth != this.impB.getBitDepth()) {
            IJ.error((String)"ImageColocalizer expects both images to have the same size and depth");
            return;
        }
        this.length = this.width * this.height * this.nbSlices;
        this.A = new int[this.length];
        this.B = new int[this.length];
        this.M = new int[this.length];
        this.titleA = this.impA.getTitle();
        this.titleB = this.impB.getTitle();
        this.cal = cal;
        this.micronCal = (Calibration)cal.clone();
        this.micronCal.pixelDepth /= 1000.0;
        this.micronCal.pixelHeight /= 1000.0;
        this.micronCal.pixelWidth /= 1000.0;
        this.micronCal.setUnit("um");
        this.buildArray(this.impA, this.impB, this.mask);
        IJ.log((String)("**************************************************\nImage A: " + this.titleA + "\nImage B: " + this.titleB));
        this.rt = ResultsTable.getResultsTable();
        if (this.rt == null) {
            this.rt = new ResultsTable();
        }
        this.rt.incrementCounter();
        this.rt.addValue("Image A", this.titleA);
        this.rt.addValue("Image B", this.titleB);
        if (this.roi != null) {
            this.rt.addValue("ROI", this.roiName);
        }
    }

    public void Pearson() {
        this.doThat = true;
        double pearsons_coeff = this.linreg(this.A, this.B, 0, 0)[2];
        IJ.log((String)("\nPearson's Coefficient:\nr=" + this.round(pearsons_coeff, 3)));
        this.rt.addValue("Pearson's Coefficient", pearsons_coeff);
    }

    public void SpearmanRank() {
        int i;
        this.doThat = true;
        SpearmanRankCorrelation corr = new SpearmanRankCorrelation();
        int countPix = 0;
        for (int i2 = 0; i2 < this.M.length; ++i2) {
            if (this.M[i2] <= 0) continue;
            ++countPix;
        }
        double[][] data = new double[countPix][2];
        countPix = 0;
        for (i = 0; i < this.A.length; ++i) {
            if (this.M[i] <= 0) continue;
            data[countPix][0] = this.A[i];
            ++countPix;
        }
        countPix = 0;
        for (i = 0; i < this.B.length; ++i) {
            if (this.M[i] <= 0) continue;
            data[countPix][1] = this.B[i];
            ++countPix;
        }
        double spearmanrank_coeff = corr.calculateSpearmanRank(data);
        IJ.log((String)("\nSpearman's Rank Coefficient:\nr=" + this.round(spearmanrank_coeff, 3)));
        this.rt.addValue("Spearman's Rank Coefficient", spearmanrank_coeff);
    }

    public void Overlap() {
        double num = 0.0;
        double numThr = 0.0;
        double den1 = 0.0;
        double den1Thr = 0.0;
        double den2 = 0.0;
        double den2Thr = 0.0;
        for (int i = 0; i < this.length; ++i) {
            num += (double)(this.A[i] * this.B[i]);
            den1 += Math.pow(this.A[i], 2.0);
            den2 += Math.pow(this.B[i], 2.0);
            if (this.A[i] <= this.thrA || this.B[i] <= this.thrB) continue;
            numThr += (double)(this.A[i] * this.B[i]);
            den1Thr += Math.pow(this.A[i], 2.0);
            den2Thr += Math.pow(this.B[i], 2.0);
        }
        double OverlapCoeff = num / Math.sqrt(den1 * den2);
        IJ.log((String)("\nOverlap Coefficient:\nr=" + this.round(OverlapCoeff, 3)));
        IJ.log((String)("\nr^2=k1xk2:\nk1=" + this.round(num / den1, 3) + "\nk2=" + this.round(num / den2, 3)));
        double OverlapCoeffThr = numThr / Math.sqrt(den1Thr * den2Thr);
        IJ.log((String)("\n\nUsing thresholds (thrA=" + this.thrA + " and thrB=" + this.thrB + ")"));
        IJ.log((String)("\nOverlap Coefficient:\nr=" + this.round(OverlapCoeffThr, 3)));
        IJ.log((String)("\nr^2=k1xk2:\nk1=" + this.round(numThr / den1Thr, 3) + "\nk2=" + this.round(numThr / den2Thr, 3)));
        this.rt.addValue("Overlap Coefficient", OverlapCoeff);
        this.rt.addValue("k1", num / den1);
        this.rt.addValue("k2", num / den2);
        this.rt.addValue("Threshold A", (double)this.thrA);
        this.rt.addValue("Threshold B", (double)this.thrB);
        this.rt.addValue("Thresholded Overlap Coefficient", OverlapCoeffThr);
        this.rt.addValue("Thresholded k1", numThr / den1Thr);
        this.rt.addValue("Thresholded k2", numThr / den2Thr);
    }

    public void Areas() {
        double AA = 0.0;
        double AB = 0.0;
        double AAB = 0.0;
        double totalPix = 0.0;
        for (int i = 0; i < this.length; ++i) {
            if (this.A[i] > this.thrA) {
                AA += 1.0;
            }
            if (this.B[i] > this.thrB) {
                AB += 1.0;
            }
            if (this.A[i] > this.thrA && this.B[i] > this.thrB) {
                AAB += 1.0;
            }
            if (this.M[i] <= 0) continue;
            totalPix += 1.0;
        }
        IJ.log((String)("\nArea ROI (" + this.impA.getCalibration().getXUnit() + ") Area tot = " + this.round(totalPix *= Math.pow(this.impA.getCalibration().pixelWidth, 2.0), 0) + "\nArea Measurements (" + this.impA.getCalibration().getXUnit() + ")\n Area A=" + this.round(AA *= Math.pow(this.impA.getCalibration().pixelWidth, 2.0), 0) + "Area B=" + this.round(AB *= Math.pow(this.impA.getCalibration().pixelWidth, 2.0), 0) + "\n Area Overlap=" + this.round(AAB *= Math.pow(this.impA.getCalibration().pixelWidth, 2.0), 0)));
        this.rt.addValue("Area tot", totalPix);
        this.rt.addValue("Area A", AA);
        this.rt.addValue("Area B", AB);
        this.rt.addValue("Area Overlap", AAB);
    }

    public void MM() {
        double sumAcoloc = 0.0;
        double sumAcolocThr = 0.0;
        double sumA = 0.0;
        double sumAThr = 0.0;
        double sumBcoloc = 0.0;
        double sumBcolocThr = 0.0;
        double sumB = 0.0;
        double sumBThr = 0.0;
        for (int i = 0; i < this.length; ++i) {
            if (this.B[i] > 0) {
                sumB += (double)this.B[i];
                if (this.A[i] > 0) {
                    sumAcoloc += (double)this.A[i];
                }
            }
            if (this.B[i] > this.thrB) {
                sumBThr += (double)this.B[i];
                if (this.A[i] > this.thrA) {
                    sumAcolocThr += (double)this.A[i];
                }
            }
            if (this.A[i] > 0) {
                sumA += (double)this.A[i];
                if (this.B[i] > 0) {
                    sumBcoloc += (double)this.B[i];
                }
            }
            if (this.A[i] <= this.thrA) continue;
            sumAThr += (double)this.A[i];
            if (this.B[i] <= this.thrB) continue;
            sumBcolocThr += (double)this.B[i];
        }
        double M1 = sumAcoloc / sumA;
        double M1Thr = sumAcolocThr / sumAThr;
        double M2 = sumBcoloc / sumB;
        double M2Thr = sumBcolocThr / sumBThr;
        IJ.log((String)("\nManders' Coefficients (original):\nM1=" + this.round(M1, 3) + " (fraction of A overlapping B)\nM2=" + this.round(M2, 3) + " (fraction of B overlapping A)"));
        IJ.log((String)("\nManders' Coefficients (using threshold value of " + this.thrA + " for imgA and " + this.thrB + " for imgB):\nM1=" + this.round(M1Thr, 3) + " (fraction of A overlapping B)\nM2=" + this.round(M2Thr, 3) + " (fraction of B overlapping A)"));
        this.rt.addValue("M1", M1);
        this.rt.addValue("M2", M2);
        this.rt.addValue("Threshold A", (double)this.thrA);
        this.rt.addValue("Threshold B", (double)this.thrB);
        this.rt.addValue("Thresholded M1", M1Thr);
        this.rt.addValue("Thresholded M2", M2Thr);
    }

    public void CostesAutoThr() {
        ArrayImg imgA = ArrayImgs.ints((int[])this.A, (long[])new long[]{this.A.length});
        ArrayImg imgB = ArrayImgs.ints((int[])this.B, (long[])new long[]{this.B.length});
        ArrayImg imgMask = ArrayImgs.ints((int[])this.M, (long[])new long[]{this.M.length});
        try {
            DataContainer dc = new DataContainer((RandomAccessibleInterval)imgA, (RandomAccessibleInterval)imgB, 0, 1, "image A", "image B", (RandomAccessibleInterval)imgMask, new long[]{0L}, new long[]{this.M.length});
            PearsonsCorrelation pc = new PearsonsCorrelation();
            AutoThresholdRegression ar = new AutoThresholdRegression(pc);
            ar.execute(dc);
            ar.processResults(this.resultHandler);
            int CostesThrA = (int)((IntType)ar.getCh1MaxThreshold()).getRealDouble();
            int CostesThrB = (int)((IntType)ar.getCh2MaxThreshold()).getRealDouble();
            IJ.log((String)("\nCostes' automatic threshold set to " + CostesThrA + " for imgA & " + CostesThrB + " for imgB"));
            this.rt.addValue("Threshold A", (double)CostesThrA);
            this.rt.addValue("Threshold B", (double)CostesThrB);
            this.thrA = CostesThrA;
            this.thrB = CostesThrB;
            this.setThresholds(this.thrA, this.thrB);
        }
        catch (MissingPreconditionException e) {
            throw new RuntimeException(e);
        }
    }

    public void CCF(int CCFx) {
        double CCFmin = 0.0;
        int lmin = -CCFx;
        double CCFmax = 0.0;
        int lmax = -CCFx;
        double[] CCFarray = new double[2 * CCFx + 1];
        double[] x = new double[2 * CCFx + 1];
        int count = 0;
        IJ.log((String)("\nVan Steensel's Cross-correlation Coefficient between " + this.titleA + " and " + this.titleB + ":"));
        for (int l = -CCFx; l <= CCFx; ++l) {
            int coordShift;
            int coord;
            int i;
            int j;
            int k;
            IJ.showStatus((String)("CCF calculation in progress: " + (count + 1) + "/" + (2 * CCFx + 1)));
            IJ.showProgress((int)(count + 1), (int)(2 * CCFx + 1));
            if (IJ.escapePressed()) {
                IJ.showStatus((String)"Task canceled by user");
                IJ.showProgress((int)2, (int)1);
                return;
            }
            double meanA = 0.0;
            double meanB = 0.0;
            double nPoints = 0.0;
            for (k = 1; k <= this.nbSlices; ++k) {
                for (j = 0; j < this.height; ++j) {
                    for (i = 0; i < this.width; ++i) {
                        if (i + l < 0 || i + l >= this.width) continue;
                        coord = this.offset(i, j, k);
                        coordShift = this.offset(i + l, j, k);
                        meanA += (double)this.A[coord];
                        meanB += (double)this.B[coordShift];
                        nPoints += 1.0;
                    }
                }
            }
            meanA /= nPoints;
            meanB /= nPoints;
            double num = 0.0;
            double den1 = 0.0;
            double den2 = 0.0;
            for (k = 1; k <= this.nbSlices; ++k) {
                for (j = 0; j < this.height; ++j) {
                    for (i = 0; i < this.width; ++i) {
                        if (i + l < 0 || i + l >= this.width) continue;
                        coord = this.offset(i, j, k);
                        coordShift = this.offset(i + l, j, k);
                        num += ((double)this.A[coord] - meanA) * ((double)this.B[coordShift] - meanB);
                        den1 += Math.pow((double)this.A[coord] - meanA, 2.0);
                        den2 += Math.pow((double)this.B[coordShift] - meanB, 2.0);
                    }
                }
            }
            double CCF = num / Math.sqrt(den1 * den2);
            if (l == -CCFx) {
                CCFmin = CCF;
                CCFmax = CCF;
            } else {
                if (CCF < CCFmin) {
                    CCFmin = CCF;
                    lmin = l;
                }
                if (CCF > CCFmax) {
                    CCFmax = CCF;
                    lmax = l;
                }
            }
            x[count] = l;
            CCFarray[count] = CCF;
            ++count;
        }
        IJ.log((String)("CCF min.: " + this.round(CCFmin, 3) + " (obtained for dx=" + lmin + ") CCF max.: " + this.round(CCFmax, 3) + " (obtained for dx=" + lmax + ")"));
        this.cff_plot = new Plot("Van Steensel's CCF between " + this.titleA + " and " + this.titleB, "dx", "CCF", x, CCFarray);
        this.cff_plot.setLimits((double)(-CCFx), (double)CCFx, CCFmin - (CCFmax - CCFmin) * 0.05, CCFmax + (CCFmax - CCFmin) * 0.05);
        this.cff_plot.setColor(Color.white);
        this.cff_plot.draw();
        this.cff_plot.setColor(Color.black);
        this.cff_plot.addPoints(x, CCFarray, 0);
        double[] xline = new double[]{0.0, 0.0};
        double[] yline = new double[]{CCFmin - (CCFmax - CCFmin) * 0.05, CCFmax + (CCFmax - CCFmin) * 0.05};
        this.cff_plot.setColor(Color.red);
        this.cff_plot.addPoints(xline, yline, 2);
        CurveFitter cf = new CurveFitter(x, CCFarray);
        double[] param = new double[]{CCFmin, CCFmax, lmax, CCFx};
        cf.setInitialParameters(param);
        cf.doFit(12);
        param = cf.getParams();
        IJ.log((String)("\nResults for fitting CCF on a Gaussian (CCF=a+(b-a)exp(-(xshift-c)^2/(2d^2))):" + cf.getResultString() + "\nFWHM=" + Math.abs(this.round(2.0 * Math.sqrt(2.0 * Math.log(2.0)) * param[3], 3)) + " pixels"));
        for (int i = 0; i < x.length; ++i) {
            CCFarray[i] = CurveFitter.f((int)12, (double[])param, (double)x[i]);
        }
        this.cff_plot.setColor(Color.BLUE);
        this.cff_plot.addPoints(x, CCFarray, 2);
        IJ.showStatus((String)"");
        IJ.showProgress((int)2, (int)1);
        this.rt.addValue("CCF Min", CCFmin);
        this.rt.addValue("CCF Min DX Location", (double)lmin);
        this.rt.addValue("CCF Max", CCFmax);
        this.rt.addValue("CCF Max DX Location", (double)lmax);
        this.rt.addValue("CCF Fit FWHM", Math.abs(2.0 * Math.sqrt(2.0 * Math.log(2.0)) * param[3]));
    }

    public void CytoFluo() {
        double[] Adb = this.int2double(this.A);
        double[] Bdb = this.int2double(this.B);
        this.fluorogram_plot = new Plot("Cytofluorogram between " + this.titleA + " and " + this.titleB, this.titleA, this.titleB, Adb, Bdb);
        double limHigh = Math.max(this.Amax, this.Bmax);
        double limLow = Math.min(this.Amin, this.Bmin);
        this.fluorogram_plot.setLimits((double)this.Amin, (double)this.Amax, (double)this.Bmin, (double)this.Bmax);
        this.fluorogram_plot.setColor(Color.white);
        this.doThat = true;
        double[] tmp = this.linreg(this.A, this.B, 0, 0);
        double a = tmp[0];
        double b = tmp[1];
        double CoeffCorr = tmp[2];
        this.fluorogram_plot.draw();
        this.fluorogram_plot.setColor(Color.black);
        this.fluorogram_plot.addPoints(Adb, Bdb, 6);
        double[] xline = new double[]{limLow, limHigh};
        double[] yline = new double[]{a * limLow + b, a * limHigh + b};
        this.fluorogram_plot.setColor(Color.red);
        this.fluorogram_plot.addPoints(xline, yline, 2);
        IJ.log((String)("\nCytofluorogram's parameters:\na: " + this.round(a, 3) + "\nb: " + this.round(b, 3) + "\nCorrelation coefficient: " + this.round(CoeffCorr, 3)));
    }

    public void ICA() {
        int i;
        double[] Anorm = new double[this.length];
        double[] Bnorm = new double[this.length];
        double AnormMean = 0.0;
        double BnormMean = 0.0;
        double prodMin = 0.0;
        double prodMax = 0.0;
        double[] x = new double[this.length];
        double ICQ = 0.0;
        for (i = 0; i < this.length; ++i) {
            Anorm[i] = (double)(this.A[i] - this.Amin) / (double)this.Amax;
            Bnorm[i] = (double)(this.B[i] - this.Bmin) / (double)this.Bmax;
            AnormMean += Anorm[i];
            BnormMean += Bnorm[i];
        }
        AnormMean /= (double)this.length;
        BnormMean /= (double)this.length;
        for (i = 0; i < this.length; ++i) {
            x[i] = (Anorm[i] - AnormMean) * (Bnorm[i] - BnormMean);
            if (x[i] > prodMax) {
                prodMax = x[i];
            }
            if (x[i] < prodMin) {
                prodMin = x[i];
            }
            if (!(x[i] > 0.0)) continue;
            ICQ += 1.0;
        }
        double lim = Math.max(Math.abs(prodMin), Math.abs(prodMax));
        ICQ = ICQ / (double)this.length - 0.5;
        this.ica_a_plot = new Plot("ICA A (" + this.titleA + ")", "(Ai-a)(Bi-b)", this.titleA, new double[]{0.0, 0.0}, new double[]{0.0, 0.0});
        this.ica_a_plot.setColor(Color.white);
        this.ica_a_plot.setLimits(-lim, lim, 0.0, 1.0);
        this.ica_a_plot.draw();
        this.ica_a_plot.setColor(Color.black);
        this.ica_a_plot.addPoints(x, Anorm, 6);
        this.ica_a_plot.draw();
        this.ica_a_plot.setColor(Color.red);
        this.ica_a_plot.drawLine(0.0, 0.0, 0.0, 1.0);
        this.ica_b_plot = new Plot("ICA B (" + this.titleB + ")", "(Ai-a)(Bi-b)", this.titleB, new double[]{0.0, 0.0}, new double[]{0.0, 0.0});
        this.ica_b_plot.setColor(Color.white);
        this.ica_b_plot.setLimits(-lim, lim, 0.0, 1.0);
        this.ica_b_plot.draw();
        this.ica_b_plot.setColor(Color.black);
        this.ica_b_plot.addPoints(x, Bnorm, 6);
        this.ica_b_plot.setColor(Color.red);
        this.ica_b_plot.drawLine(0.0, 0.0, 0.0, 1.0);
        IJ.log((String)("\nLi's Intensity correlation coefficient:\nICQ: " + ICQ));
        this.rt.addValue("ICQ", ICQ);
    }

    public void RandomCostes2D(boolean binarize, int squareSize, int nShuffling, boolean showPlot, boolean showShuffledImage, boolean costesGraphBoundsUserSet, double xminCostesGraph, double xmaxCostesGraph) {
        this.randomCostes2D(this.impA, this.impB, squareSize, nShuffling, binarize, showPlot, showShuffledImage, costesGraphBoundsUserSet, xminCostesGraph, xmaxCostesGraph);
    }

    public RandomCostes randomCostes2D(ImagePlus imgA, ImagePlus imgB, int squareSize, int nShuffling, boolean threshold, boolean showPlot, boolean showSampleImage, boolean costesGraphBoundsUserSet, double xminCostesGraph, double xmaxCostesGraph) {
        RandomCostes rc = new RandomCostes(imgA, imgB, squareSize, nShuffling, threshold, this.thrA, this.thrB);
        rc.compute();
        if (threshold) {
            this.randomCostesMaskExampleShuffledImg = rc.getExampleShuffleImage();
        } else {
            this.randomCostesExampleShuffledImg = rc.getExampleShuffleImage();
        }
        if (showPlot) {
            if (threshold) {
                this.randomCostesMaskPlot = rc.getPearsonDistributionGraph(costesGraphBoundsUserSet, xminCostesGraph, xmaxCostesGraph).getImagePlus();
            } else {
                this.randomCostesPlot = rc.getPearsonDistributionGraph(costesGraphBoundsUserSet, xminCostesGraph, xmaxCostesGraph).getImagePlus();
            }
        }
        if (threshold) {
            this.rt.addValue("Random Pearson Costes 2D (Mask)", rc.pearsonNormalized);
            this.rt.addValue("Random Pearson Costes 2D (Mask) pValueCorrelated", rc.pValueIsCorrelated);
            this.rt.addValue("Random Pearson Costes 2D (Mask) pValueAntiCorrelated", rc.pValueIsAntiCorrelated);
            IJ.log((String)("\nNormalized random Pearson Costes 2D (Mask) nShuffle = " + nShuffling + " block Size = " + squareSize + " \nnpc=" + this.round(rc.pearsonNormalized, 3) + " \npValueCorrelated=" + rc.pValueIsCorrelated + " \npValueAntiCorrelated=" + rc.pValueIsAntiCorrelated));
        } else {
            this.rt.addValue("Random Pearson Costes 2D", rc.pearsonNormalized);
            this.rt.addValue("Random Pearson Costes 2D pValueCorrelated", rc.pValueIsCorrelated);
            this.rt.addValue("Random Pearson Costes 2D pValueAntiCorrelated", rc.pValueIsAntiCorrelated);
            IJ.log((String)("\nNormalized random Pearson Costes 2D nShuffle = " + nShuffling + " block Size = " + squareSize + " \nnpc=" + this.round(rc.pearsonNormalized, 3) + " \npValueCorrelated=" + rc.pValueIsCorrelated + " \npValueAntiCorrelated=" + rc.pValueIsAntiCorrelated));
        }
        return rc;
    }

    private void buildArray(ImagePlus imgA, ImagePlus imgB, ImageProcessor imgMask) {
        int index = 0;
        this.Amin = (int)Math.pow(2.0, this.depth);
        this.Amax = 0;
        this.Amean = 0.0;
        this.Bmin = this.Amin;
        this.Bmax = 0;
        this.Bmean = 0.0;
        for (int z = 1; z <= this.nbSlices; ++z) {
            imgA.setSlice(z);
            imgB.setSlice(z);
            ImageStatistics stA = imgA.getStatistics();
            ImageStatistics stB = imgB.getStatistics();
            this.Amin = Math.min(this.Amin, (int)stA.min);
            this.Bmin = Math.min(this.Bmin, (int)stB.min);
            this.Amax = Math.max(this.Amax, (int)stA.max);
            this.Bmax = Math.max(this.Bmax, (int)stB.max);
            this.Amean += (double)stA.pixelCount * stA.mean;
            this.Bmean += (double)stB.pixelCount * stB.mean;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.A[index] = imgA.getProcessor().getPixel(x, y);
                    this.B[index] = imgB.getProcessor().getPixel(x, y);
                    this.M[index] = imgMask.getPixel(x, y);
                    ++index;
                }
            }
            this.Amean /= (double)this.length;
            this.Bmean /= (double)this.length;
        }
    }

    public double[] linreg(int[] Aarray, int[] Barray, int TA, int TB) {
        int m;
        double num = 0.0;
        double den1 = 0.0;
        double den2 = 0.0;
        double[] coeff = new double[6];
        int count = 0;
        if (this.doThat) {
            this.sumA = 0.0;
            this.sumB = 0.0;
            this.sumAB = 0.0;
            this.sumsqrA = 0.0;
            this.Aarraymean = 0.0;
            this.Barraymean = 0.0;
            for (m = 0; m < Aarray.length; ++m) {
                if (Aarray[m] < TA || Barray[m] < TB || this.M[m] <= 0) continue;
                this.sumA += (double)Aarray[m];
                this.sumB += (double)Barray[m];
                this.sumAB += (double)(Aarray[m] * Barray[m]);
                this.sumsqrA += Math.pow(Aarray[m], 2.0);
                ++count;
            }
            this.Aarraymean = this.sumA / (double)count;
            this.Barraymean = this.sumB / (double)count;
        }
        for (m = 0; m < Aarray.length; ++m) {
            if (Aarray[m] < TA || Barray[m] < TB || this.M[m] <= 0) continue;
            num += ((double)Aarray[m] - this.Aarraymean) * ((double)Barray[m] - this.Barraymean);
            den1 += Math.pow((double)Aarray[m] - this.Aarraymean, 2.0);
            den2 += Math.pow((double)Barray[m] - this.Barraymean, 2.0);
        }
        coeff[0] = ((double)count * this.sumAB - this.sumA * this.sumB) / ((double)count * this.sumsqrA - Math.pow(this.sumA, 2.0));
        coeff[1] = (this.sumsqrA * this.sumB - this.sumA * this.sumAB) / ((double)count * this.sumsqrA - Math.pow(this.sumA, 2.0));
        coeff[2] = num / Math.sqrt(den1 * den2);
        coeff[3] = num;
        coeff[4] = den1;
        coeff[5] = den2;
        return coeff;
    }

    private double[] int2double(int[] input) {
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    private int offset(int x, int y, int z) {
        if (x + y * this.width + (z - 1) * this.width * this.height >= this.width * this.height * this.nbSlices) {
            return this.width * this.height * this.nbSlices - 1;
        }
        if (x + y * this.width + (z - 1) * this.width * this.height < 0) {
            return 0;
        }
        return x + y * this.width + (z - 1) * this.width * this.height;
    }

    public int offsetCostes(int m, int n, int o) {
        if (m + n * this.widthCostes + (o - 1) * this.widthCostes * this.heightCostes >= this.widthCostes * this.heightCostes * this.nbsliceCostes) {
            return this.widthCostes * this.heightCostes * this.nbsliceCostes - 1;
        }
        if (m + n * this.widthCostes + (o - 1) * this.widthCostes * this.heightCostes < 0) {
            return 0;
        }
        return m + n * this.widthCostes + (o - 1) * this.widthCostes * this.heightCostes;
    }

    public double round(double y, int z) {
        y *= Math.pow(10.0, z);
        y = (int)y;
        return y /= Math.pow(10.0, z);
    }

    public ImagePlus getFluorogramImage() {
        float[] minmax = this.getFluorogramMinMax();
        return this.getFluorogramImage(256, (int)Math.floor(minmax[0]), (int)Math.floor(minmax[1]));
    }

    public float[] getFluorogramMinMax() {
        Plot fp = this.getFluorogram();
        float[] valA = fp.getXValues();
        float[] valB = fp.getYValues();
        float minA = Float.MAX_VALUE;
        float maxA = 0.0f;
        float minB = Float.MAX_VALUE;
        float maxB = 0.0f;
        for (int i = 0; i < valA.length; ++i) {
            if (minA > valA[i]) {
                minA = valA[i];
            }
            if (minB > valB[i]) {
                minB = valB[i];
            }
            if (maxA < valA[i]) {
                maxA = valA[i];
            }
            if (!(maxB < valB[i])) continue;
            maxB = valB[i];
        }
        float min = Math.min(minA, minB);
        float max = Math.max(maxA, maxB);
        return new float[]{min, max};
    }

    public ImagePlus getFluorogramImage(int nbins, int min, int max) {
        Plot fp = this.getFluorogram();
        float[] valA = fp.getXValues();
        float[] valB = fp.getYValues();
        int lut_size = 15;
        FloatProcessor fluo_ip = new FloatProcessor(nbins, nbins);
        fluo_ip.set(0.0);
        ShortProcessor grad_A = new ShortProcessor(nbins, lut_size);
        ShortProcessor grad_B = new ShortProcessor(lut_size, nbins);
        ColorProcessor fluo = new ColorProcessor(nbins + lut_size + 1, nbins + lut_size + 1);
        for (int i = 0; i < valA.length; ++i) {
            int binA = (int)Math.round(((double)valA[i] - (double)min) / (double)max * (double)(nbins - 1));
            int binB = (int)Math.round(((double)valB[i] - (double)min) / (double)max * (double)(nbins - 1));
            if (binA >= nbins || binB >= nbins || binA < 0 || binB < 0) continue;
            fluo_ip.setf(binA, nbins - binB - 1, fluo_ip.getPixelValue(binA, nbins - binB - 1) + 1.0f);
        }
        fluo_ip.log();
        int binWidth = (int)Math.round((double)(max - min) / (double)(nbins - 1));
        for (int i = 0; i < nbins; ++i) {
            for (int j = 0; j < lut_size; ++j) {
                int val = (i + 1) * binWidth;
                grad_A.set(i, j, val);
                grad_B.set(j, nbins - i - 1, val);
            }
        }
        grad_A.setLut(this.impA.getLuts()[0]);
        grad_B.setLut(this.impB.getLuts()[0]);
        fluo_ip.setLut(ImageColocalizer.fireLUT());
        fluo_ip.setMinAndMax(0.0, 6.0);
        fluo_ip.convertToRGB();
        int thrAb = (int)Math.round(((double)this.thrA - (double)min) / (double)max * (double)(nbins - 1));
        int thrBb = (int)Math.round(((double)this.thrB - (double)min) / (double)max * (double)(nbins - 1));
        fluo_ip.setColor(new Color(255, 255, 255));
        fluo_ip.drawLine(thrAb, nbins, thrAb, 0);
        fluo_ip.drawLine(0, nbins - thrBb - 1, nbins, nbins - thrBb - 1);
        fluo.copyBits(grad_A.convertToRGB(), lut_size + 1, nbins + 1, 3);
        fluo.copyBits(grad_B.convertToRGB(), 0, 0, 3);
        fluo.copyBits((ImageProcessor)fluo_ip, lut_size + 1, 0, 3);
        return new ImagePlus(fp.getTitle(), (ImageProcessor)fluo);
    }

    public void showResults() {
        this.rt.show("Results");
    }

    public Plot getCFFPlot() {
        return this.cff_plot;
    }

    public Plot getICAaPlot() {
        return this.ica_a_plot;
    }

    public Plot getICAbPlot() {
        return this.ica_b_plot;
    }

    public Plot getFluorogram() {
        return this.fluorogram_plot;
    }

    public void setThresholds(int thrA, int thrB) {
        this.thrA = thrA;
        this.thrB = thrB;
        if (this.roi != null) {
            for (int i = 0; i < this.impA.getStackSize(); ++i) {
                this.impA.getStack().getProcessor(i + 1).setMask(this.mask);
                this.impB.getStack().getProcessor(i + 1).setMask(this.mask);
            }
            this.impA.setRoi(this.roi);
            this.impB.setRoi(this.roi);
        }
        this.impA.getProcessor().setThreshold((double)this.thrA, this.impA.getProcessor().getMaxThreshold(), 2);
        this.impB.getProcessor().setThreshold((double)this.thrB, this.impB.getProcessor().getMaxThreshold(), 2);
    }

    public int getThresholdA() {
        return this.thrA;
    }

    public int getThresholdB() {
        return this.thrB;
    }

    public void setThresholds(String thrMetA, String thrMetB) {
        double[][] rangeA = Utils.getDisplayRange(this.impA);
        double[][] rangeB = Utils.getDisplayRange(this.impB);
        if (this.roi != null) {
            for (int i = 0; i < this.impA.getStackSize(); ++i) {
                this.impA.getStack().getProcessor(i + 1).setMask(this.mask);
                this.impB.getStack().getProcessor(i + 1).setMask(this.mask);
            }
        }
        if (thrMetA.matches("\\d*")) {
            this.thrA = Integer.parseInt(thrMetA);
            this.impA.getProcessor().setThreshold((double)this.thrA, this.impA.getProcessor().getMaxThreshold(), 0);
            this.impA.setRoi(this.roi);
        } else {
            this.impA.getProcessor().resetThreshold();
            this.impA.setRoi(this.roi);
            if (this.impA.getNSlices() > 1) {
                IJ.setAutoThreshold((ImagePlus)this.impA, (String)(thrMetA + " dark stack"));
            } else {
                IJ.setAutoThreshold((ImagePlus)this.impA, (String)(thrMetA + " dark"));
            }
            this.thrA = (int)this.impA.getProcessor().getMinThreshold();
        }
        if (thrMetB.matches("\\d*")) {
            this.thrB = Integer.parseInt(thrMetB);
            this.impB.getProcessor().setThreshold((double)this.thrB, this.impB.getProcessor().getMaxThreshold(), 0);
            this.impB.setRoi(this.roi);
        } else {
            this.impB.getProcessor().resetThreshold();
            this.impB.setRoi(this.roi);
            if (this.impB.getNSlices() > 1) {
                IJ.setAutoThreshold((ImagePlus)this.impB, (String)(thrMetB + " dark stack"));
            } else {
                IJ.setAutoThreshold((ImagePlus)this.impB, (String)(thrMetB + " dark"));
            }
            this.thrB = (int)this.impB.getProcessor().getMinThreshold();
        }
        this.rt.addValue("Auto Threshold A", thrMetA);
        this.rt.addValue("Auto Threshold B", thrMetB);
        Utils.setDisplayRange(this.impA, rangeA);
        Utils.setDisplayRange(this.impB, rangeB);
    }

    public ImagePlus getImageA() {
        return this.impA;
    }

    public ImagePlus getImageB() {
        return this.impB;
    }

    public ImagePlus getRGBImage(ImagePlus imp, Boolean is_zProject, float strokeWidth) {
        imp.killRoi();
        ImagePlus impr = imp.duplicate();
        impr.setTitle(imp.getTitle());
        if (is_zProject.booleanValue()) {
            ZProjector zp = new ZProjector(impr);
            zp.setMethod(1);
            zp.doHyperStackProjection(true);
            impr = zp.getProjection();
        }
        return this.flattenRoi(impr, strokeWidth);
    }

    public ImagePlus getRandomCostesMaskPlot(Boolean is_Z, float strokeWidth) {
        return this.getRGBImage(this.impA, is_Z, strokeWidth);
    }

    public ImagePlus getRGBImageA(Boolean is_Z, float strokeWidth) {
        return this.getRGBImage(this.impA, is_Z, strokeWidth);
    }

    public ImagePlus getRGBImageB(Boolean is_Z, float strokeWidth) {
        return this.getRGBImage(this.impB, is_Z, strokeWidth);
    }

    public ImagePlus getRGBColocImage(float strokeWidth) {
        ImagePlus[] images = new ImagePlus[]{this.impA, this.impB};
        ImagePlus comp = RGBStackMerge.mergeChannels((ImagePlus[])images, (boolean)true);
        return this.flattenRoi(comp, strokeWidth);
    }

    public ImagePlus getMaskA() {
        return Utils.binarize(this.impA, this.thrA);
    }

    public ImagePlus getMaskB() {
        return Utils.binarize(this.impB, this.thrB);
    }

    public ImagePlus getRGBMaskA(float strokeWidth) {
        return this.flattenRoi(Utils.binarize(this.impA, this.thrA), strokeWidth);
    }

    public ImagePlus getRGBMaskB(float strokeWidth) {
        return this.flattenRoi(Utils.binarize(this.impB, this.thrB), strokeWidth);
    }

    public ImagePlus getANDMask() {
        ImagePlus impMA = this.getMaskA();
        ImagePlus impMB = this.getMaskB();
        ImagePlus impAND = new ImagePlus(this.impA.getTitle() + " AND " + this.impB.getTitle(), impMA.getStack());
        int nSlices = impMA.getStackSize();
        if (nSlices > 1) {
            ImageStack stackA = impMA.getStack();
            ImageStack stackB = impMB.getStack();
            ImageStack andStack = impMA.createEmptyStack();
            for (int i = 1; i <= nSlices; ++i) {
                ImageProcessor ip = stackA.getProcessor(i).duplicate();
                ip.copyBits(stackB.getProcessor(i), 0, 0, 9);
                andStack.addSlice(ip);
            }
            impAND.setStack(andStack);
            return impAND;
        }
        ImageProcessor ip = impMA.getProcessor().duplicate();
        ip.copyBits(impMB.getProcessor(), 0, 0, 9);
        impAND.setProcessor(ip);
        return impAND;
    }

    public ImagePlus getRGBANDMask(float strokeWidth) {
        return this.flattenRoi(this.getANDMask(), strokeWidth);
    }

    private ImagePlus flattenRoi(ImagePlus imp, float strokeWidth) {
        if (this.roi != null) {
            if (strokeWidth > 0.0f) {
                this.roi.setStrokeColor(Color.white);
                this.roi.setStrokeWidth(strokeWidth);
                imp.setOverlay(new Overlay(this.roi));
                imp.setHideOverlay(false);
            }
        } else {
            imp.setOverlay(new Roi(1, 1, 1, 1), new Color(0, 0, 0, 0), 1, new Color(0, 0, 0, 0));
            imp.setHideOverlay(false);
        }
        if (imp.getStackSize() > 1) {
            imp.flattenStack();
        } else {
            imp = imp.flatten();
        }
        return imp;
    }

    public void addResult(String name, int value) {
        this.rt.addValue(name, (double)value);
    }

    public void addResult(String name, double value) {
        this.rt.addValue(name, value);
    }

    public void addResult(String name, String value) {
        this.rt.addValue(name, value);
    }

    public void removeLastRow() {
        this.rt.deleteRow(this.rt.getCounter() - 1);
    }

    public static LUT fireLUT() {
        int[] r = new int[]{0, 0, 1, 25, 49, 73, 98, 122, 146, 162, 173, 184, 195, 207, 217, 229, 240, 252, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] g = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 35, 57, 79, 101, 117, 133, 147, 161, 175, 190, 205, 219, 234, 248, 255, 255, 255, 255};
        int[] b = new int[]{0, 61, 96, 130, 165, 192, 220, 227, 210, 181, 151, 122, 93, 64, 35, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 98, 160, 223, 255};
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        for (int i = 0; i < r.length; ++i) {
            reds[i] = (byte)r[i];
            greens[i] = (byte)g[i];
            blues[i] = (byte)b[i];
        }
        ImageColocalizer.interpolate(reds, greens, blues, r.length);
        return new LUT(reds, greens, blues);
    }

    private static void interpolate(byte[] reds, byte[] greens, byte[] blues, int nColors) {
        byte[] r = new byte[nColors];
        byte[] g = new byte[nColors];
        byte[] b = new byte[nColors];
        System.arraycopy(reds, 0, r, 0, nColors);
        System.arraycopy(greens, 0, g, 0, nColors);
        System.arraycopy(blues, 0, b, 0, nColors);
        double scale = (double)nColors / 256.0;
        for (int i = 0; i < 256; ++i) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == nColors) {
                i2 = nColors - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)(r[i1] & 0xFF) + fraction * (double)(r[i2] & 0xFF));
            greens[i] = (byte)((1.0 - fraction) * (double)(g[i1] & 0xFF) + fraction * (double)(g[i2] & 0xFF));
            blues[i] = (byte)((1.0 - fraction) * (double)(b[i1] & 0xFF) + fraction * (double)(b[i2] & 0xFF));
        }
    }
}

